/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.generator;

import com.sun.jdo.api.persistence.enhancer.LogHelperEnhancer;
import com.sun.jdo.api.persistence.enhancer.generator.ImplHelper;
import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataPropertyImpl;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.JavaFileWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaFileWriter;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;

public final class Main
extends Assertion {
    private static final Logger logger = LogHelperEnhancer.getLogger();
    private static final String dotLine = "----------------------------------------------------------------------";
    private final PrintWriter out = new PrintWriter(System.out, true);
    private final PrintWriter err = new PrintWriter(System.err, true);
    private final CmdLineOptions opts = new CmdLineOptions();
    private JavaFileWriter fWriter = null;
    private JavaClassWriter writer = null;
    private ExtendedJDOMetaData meta = null;
    private File destinationDir = null;
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.api.persistence.enhancer.Bundle");

    public Main() {
    }

    public Main(ExtendedJDOMetaData extendedJDOMetaData, File file) throws IOException {
        this.meta = extendedJDOMetaData;
        this.destinationDir = file;
        this.createDestinationDir();
    }

    public static final void main(String[] stringArray) {
        Main main = new Main();
        try {
            main.opts.processArgs(stringArray);
            main.init();
            main.generate();
        }
        catch (Exception exception) {
            main.printError(null, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void init() throws FileNotFoundException, IOException {
        Main.affirm(this.opts.jdoPropertiesFileName != null);
        var1_1 = null;
        try {
            var2_2 = new File(this.opts.jdoPropertiesFileName);
            var1_1 = new FileInputStream(var2_2);
            var3_3 = new Properties();
            var3_3.load(var1_1);
            this.meta = new JDOMetaDataPropertyImpl(var3_3, this.out);
            var5_4 = null;
            ** if (var1_1 == null) goto lbl-1000
        }
        catch (Throwable var4_8) {
            var5_5 = null;
            if (var1_1 != null) {
                try {
                    var1_1.close();
                }
                catch (Exception var6_7) {
                    this.printError(var6_7.getMessage(), var6_7);
                }
            }
            throw var4_8;
        }
lbl-1000:
        // 1 sources

        {
            try {
                var1_1.close();
            }
            catch (Exception var6_6) {
                this.printError(var6_6.getMessage(), var6_6);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        Main.affirm(this.opts.destinationDirectory != null);
        this.destinationDir = new File(this.opts.destinationDirectory);
        this.createDestinationDir();
    }

    private void createDestinationDir() throws IOException {
        if (!this.destinationDir.exists() && !this.destinationDir.mkdirs()) {
            throw new IOException(I18NHelper.getMessage(messages, "EXC_DestDirCreateFailure", this.destinationDir));
        }
    }

    private void generate() throws IOException {
        String[] stringArray = this.meta.getKnownClasses();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.generate(string);
        }
    }

    public File generate(String string) throws IOException {
        Main.affirm(string != null);
        this.printMessage("generating '" + string + "'...");
        String string2 = string.replace('/', File.separatorChar);
        String string3 = string2 + ".java";
        File file = new File(this.destinationDir, string3);
        this.fWriter = new IOJavaFileWriter(file);
        this.writer = new IOJavaClassWriter();
        this.generateClass(string);
        this.fWriter.addClass(this.writer);
        this.printMessage("DONE generating '" + string + "'...");
        this.fWriter.save();
        return file;
    }

    private void generateClass(String string) throws IOException {
        boolean bl;
        Main.affirm(string != null);
        String string2 = ImplHelper.getPackageName(string);
        this.fWriter.setPackage(string2, null);
        String string3 = this.meta.getKeyClass(string);
        if (string3 == null) {
            this.writeClassHeader(string);
        } else {
            String string4 = ImplHelper.getPackageName(string3);
            Main.affirm(string2.equals(string4), "PC class and key class must be in same package.");
            bl = string3.startsWith(string + "$");
            if (bl) {
                this.writeClassHeader(string);
                this.writeOidClass(string, ImplHelper.getClassName(string3), bl);
            } else {
                this.writeOidClass(string, ImplHelper.getClassName(string3), bl);
                this.writeClassHeader(string);
            }
        }
        this.writeClassMembers(string);
        boolean bl2 = this.meta.isPersistenceCapableClass(string);
        if (bl2) {
            bl = this.meta.isPersistenceCapableRootClass(string);
            if (bl) {
                this.writePCRootMembers(string);
            }
            this.writePCMembers(string);
        }
    }

    private void writeClassHeader(String string) throws IOException {
        String[] stringArray;
        boolean bl = this.meta.isPersistenceCapableRootClass(string);
        String string2 = ImplHelper.normalizeClassName(this.meta.getSuperClass(string));
        String[] stringArray2 = null;
        if (bl) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable";
        } else {
            stringArray = null;
        }
        String[] stringArray4 = stringArray;
        this.writer.setClassDeclaration(this.meta.getClassModifiers(string), ImplHelper.getClassName(string), stringArray2);
        this.writer.setSuperclass(string2);
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                this.writer.addInterface(stringArray4[i]);
            }
        }
    }

    private void writeClassMembers(String string) throws IOException {
        String string2;
        int n;
        String[] stringArray = new String[]{dotLine, "Class Members:", dotLine};
        this.writer.addConstructor(ImplHelper.getClassName(string), 1, null, null, null, ImplHelper.getDefaultConstructorImpl(), stringArray);
        String[] stringArray2 = this.meta.getKnownFields(string);
        int n2 = stringArray2 != null ? stringArray2.length : 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            string2 = stringArray2[n];
            int n3 = this.meta.getFieldModifiers(string, string2);
            if ((n3 & 8) != 0) continue;
            arrayList.add(string2);
        }
        this.writer.addMethod("clone", 1, "Object", null, null, new String[]{"java.lang.CloneNotSupportedException"}, ImplHelper.getCloneImpl(string), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        for (n = 0; n < n2; ++n) {
            string2 = stringArray2[n];
            this.writeFieldMember(string, string2);
        }
    }

    private void writeFieldMember(String string, String string2) throws IOException {
        String string3 = this.meta.getFieldType(string, string2);
        String string4 = ImplHelper.normalizeClassName(string3);
        int n = this.meta.getFieldNo(string, string2);
        boolean bl = this.meta.isDefaultFetchGroupField(string, string2);
        int n2 = this.meta.getFieldFlags(string, string2);
        int n3 = this.meta.getFieldModifiers(string, string2);
        this.writer.addField(string2, n3, string4, null, null);
        if ((n3 & 8) != 0) {
            return;
        }
        Main.affirm((n2 & 1) == 0 | (n2 & 2) == 0);
        String[] stringArray = (n2 & 1) != 0 ? ImplHelper.getFieldCheckReadImpl(string2, string3, n) : ((n2 & 2) != 0 ? ImplHelper.getFieldMediateReadImpl(string2, string3, n) : ImplHelper.getFieldDirectReadImpl(string2, string3, n));
        this.writer.addMethod(Main.createMethodName("get", string2), 1, string4, null, null, null, stringArray, ImplHelper.COMMENT_ENHANCER_ADDED);
        Main.affirm((n2 & 4) == 0 | (n2 & 8) == 0);
        stringArray = (n2 & 4) != 0 ? ImplHelper.getFieldCheckWriteImpl(string2, string3, n, string2) : ((n2 & 8) != 0 && !this.meta.isKnownNonManagedField(string, string2, null) ? ImplHelper.getFieldMediateWriteImpl(string2, string3, n, string2) : ImplHelper.getFieldDirectWriteImpl(string2, string3, n, string2));
        this.writer.addMethod(Main.createMethodName("set", string2), 1, "void", new String[]{string2}, new String[]{string4}, null, stringArray, ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCRootMembers(String string) throws IOException {
        String[] stringArray = new String[]{dotLine, "Augmentation for Persistence-Capable Root Classes (added by enhancer):", dotLine};
        this.writer.addConstructor(ImplHelper.getClassName(string), 1, new String[]{"jdoStateManager"}, new String[]{"com.sun.jdo.spi.persistence.support.sqlstore.StateManager"}, null, ImplHelper.getJDOConstructorSMImpl("jdoStateManager"), stringArray);
        this.writer.addField("jdoStateManager", 129, "com.sun.jdo.spi.persistence.support.sqlstore.StateManager", "null", ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addField("jdoFlags", 129, "byte", "0", ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetStateManager", 17, "com.sun.jdo.spi.persistence.support.sqlstore.StateManager", null, null, null, new String[]{"return jdoStateManager;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoSetStateManager", 17, "void", new String[]{"jdoStateManager"}, new String[]{"com.sun.jdo.spi.persistence.support.sqlstore.StateManager"}, null, new String[]{"this.jdoStateManager = jdoStateManager;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetFlags", 17, "byte", null, null, null, new String[]{"return jdoFlags;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoSetFlags", 17, "void", new String[]{"jdoFlags"}, new String[]{"byte"}, null, new String[]{"this.jdoFlags = jdoFlags;"}, ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetPersistenceManager", 17, "com.sun.jdo.api.persistence.support.PersistenceManager", null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getPersistenceManager()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoGetObjectId", 17, Object.class.getName(), null, null, null, ImplHelper.getJDOStateManagerObjectDelegationImpl("getObjectId()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsPersistent", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isPersistent()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsTransactional", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isTransactional()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsNew", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isNew()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsDeleted", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isDeleted()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoIsDirty", 17, "boolean", null, null, null, ImplHelper.getJDOStateManagerBooleanDelegationImpl("isDirty()"), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoMakeDirty", 17, "void", new String[]{"fieldName"}, new String[]{String.class.getName()}, null, ImplHelper.getJDOStateManagerVoidDelegationImpl("makeDirty(fieldName)"), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writePCMembers(String string) throws IOException {
        String[] stringArray = new String[]{dotLine, "Augmentation for Persistence-Capable Classes (added by enhancer):", dotLine};
        String[] stringArray2 = this.meta.getManagedFields(string);
        String[] stringArray3 = this.meta.getFieldType(string, stringArray2);
        boolean bl = this.meta.isPersistenceCapableRootClass(string);
        this.writer.addMethod("jdoGetField", 1, "Object", new String[]{"fieldNumber"}, new String[]{"int"}, null, ImplHelper.getJDOGetFieldImpl("fieldNumber", stringArray2, stringArray3), stringArray);
        this.writer.addMethod("jdoSetField", 1, "void", new String[]{"fieldNumber", "obj"}, new String[]{"int", "Object"}, null, ImplHelper.getJDOSetFieldImpl("fieldNumber", "obj", stringArray2, stringArray3), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoClear", 1, "void", null, null, null, ImplHelper.getJDOClearImpl(string, this.meta, stringArray2, stringArray3), ImplHelper.COMMENT_ENHANCER_ADDED);
        this.writer.addMethod("jdoNewInstance", 1, "Object", new String[]{"sm"}, new String[]{"com.sun.jdo.spi.persistence.support.sqlstore.StateManager"}, null, ImplHelper.getJDONewInstanceImpl(string, "sm"), ImplHelper.COMMENT_ENHANCER_ADDED);
    }

    private void writeOidClass(String string, String string2, boolean bl) throws IOException {
        String[] stringArray = new String[]{dotLine, "Key Class:", dotLine};
        String string3 = ImplHelper.normalizeClassName(this.meta.getSuperKeyClass(string));
        IOJavaClassWriter iOJavaClassWriter = new IOJavaClassWriter();
        iOJavaClassWriter.setClassDeclaration(bl ? 9 : 0, string2, ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        iOJavaClassWriter.setSuperclass(string3);
        iOJavaClassWriter.addInterface(Serializable.class.getName());
        boolean bl2 = this.meta.isPersistenceCapableRootClass(string);
        String[] stringArray2 = this.meta.getKeyFields(string);
        String[] stringArray3 = this.meta.getFieldType(string, stringArray2);
        for (int i = 0; i < stringArray2.length; ++i) {
            iOJavaClassWriter.addField(stringArray2[i], 1, ImplHelper.normalizeClassName(stringArray3[i]), null, null);
        }
        iOJavaClassWriter.addConstructor(string2, 1, null, null, null, ImplHelper.getDefaultConstructorImpl(), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        iOJavaClassWriter.addMethod("hashCode", 1, "int", null, null, null, ImplHelper.getOidHashCodeImpl(stringArray2, stringArray3, bl2), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        iOJavaClassWriter.addMethod("equals", 1, "boolean", new String[]{"pk"}, new String[]{Object.class.getName()}, null, ImplHelper.getOidEqualsImpl(string2, stringArray2, stringArray3, "pk", bl2), ImplHelper.COMMENT_NOT_ENHANCER_ADDED);
        if (bl) {
            this.writer.addClass(iOJavaClassWriter);
        } else {
            this.fWriter.addClass(iOJavaClassWriter);
        }
    }

    private static String createMethodName(String string, String string2) {
        return string + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
    }

    private void printMessage(String string) {
        logger.finest("TP PCClassGen: " + string);
    }

    private void printError(String string, Throwable throwable) {
        if (string != null) {
            String string2 = string + (throwable != null ? ": " + throwable.getMessage() : "");
            logger.log(1000, "CME.generic_exception", string2);
        }
        if (throwable != null) {
            logger.log(1000, "CME.generic_exception_stack", throwable);
        }
    }

    private class CmdLineOptions {
        String destinationDirectory = null;
        String jdoXMLModelFileName = null;
        String jdoPropertiesFileName = null;
        boolean verbose = false;

        private CmdLineOptions() {
        }

        public void usage() {
            Main.this.err.println("Usage: Main <options> <arguments>...");
            Main.this.err.println("Options:");
            Main.this.err.println("  -v, --verbose            print verbose output");
            Main.this.err.println("  -d, --dest <dir>         destination directory for output files");
            Main.this.err.println("  -p, --properties <file>  use property file for meta data");
            Main.this.err.println();
            Main.this.err.println("Arguments:");
            Main.this.err.println();
            Main.this.err.println("Returns a non-zero value in case of errors.");
            System.exit(1);
        }

        protected int processArgs(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equals("-v") || string.equals("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (string.equals("-d") || string.equals("--dest")) {
                    if (stringArray.length - i < 2) {
                        Main.this.printError("Missing argument to the -d/-dest option", null);
                        this.usage();
                    }
                    this.destinationDirectory = stringArray[++i];
                    continue;
                }
                if (string.equals("-p") || string.equals("--properties")) {
                    if (stringArray.length - i < 2) {
                        Main.this.printError("Missing argument to the -p/--properties option", null);
                        this.usage();
                    }
                    this.jdoPropertiesFileName = stringArray[++i];
                    continue;
                }
                if (string.length() > 0 && string.charAt(0) == '-') {
                    Main.this.printError("Unrecognized option:" + string, null);
                    this.usage();
                }
                if (string.length() != 0) continue;
                Main.this.printMessage("Ignoring empty command line argument.");
            }
            if (this.jdoPropertiesFileName == null) {
                Main.this.printError("No destination directory specified", null);
                this.usage();
            }
            if (this.destinationDirectory == null) {
                Main.this.printError("No destination directory specified", null);
                this.usage();
            }
            return 0;
        }
    }
}

