/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.LocalVariable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class LocalVariableTableAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "LocalVariableTable";
    private Vector localTable;

    Enumeration variables() {
        return this.localTable.elements();
    }

    public LocalVariableTableAttribute(ConstUtf8 constUtf8, Vector vector) {
        super(constUtf8);
        this.localTable = vector;
    }

    static LocalVariableTableAttribute read(ConstUtf8 constUtf8, DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        Vector<LocalVariable> vector = new Vector<LocalVariable>();
        while (n-- > 0) {
            vector.addElement(LocalVariable.read(dataInputStream, codeEnv));
        }
        return new LocalVariableTableAttribute(constUtf8, vector);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(this.localTable.size());
        for (int i = 0; i < this.localTable.size(); ++i) {
            ((LocalVariable)this.localTable.elementAt(i)).write(dataOutputStream2);
        }
        dataOutputStream2.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray, 0, byArray.length);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println("LocalVariables: ");
        for (int i = 0; i < this.localTable.size(); ++i) {
            ((LocalVariable)this.localTable.elementAt(i)).print(printStream, n + 2);
        }
    }
}

