/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LineNumberTableAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "LineNumberTable";
    private short[] lineNumbers;
    private InsnTarget[] targets;

    public LineNumberTableAttribute(ConstUtf8 constUtf8, short[] sArray, InsnTarget[] insnTargetArray) {
        super(constUtf8);
        this.lineNumbers = sArray;
        this.targets = insnTargetArray;
    }

    static LineNumberTableAttribute read(ConstUtf8 constUtf8, DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        short[] sArray = new short[n];
        InsnTarget[] insnTargetArray = new InsnTarget[n];
        for (int i = 0; i < n; ++i) {
            insnTargetArray[i] = codeEnv.getTarget(dataInputStream.readShort());
            sArray[i] = dataInputStream.readShort();
        }
        return new LineNumberTableAttribute(constUtf8, sArray, insnTargetArray);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        int n = this.lineNumbers.length;
        dataOutputStream.writeInt(2 + 4 * n);
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeShort(this.targets[i].offset());
            dataOutputStream.writeShort(this.lineNumbers[i]);
        }
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println("Line Numbers: ");
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            ClassPrint.spaces(printStream, n + 2);
            printStream.println(Integer.toString(this.lineNumbers[i]) + " @ " + Integer.toString(this.targets[i].offset()));
        }
    }
}

