/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.PrintStream;

public class InsnTableSwitch
extends Insn {
    private int lowOp;
    private InsnTarget defaultOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        for (int i = 0; i < this.targetsOp.length; ++i) {
            this.targetsOp[i].setBranchTarget();
        }
    }

    public int lowCase() {
        return this.lowOp;
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnTableSwitch(int n, InsnTarget insnTarget, InsnTarget[] insnTargetArray) {
        this(n, insnTarget, insnTargetArray, -1);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  opc_tableswitch  ");
        for (int i = 0; i < this.targetsOp.length; ++i) {
            int n2 = i + this.lowOp;
            if (this.targetsOp[i].offset() == this.defaultOp.offset()) continue;
            ClassPrint.spaces(printStream, n + 2);
            printStream.println(n2 + " -> " + this.targetsOp[i].offset());
        }
        ClassPrint.spaces(printStream, n + 2);
        printStream.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = (byte)this.opcode();
        n = n + 3 & 0xFFFFFFFC;
        n = InsnTableSwitch.storeInt(byArray, n, this.defaultOp.offset() - this.offset());
        n = InsnTableSwitch.storeInt(byArray, n, this.lowOp);
        n = InsnTableSwitch.storeInt(byArray, n, this.lowOp + this.targetsOp.length - 1);
        for (int i = 0; i < this.targetsOp.length; ++i) {
            n = InsnTableSwitch.storeInt(byArray, n, this.targetsOp[i].offset() - this.offset());
        }
        return n;
    }

    int size() {
        int n = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 12;
        return n + this.targetsOp.length * 4;
    }

    InsnTableSwitch(int n, InsnTarget insnTarget, InsnTarget[] insnTargetArray, int n2) {
        super(170, n2);
        this.lowOp = n;
        this.defaultOp = insnTarget;
        this.targetsOp = insnTargetArray;
        if (insnTarget == null || insnTargetArray == null) {
            throw new InsnError("attempt to create an opc_tableswitch with invalid operands");
        }
    }

    static InsnTableSwitch read(InsnReadEnv insnReadEnv, int n) {
        int n2 = n + 1;
        for (int i = (n2 + 3 & 0xFFFFFFFC) - n2; i > 0; --i) {
            insnReadEnv.getByte();
        }
        InsnTarget insnTarget = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
        int n3 = insnReadEnv.getInt();
        int n4 = insnReadEnv.getInt();
        InsnTarget[] insnTargetArray = new InsnTarget[n4 - n3 + 1];
        for (int i = 0; i < insnTargetArray.length; ++i) {
            insnTargetArray[i] = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
        }
        return new InsnTableSwitch(n3, insnTarget, insnTargetArray, n);
    }
}

