/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import java.io.PrintStream;

public class InsnMultiDimArrayNew
extends Insn {
    private ConstClass classOp;
    private int nDimsOp;

    public boolean isSimpleLoad() {
        return false;
    }

    public int nStackArgs() {
        return this.nDimsOp;
    }

    public int nStackResults() {
        return 1;
    }

    public String argTypes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nDimsOp; ++i) {
            stringBuffer.append("I");
        }
        return stringBuffer.toString();
    }

    public String resultTypes() {
        return "A";
    }

    public boolean branches() {
        return false;
    }

    public ConstClass arrayClass() {
        return this.classOp;
    }

    public void setArrayClass(ConstClass constClass) {
        this.classOp = constClass;
    }

    public int nDims() {
        return this.nDimsOp;
    }

    public InsnMultiDimArrayNew(ConstClass constClass, int n) {
        this(constClass, n, -1);
    }

    InsnMultiDimArrayNew(ConstClass constClass, int n, int n2) {
        super(197, n2);
        this.classOp = constClass;
        this.nDimsOp = n;
        if (constClass == null || n < 1) {
            throw new InsnError("attempt to create an opc_multianewarray with invalid operands");
        }
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  opc_multianewarray  pool(" + this.classOp.getIndex() + ")," + this.nDimsOp);
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = (byte)this.opcode();
        n = InsnMultiDimArrayNew.storeShort(byArray, n, (short)this.classOp.getIndex());
        byArray[n++] = (byte)this.nDimsOp;
        return n;
    }

    int size() {
        return 4;
    }

    static InsnMultiDimArrayNew read(InsnReadEnv insnReadEnv, int n) {
        ConstClass constClass = (ConstClass)insnReadEnv.pool().constantAt(insnReadEnv.getUShort());
        int n2 = insnReadEnv.getUByte();
        return new InsnMultiDimArrayNew(constClass, n2, n);
    }
}

