/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.PrintStream;

public class InsnLookupSwitch
extends Insn {
    private InsnTarget defaultOp;
    private int[] matchesOp;
    private InsnTarget[] targetsOp;

    public int nStackArgs() {
        return 1;
    }

    public int nStackResults() {
        return 0;
    }

    public String argTypes() {
        return "I";
    }

    public String resultTypes() {
        return "";
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.defaultOp.setBranchTarget();
        for (int i = 0; i < this.targetsOp.length; ++i) {
            this.targetsOp[i].setBranchTarget();
        }
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public int[] switchCases() {
        return this.matchesOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnLookupSwitch(InsnTarget insnTarget, int[] nArray, InsnTarget[] insnTargetArray) {
        this(insnTarget, nArray, insnTargetArray, -1);
    }

    InsnLookupSwitch(InsnTarget insnTarget, int[] nArray, InsnTarget[] insnTargetArray, int n) {
        super(171, n);
        this.defaultOp = insnTarget;
        this.matchesOp = nArray;
        this.targetsOp = insnTargetArray;
        if (insnTarget == null || insnTargetArray == null || nArray == null || insnTargetArray.length != nArray.length) {
            throw new InsnError("attempt to create an opc_lookupswitch with invalid operands");
        }
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  opc_lookupswitch  ");
        for (int i = 0; i < this.matchesOp.length; ++i) {
            ClassPrint.spaces(printStream, n + 2);
            printStream.println(this.matchesOp[i] + " -> " + this.targetsOp[i].offset());
        }
        ClassPrint.spaces(printStream, n + 2);
        printStream.println("default -> " + this.defaultOp.offset());
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = (byte)this.opcode();
        n = n + 3 & 0xFFFFFFFC;
        n = InsnLookupSwitch.storeInt(byArray, n, this.defaultOp.offset() - this.offset());
        n = InsnLookupSwitch.storeInt(byArray, n, this.targetsOp.length);
        for (int i = 0; i < this.targetsOp.length; ++i) {
            n = InsnLookupSwitch.storeInt(byArray, n, this.matchesOp[i]);
            n = InsnLookupSwitch.storeInt(byArray, n, this.targetsOp[i].offset() - this.offset());
        }
        return n;
    }

    int size() {
        int n = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 8;
        return n + this.targetsOp.length * 8;
    }

    static InsnLookupSwitch read(InsnReadEnv insnReadEnv, int n) {
        int n2 = n + 1;
        for (int i = (n2 + 3 & 0xFFFFFFFC) - n2; i > 0; --i) {
            insnReadEnv.getByte();
        }
        InsnTarget insnTarget = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
        int n3 = insnReadEnv.getInt();
        int[] nArray = new int[n3];
        InsnTarget[] insnTargetArray = new InsnTarget[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = insnReadEnv.getInt();
            insnTargetArray[i] = insnReadEnv.getTarget(insnReadEnv.getInt() + n);
        }
        return new InsnLookupSwitch(insnTarget, nArray, insnTargetArray, n);
    }
}

