/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasic;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasicMemberRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFieldRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstInterfaceMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstValue;
import com.sun.jdo.api.persistence.enhancer.classfile.Descriptor;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.VMOp;
import java.io.PrintStream;

public class InsnConstOp
extends Insn {
    private ConstBasic constValue;

    public int nStackArgs() {
        int n = VMOp.ops[this.opcode()].nStackArgs();
        if (n >= 0) {
            return n;
        }
        switch (this.opcode()) {
            case 179: 
            case 181: {
                ConstFieldRef constFieldRef = (ConstFieldRef)this.constValue;
                String string = constFieldRef.nameAndType().signature().asString();
                if (string.equals("J") || string.equals("D")) {
                    return this.opcode() == 181 ? 3 : 2;
                }
                return this.opcode() == 181 ? 2 : 1;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef constBasicMemberRef = (ConstBasicMemberRef)this.constValue;
                String string = constBasicMemberRef.nameAndType().signature().asString();
                int n2 = Descriptor.countMethodArgWords(string);
                return n2 + (this.opcode() == 184 ? 0 : 1);
            }
        }
        throw new InsnError("unexpected variable opcode");
    }

    public int nStackResults() {
        int n = VMOp.ops[this.opcode()].nStackResults();
        if (n >= 0) {
            return n;
        }
        switch (this.opcode()) {
            case 178: 
            case 180: {
                ConstFieldRef constFieldRef = (ConstFieldRef)this.constValue;
                String string = constFieldRef.nameAndType().signature().asString();
                if (string.equals("J") || string.equals("D")) {
                    return 2;
                }
                return 1;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef constBasicMemberRef = (ConstBasicMemberRef)this.constValue;
                return Descriptor.countMethodReturnWords(constBasicMemberRef.nameAndType().signature().asString());
            }
        }
        throw new InsnError("unexpected variable opcode");
    }

    public String argTypes() {
        switch (this.opcode()) {
            case 179: 
            case 181: {
                ConstFieldRef constFieldRef = (ConstFieldRef)this.constValue;
                String string = constFieldRef.nameAndType().signature().asString();
                if (this.opcode() == 179) {
                    return string;
                }
                return this.descriptorTypeOfObject(constFieldRef) + string;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef constBasicMemberRef = (ConstBasicMemberRef)this.constValue;
                String string = Descriptor.extractArgSig(constBasicMemberRef.nameAndType().signature().asString());
                if (this.opcode() == 184) {
                    return string;
                }
                return this.descriptorTypeOfObject(constBasicMemberRef) + string;
            }
        }
        return VMOp.ops[this.opcode()].argTypes();
    }

    public String resultTypes() {
        switch (this.opcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef constBasicMemberRef = (ConstBasicMemberRef)this.constValue;
                String string = Descriptor.extractResultSig(constBasicMemberRef.nameAndType().signature().asString());
                if (string.equals("V")) {
                    return "";
                }
                return string;
            }
            case 178: 
            case 180: {
                ConstFieldRef constFieldRef = (ConstFieldRef)this.constValue;
                return constFieldRef.nameAndType().signature().asString();
            }
            case 18: 
            case 19: 
            case 20: {
                ConstValue constValue = (ConstValue)this.constValue;
                return constValue.descriptor();
            }
        }
        return VMOp.ops[this.opcode()].resultTypes();
    }

    public boolean branches() {
        return false;
    }

    public ConstBasic value() {
        return this.constValue;
    }

    public void setValue(ConstBasic constBasic) {
        this.checkConstant(constBasic);
        this.constValue = constBasic;
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  " + InsnConstOp.opName(this.opcode()) + "  pool(" + this.constValue.getIndex() + ")");
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = this.opcode() == 18 && !this.isNarrowldc() ? 19 : (byte)this.opcode();
        int n2 = this.constValue.getIndex();
        if (this.size() == 3) {
            byArray[n++] = (byte)(n2 >> 8);
        }
        byArray[n++] = (byte)(n2 & 0xFF);
        return n;
    }

    int size() {
        return this.isNarrowldc() ? 2 : 3;
    }

    private boolean isNarrowldc() {
        return this.opcode() == 18 && this.constValue.getIndex() < 256;
    }

    InsnConstOp(int n, ConstBasic constBasic) {
        this(n, constBasic, -1);
    }

    InsnConstOp(int n, ConstBasic constBasic, int n2) {
        super(n, n2);
        this.constValue = constBasic;
        this.checkConstant(constBasic);
        if (n == 185) {
            throw new InsnError("attempt to create an " + InsnConstOp.opName(n) + " as an InsnConstOp instead of InsnInterfaceInvoke");
        }
    }

    InsnConstOp(int n, ConstInterfaceMethodRef constInterfaceMethodRef, int n2) {
        super(n, n2);
        this.constValue = constInterfaceMethodRef;
        this.checkConstant(constInterfaceMethodRef);
    }

    private void checkConstant(ConstBasic constBasic) {
        switch (this.opcode()) {
            case 18: 
            case 19: 
            case 20: {
                if (constBasic != null && constBasic instanceof ConstValue) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstValue operand");
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                if (constBasic != null && constBasic instanceof ConstFieldRef) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstFieldRef operand");
            }
            case 182: 
            case 183: 
            case 184: {
                if (constBasic != null && constBasic instanceof ConstMethodRef) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstMethodRef operand");
            }
            case 185: {
                if (constBasic != null && constBasic instanceof ConstInterfaceMethodRef) break;
                throw new InsnError("Attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstInterfaceMethodRef operand");
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                if (constBasic != null && constBasic instanceof ConstClass) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstClass operand");
            }
            default: {
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " with a constant operand");
            }
        }
    }

    private final String descriptorTypeOfObject(ConstBasicMemberRef constBasicMemberRef) {
        String string = constBasicMemberRef.className().className().asString();
        return "L" + string + ";";
    }
}

