/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class GenericAttribute
extends ClassAttribute {
    byte[] attributeBytes;

    public GenericAttribute(ConstUtf8 constUtf8, byte[] byArray) {
        super(constUtf8);
        this.attributeBytes = byArray;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        dataOutputStream.writeInt(this.attributeBytes.length);
        dataOutputStream.write(this.attributeBytes, 0, this.attributeBytes.length);
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println("Generic Attribute(" + this.attrName().asString() + "): " + Integer.toString(this.attributeBytes.length) + " in length");
        for (int i = 0; i < this.attributeBytes.length; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    printStream.println();
                }
                printStream.print(i + " :");
            }
            printStream.print(" " + Integer.toString(this.attributeBytes[i] & 0xFF, 16));
        }
        printStream.println();
    }
}

