/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class ExceptionsAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "Exceptions";
    private Vector exceptionTable;

    public Enumeration exceptions() {
        return this.exceptionTable.elements();
    }

    public ExceptionsAttribute(ConstUtf8 constUtf8, Vector vector) {
        super(constUtf8);
        this.exceptionTable = vector;
    }

    public ExceptionsAttribute(ConstUtf8 constUtf8, ConstClass constClass) {
        super(constUtf8);
        this.exceptionTable = new Vector(1);
        this.exceptionTable.addElement(constClass);
    }

    static ExceptionsAttribute read(ConstUtf8 constUtf8, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        Vector<ConstClass> vector = new Vector<ConstClass>();
        while (n-- > 0) {
            int n2 = dataInputStream.readUnsignedShort();
            ConstClass constClass = null;
            if (n2 != 0) {
                constClass = (ConstClass)constantPool.constantAt(n2);
            }
            vector.addElement(constClass);
        }
        return new ExceptionsAttribute(constUtf8, vector);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        dataOutputStream.writeInt(2 + 2 * this.exceptionTable.size());
        dataOutputStream.writeShort(this.exceptionTable.size());
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            dataOutputStream.writeShort(((ConstClass)this.exceptionTable.elementAt(i)).getIndex());
        }
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.print("Exceptions:");
        for (int i = 0; i < this.exceptionTable.size(); ++i) {
            printStream.print(" " + ((ConstClass)this.exceptionTable.elementAt(i)).asString());
        }
        printStream.println();
    }
}

