/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.ExceptionTable;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class CodeAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "Code";
    private byte[] theDataBytes;
    private int maxStack;
    private int maxLocals;
    private byte[] theCodeBytes;
    private Insn theCode;
    private ExceptionTable exceptionTable;
    private AttributeVector codeAttributes;
    CodeEnv codeEnv;

    public int stackUsed() {
        this.makeValid();
        return this.maxStack;
    }

    public void setStackUsed(int n) {
        this.makeValid();
        this.maxStack = n;
    }

    public int localsUsed() {
        this.makeValid();
        return this.maxLocals;
    }

    public void setLocalsUsed(int n) {
        this.makeValid();
        this.maxLocals = n;
    }

    public byte[] byteCodes() {
        this.makeValid();
        return this.theCodeBytes;
    }

    public Insn theCode() {
        this.makeValid();
        if (this.theCode == null && this.codeEnv != null) {
            this.buildInstructions(this.codeEnv);
        }
        return this.theCode;
    }

    public void setTheCode(Insn insn) {
        this.makeValid();
        if (insn != null && insn.opcode() != -1) {
            throw new InsnError("The initial instruction in all methods must be a target");
        }
        this.theCode = insn;
    }

    public ExceptionTable exceptionHandlers() {
        this.makeValid();
        return this.exceptionTable;
    }

    public AttributeVector attributes() {
        this.makeValid();
        return this.codeAttributes;
    }

    public CodeAttribute(ConstUtf8 constUtf8, int n, int n2, Insn insn, ExceptionTable exceptionTable, AttributeVector attributeVector) {
        this(constUtf8, n, n2, insn, null, exceptionTable, attributeVector, null);
    }

    public CodeAttribute(ConstUtf8 constUtf8, int n, int n2, Insn insn, byte[] byArray, ExceptionTable exceptionTable, AttributeVector attributeVector, CodeEnv codeEnv) {
        super(constUtf8);
        this.maxStack = n;
        this.maxLocals = n2;
        this.theCode = insn;
        this.theCodeBytes = byArray;
        this.exceptionTable = exceptionTable;
        this.codeAttributes = attributeVector;
        this.codeEnv = codeEnv;
    }

    public CodeAttribute(ConstUtf8 constUtf8, byte[] byArray, CodeEnv codeEnv) {
        super(constUtf8);
        this.theDataBytes = byArray;
        this.codeEnv = codeEnv;
    }

    static CodeAttribute read(ConstUtf8 constUtf8, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readInt();
        byte[] byArray = new byte[n3];
        dataInputStream.readFully(byArray);
        Insn insn = null;
        CodeEnv codeEnv = new CodeEnv(constantPool);
        ExceptionTable exceptionTable = ExceptionTable.read(dataInputStream, codeEnv);
        AttributeVector attributeVector = AttributeVector.readAttributes(dataInputStream, codeEnv);
        return new CodeAttribute(constUtf8, n, n2, insn, byArray, exceptionTable, attributeVector, codeEnv);
    }

    static CodeAttribute read(ConstUtf8 constUtf8, int n, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return new CodeAttribute(constUtf8, byArray, new CodeEnv(constantPool));
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        if (this.theDataBytes == null) {
            this.buildInstructionBytes();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream2.writeShort(this.maxStack);
            dataOutputStream2.writeShort(this.maxLocals);
            dataOutputStream2.writeInt(this.theCodeBytes.length);
            dataOutputStream2.write(this.theCodeBytes, 0, this.theCodeBytes.length);
            this.exceptionTable.write(dataOutputStream2);
            this.codeAttributes.write(dataOutputStream2);
            dataOutputStream2.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
        } else {
            dataOutputStream.writeInt(this.theDataBytes.length);
            dataOutputStream.write(this.theDataBytes, 0, this.theDataBytes.length);
        }
    }

    void print(PrintStream printStream, int n) {
        Insn insn;
        this.makeValid();
        ClassPrint.spaces(printStream, n);
        printStream.print("Code:");
        printStream.print(" max_stack = " + Integer.toString(this.maxStack));
        printStream.print(" max_locals = " + Integer.toString(this.maxLocals));
        printStream.println(" Exceptions:");
        this.exceptionTable.print(printStream, n + 2);
        ClassPrint.spaces(printStream, n);
        printStream.println("Code Attributes:");
        this.codeAttributes.print(printStream, n + 2);
        if (insn != null) {
            ClassPrint.spaces(printStream, n);
            printStream.println("Instructions:");
            for (insn = this.theCode(); insn != null; insn = insn.next()) {
                insn.print(printStream, n + 2);
            }
        }
    }

    private int resolveOffsets() {
        int n = 0;
        for (Insn insn = this.theCode; insn != null; insn = insn.next()) {
            n = insn.resolveOffset(n);
        }
        return n;
    }

    int codeSize() {
        this.makeValid();
        return this.theCodeBytes.length;
    }

    private void buildInstructions(CodeEnv codeEnv) {
        if (this.theCodeBytes != null) {
            Insn insn;
            InsnReadEnv insnReadEnv = new InsnReadEnv(this.theCodeBytes, codeEnv);
            Insn insn2 = this.theCode = insnReadEnv.getTarget(0);
            while (insnReadEnv.more()) {
                insn = Insn.read(insnReadEnv);
                insn2.setNext(insn);
                insn2 = insn;
            }
            Insn insn3 = null;
            for (insn2 = this.theCode; insn2 != null; insn2 = insn2.next()) {
                int n = insn2.offset();
                if (n > 0 && (insn = codeEnv.findTarget(n)) != null) {
                    insn3.setNext(insn);
                }
                insn3 = insn2;
            }
            insn = codeEnv.findTarget(insnReadEnv.currentPC());
            if (insn != null) {
                insn3.setNext(insn);
            }
        }
    }

    private void buildInstructionBytes() {
        if (this.theCode != null) {
            int n = this.resolveOffsets();
            this.theCodeBytes = new byte[n];
            int n2 = 0;
            for (Insn insn = this.theCode; insn != null; insn = insn.next()) {
                n2 = insn.store(this.theCodeBytes, n2);
            }
        }
    }

    private void makeValid() {
        if (this.theDataBytes != null) {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.theDataBytes));
            try {
                this.maxStack = dataInputStream.readUnsignedShort();
                this.maxLocals = dataInputStream.readUnsignedShort();
                int n = dataInputStream.readInt();
                this.theCodeBytes = new byte[n];
                dataInputStream.readFully(this.theCodeBytes);
                this.exceptionTable = ExceptionTable.read(dataInputStream, this.codeEnv);
                this.codeAttributes = AttributeVector.readAttributes(dataInputStream, this.codeEnv);
            }
            catch (IOException iOException) {
                throw new ClassFormatError("IOException while reading code attribute");
            }
            this.theDataBytes = null;
        }
    }
}

