/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassField;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassMethod;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class ClassFile
implements VMConstants,
Serializable {
    public static final int magic = -889275714;
    public static final int jdk11MinorVersion = 3;
    public static final int jdk11MajorVersion = 45;
    public static final int jdk12MinorVersion = 0;
    public static final int jdk12MajorVersion = 46;
    private int majorVersion = 45;
    private int minorVersion = 3;
    private ConstantPool constantPool = new ConstantPool();
    private int accessFlags = 0;
    private ConstClass thisClassName;
    private ConstClass superClassName;
    private Vector classInterfaces = new Vector();
    private Vector classFields = new Vector();
    private Vector classMethods = new Vector();
    private AttributeVector classAttributes = new AttributeVector();

    public ConstantPool pool() {
        return this.constantPool;
    }

    public int access() {
        return this.accessFlags;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public ConstClass className() {
        return this.thisClassName;
    }

    public ConstClass superName() {
        return this.superClassName;
    }

    public String superNameString() {
        return this.superClassName == null ? null : this.superClassName.asString();
    }

    public void setSuperName(ConstClass constClass) {
        this.superClassName = constClass;
    }

    public Vector interfaces() {
        return this.classInterfaces;
    }

    public void addInterface(ConstClass constClass) {
        this.classInterfaces.addElement(constClass);
    }

    public Vector fields() {
        return this.classFields;
    }

    public void addField(ClassField classField) {
        this.classFields.addElement(classField);
    }

    public void addField(ClassField classField, int n) {
        this.classFields.insertElementAt(classField, n);
    }

    public Vector methods() {
        return this.classMethods;
    }

    public ClassMethod findMethod(String string, String string2) {
        Enumeration enumeration = this.methods().elements();
        while (enumeration.hasMoreElements()) {
            ClassMethod classMethod = (ClassMethod)enumeration.nextElement();
            if (!classMethod.name().asString().equals(string) || !classMethod.signature().asString().equals(string2)) continue;
            return classMethod;
        }
        return null;
    }

    public void addMethod(ClassMethod classMethod) {
        this.classMethods.addElement(classMethod);
    }

    public ClassField findField(String string) {
        Enumeration enumeration = this.fields().elements();
        while (enumeration.hasMoreElements()) {
            ClassField classField = (ClassField)enumeration.nextElement();
            if (!classField.name().asString().equals(string)) continue;
            return classField;
        }
        return null;
    }

    public AttributeVector attributes() {
        return this.classAttributes;
    }

    public ClassFile(DataInputStream dataInputStream) throws ClassFormatError {
        this(dataInputStream, true);
    }

    public ClassFile(DataInputStream dataInputStream, boolean bl) throws ClassFormatError {
        try {
            int n = dataInputStream.readInt();
            if (n != -889275714) {
                throw new ClassFormatError("Bad magic value for input");
            }
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.readUnsignedShort();
            if (!(n2 == 3 && n3 == 45 || bl && n2 == 0 && n3 == 46)) {
                throw new ClassFormatError("Bad version number: " + n3 + "." + n2 + " expected: " + this.majorVersion + "." + this.minorVersion);
            }
            this.minorVersion = n2;
            this.majorVersion = n3;
            this.readConstants(dataInputStream);
            this.accessFlags = dataInputStream.readUnsignedShort();
            this.thisClassName = (ConstClass)this.constantPool.constantAt(dataInputStream.readUnsignedShort());
            this.superClassName = (ConstClass)this.constantPool.constantAt(dataInputStream.readUnsignedShort());
            this.readInterfaces(dataInputStream);
            this.readFields(dataInputStream);
            this.readMethods(dataInputStream);
            this.classAttributes = AttributeVector.readAttributes(dataInputStream, this.constantPool);
        }
        catch (IOException iOException) {
            throw new ClassFormatError("IOException during reading");
        }
    }

    public ClassFile(String string, String string2) {
        this.thisClassName = this.constantPool.addClass(string);
        this.superClassName = this.constantPool.addClass(string2);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minorVersion);
        dataOutputStream.writeShort(this.majorVersion);
        this.constantPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.thisClassName.getIndex());
        dataOutputStream.writeShort(this.superClassName == null ? 0 : this.superClassName.getIndex());
        this.writeInterfaces(dataOutputStream);
        this.writeFields(dataOutputStream);
        this.writeMethods(dataOutputStream);
        this.classAttributes.write(dataOutputStream);
    }

    public byte[] getBytes() throws IOException {
        Object object;
        String string = System.getProperty("filter.writeClassToDirectory");
        if (string != null) {
            object = string + File.separator + this.thisClassName.asString() + ".class";
            System.err.println("Writing class to file " + (String)object);
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream((String)object));
            this.write(dataOutputStream);
            dataOutputStream.close();
        }
        object = new ByteArrayOutputStream();
        this.write(new DataOutputStream((OutputStream)object));
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public void print(PrintStream printStream) {
        int n;
        this.constantPool.print(printStream);
        printStream.println();
        printStream.println("majorVersion = " + Integer.toString(this.majorVersion));
        printStream.println("minorVersion = " + Integer.toString(this.minorVersion));
        printStream.println("accessFlags = " + Integer.toString(this.accessFlags));
        printStream.println("className = " + this.thisClassName.asString());
        printStream.println("superClassName = " + this.superClassName.asString());
        printStream.print("Interfaces =");
        for (n = 0; n < this.classInterfaces.size(); ++n) {
            printStream.print(" " + ((ConstClass)this.classInterfaces.elementAt(n)).asString());
        }
        printStream.println();
        printStream.println("fields =");
        for (n = 0; n < this.classFields.size(); ++n) {
            ((ClassField)this.classFields.elementAt(n)).print(printStream, 3);
        }
        printStream.println("methods =");
        for (n = 0; n < this.classMethods.size(); ++n) {
            ((ClassMethod)this.classMethods.elementAt(n)).print(printStream, 3);
        }
        printStream.println("attributes =");
        this.classAttributes.print(printStream, 3);
    }

    public void summarize() {
        PrintStream printStream = System.out;
        this.constantPool.summarize();
        int n = 0;
        for (int i = 0; i < this.classMethods.size(); ++i) {
            n += ((ClassMethod)this.classMethods.elementAt(i)).codeSize();
        }
        System.out.println(this.classMethods.size() + " methods in " + n + " bytes");
    }

    private void readConstants(DataInputStream dataInputStream) throws IOException {
        this.constantPool = new ConstantPool(dataInputStream);
    }

    private void readInterfaces(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        while (n-- > 0) {
            int n2 = dataInputStream.readUnsignedShort();
            ConstClass constClass = null;
            if (n2 != 0) {
                constClass = (ConstClass)this.constantPool.constantAt(n2);
            }
            this.classInterfaces.addElement(constClass);
        }
    }

    private void writeInterfaces(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.classInterfaces.size());
        for (int i = 0; i < this.classInterfaces.size(); ++i) {
            ConstClass constClass = (ConstClass)this.classInterfaces.elementAt(i);
            int n = 0;
            if (constClass != null) {
                n = constClass.getIndex();
            }
            dataOutputStream.writeShort(n);
        }
    }

    private void readFields(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        while (n-- > 0) {
            this.classFields.addElement(ClassField.read(dataInputStream, this.constantPool));
        }
    }

    private void writeFields(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.classFields.size());
        for (int i = 0; i < this.classFields.size(); ++i) {
            ((ClassField)this.classFields.elementAt(i)).write(dataOutputStream);
        }
    }

    private void readMethods(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        while (n-- > 0) {
            this.classMethods.addElement(ClassMethod.read(dataInputStream, this.constantPool));
        }
    }

    private void writeMethods(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.classMethods.size());
        for (int i = 0; i < this.classMethods.size(); ++i) {
            ((ClassMethod)this.classMethods.elementAt(i)).write(dataOutputStream);
        }
    }
}

