/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancerHelper;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.FilterEnhancer;
import com.sun.jdo.api.persistence.enhancer.OutputStreamWrapper;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataModelImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataPropertyImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataTimer;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.model.Model;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Main {
    private ByteCodeEnhancer enhancer = null;
    private final PrintWriter outMessages = new PrintWriter(System.out, true);
    private final PrintWriter outErrors = new PrintWriter(System.err, true);
    private final CmdLineOptions cmdLineOpts = new CmdLineOptions();

    public static void main(String[] stringArray) {
        Main main = new Main();
        try {
            main.process(stringArray);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Exception occurred while postprocessing:");
            runtimeException.printStackTrace(System.err);
            throw runtimeException;
        }
        finally {
            if (main.cmdLineOpts.doTiming) {
                Support.timer.print();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        int n = this.processArgs(stringArray, arrayList);
        if (n != 0) {
            this.printMessage("aborted with errors.");
            return n;
        }
        try {
            if (this.cmdLineOpts.doTiming) {
                Support.timer.push("Main.process(String[])");
            }
            this.enhanceInputFiles(arrayList);
            this.printMessage("done.");
            int n2 = 0;
            return n2;
        }
        finally {
            if (this.cmdLineOpts.doTiming) {
                Support.timer.pop();
            }
        }
    }

    protected int processArgs(String[] stringArray, Collection collection) {
        Support support;
        stringArray = this.preprocess(stringArray);
        Properties properties = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-v") || string.equals("-verbose")) {
                this.cmdLineOpts.verbose = true;
                this.cmdLineOpts.quiet = false;
                continue;
            }
            if (string.equals("-q") || string.equals("-quiet")) {
                this.cmdLineOpts.quiet = true;
                this.cmdLineOpts.verbose = false;
                continue;
            }
            if (string.equals("-f") || string.equals("-force")) {
                this.cmdLineOpts.forceWrite = true;
                continue;
            }
            if (string.equals("-nowrite")) {
                this.cmdLineOpts.noWrite = true;
                continue;
            }
            if (string.equals("-d") || string.equals("-dest")) {
                if (stringArray.length - i < 2) {
                    this.printError("Missing argument to the -dest option", null);
                    Main.usage();
                }
                this.cmdLineOpts.destinationDirectory = stringArray[++i];
                continue;
            }
            if (string.equals("-t") || string.equals("--doTiming")) {
                this.cmdLineOpts.doTiming = true;
                continue;
            }
            if (string.equals("-jp") || string.equals("--jdoProperties")) {
                if (stringArray.length - i < 2) {
                    this.printError("Missing argument to the -jp/--jdoProperties option", null);
                    Main.usage();
                }
                try {
                    properties = new Properties();
                    properties.load(new FileInputStream(stringArray[++i]));
                }
                catch (IOException iOException) {
                    this.printError("Cannot read JDO meta data properties from file", iOException);
                    Main.usage();
                }
                continue;
            }
            if (string.length() > 0 && string.charAt(0) == '-') {
                this.printError("Unrecognized option:" + string, null);
                Main.usage();
            }
            if (string.length() == 0) {
                this.printMessage("Empty file name encountered on the command line.");
            }
            collection.add(string);
        }
        this.cmdLineOpts.quiet = false;
        if (this.cmdLineOpts.destinationDirectory == null) {
            if (stringArray.length > 0) {
                this.printError("No -dest output directory was specified", null);
            }
            Main.usage();
        }
        if (properties != null) {
            this.printMessage("using JDO meta-data from properties");
            support = new JDOMetaDataPropertyImpl(properties, this.outMessages);
        } else {
            this.printMessage("using JDO meta-data from Model.Enhancer");
            support = new JDOMetaDataModelImpl(Model.ENHANCER, this.outMessages);
        }
        if (this.cmdLineOpts.doTiming) {
            support = new JDOMetaDataTimer((JDOMetaData)((Object)support));
        }
        try {
            this.enhancer = this.createEnhancer((JDOMetaData)((Object)support));
        }
        catch (Exception exception) {
            this.printError("Error creating the enhancer", exception);
        }
        return 0;
    }

    private String[] preprocess(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '@') {
                String string = null;
                if (stringArray[i].length() == 1) {
                    if (i + 1 < stringArray.length) {
                        string = stringArray[++i];
                    }
                } else {
                    string = stringArray[i].substring(1);
                }
                if (string == null) {
                    this.printError("missing file name argument to @.", null);
                    continue;
                }
                this.appendFileContents(string, arrayList);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    private void appendFileContents(String string, ArrayList arrayList) {
        try {
            FileReader fileReader = new FileReader(string);
            try {
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string2 = null;
                block4: while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t", false);
                    while (stringTokenizer.hasMoreElements()) {
                        String string3 = stringTokenizer.nextToken();
                        if (string3.length() > 0 && string3.charAt(0) == '@') {
                            this.printError("The included file \"" + string + "\" contains a recursive include.  " + "Recursive includes are not supported.", null);
                        }
                        if (string3.charAt(0) == '#') continue block4;
                        arrayList.add(string3);
                    }
                }
            }
            catch (IOException iOException) {
                this.printError("IO exception reading file " + string + ".", iOException);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.printError("file " + string + " not found.", fileNotFoundException);
        }
    }

    private final ByteCodeEnhancer createEnhancer(JDOMetaData jDOMetaData) throws EnhancerUserException, EnhancerFatalError {
        Properties properties = new Properties();
        if (this.cmdLineOpts.verbose) {
            properties.put("ByteCodeEnhancer.verboseLevel", "verbose");
        }
        return new FilterEnhancer(jDOMetaData, properties, this.outMessages, this.outErrors);
    }

    private final void enhanceInputFiles(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                int n = string.length();
                Object var5_6 = null;
                if (Main.isClassFileName(string)) {
                    this.enhanceClassFile(Main.openFileInputStream(string));
                    continue;
                }
                if (Main.isZipFileName(string)) {
                    this.enhanceZipFile(string);
                    continue;
                }
                this.enhanceClassFile(this.openClassInputStream(string));
            }
            catch (Throwable throwable) {
                this.printError(null, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enhanceClassFile(InputStream inputStream) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            File file = File.createTempFile("enhancer", ".class");
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            OutputStreamWrapper outputStreamWrapper = new OutputStreamWrapper(bufferedOutputStream);
            boolean bl = this.enhancer.enhanceClassFile(inputStream, outputStreamWrapper);
            this.closeOutputStream(bufferedOutputStream);
            this.createOutputFile(bl, Main.createClassFileName(outputStreamWrapper.getClassName()), file);
            this.closeInputStream(inputStream);
            this.closeOutputStream(bufferedOutputStream);
        }
        catch (Throwable throwable) {
            try {
                this.printError(null, throwable);
                this.closeInputStream(inputStream);
                this.closeOutputStream(bufferedOutputStream);
            }
            catch (Throwable throwable2) {
                this.closeInputStream(inputStream);
                this.closeOutputStream(bufferedOutputStream);
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enhanceZipFile(String string) {
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            File file = File.createTempFile("enhancer", ".zip");
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(new File(string))));
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            boolean bl = ByteCodeEnhancerHelper.enhanceZipFile(this.enhancer, zipInputStream, zipOutputStream);
            this.closeOutputStream(zipOutputStream);
            zipOutputStream = null;
            this.createOutputFile(bl, new File(string).getName(), file);
            this.closeOutputStream(zipOutputStream);
            this.closeInputStream(zipInputStream);
        }
        catch (Throwable throwable) {
            try {
                this.printError(null, throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.closeOutputStream(zipOutputStream);
                this.closeInputStream(zipInputStream);
            }
        }
    }

    private static final InputStream openFileInputStream(String string) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(new File(string)));
    }

    private final InputStream openClassInputStream(String string) throws IOException, ClassNotFoundException {
        Main.class.getClassLoader();
        URL uRL = ClassLoader.getSystemResource(Main.createClassFileName(string));
        if (uRL == null) {
            throw new ClassNotFoundException(string);
        }
        return uRL.openStream();
    }

    private static final boolean isClassFileName(String string) {
        return string.endsWith(".class");
    }

    private static final boolean isZipFileName(String string) {
        int n = string.length();
        if (n < 5) {
            return false;
        }
        String string2 = string.substring(n - 4);
        return string2.equalsIgnoreCase(".zip") || string2.equalsIgnoreCase(".jar");
    }

    private static final String createClassFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    private final File createZipOutputFile(String string) {
        return new File(this.cmdLineOpts.destinationDirectory, new File(string).getName());
    }

    private final void createOutputFile(boolean bl, String string, File file) throws IOException {
        if (this.cmdLineOpts.noWrite || !bl && !this.cmdLineOpts.forceWrite) {
            file.deleteOnExit();
            return;
        }
        File file2 = new File(this.cmdLineOpts.destinationDirectory, string);
        Main.createPathOfFile(file2);
        file2.delete();
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
                int n = 4096;
                byte[] byArray = new byte[n];
                while (dataInputStream.available() > 0) {
                    int n2 = dataInputStream.read(byArray, 0, n);
                    dataOutputStream.write(byArray, 0, n2);
                }
                bl2 = true;
                file.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl2) {
                throw new IOException("Could not rename temp file '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'.");
            }
        }
    }

    private final void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                this.printError(null, iOException);
            }
        }
    }

    private final void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                this.printError(null, iOException);
            }
        }
    }

    private static final void createPathOfFile(File file) throws IOException {
        File file2 = file.getAbsoluteFile().getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Error creating directory '" + file2.getAbsolutePath() + "'.");
        }
    }

    private final void printError(String string, Throwable throwable) {
        if (string != null) {
            this.outErrors.println(string + (throwable != null ? ": " + throwable : ""));
        }
        if (throwable != null) {
            throwable.printStackTrace(this.outErrors);
        }
    }

    private final void printMessage(String string) {
        this.outMessages.println(string);
    }

    public static void usage() {
        System.err.println("Usage: main <options> <file name>");
        System.err.println("  { -verbose | -v }");
        System.err.println("  { -force | -f }");
        System.err.println("  { -quiet | -q }");
        System.err.println("  -nowrite");
        System.err.println(" -dest | -d <destination directory>");
        System.err.println("  --jdoProperties | -jp");
        System.err.println("  --timing | -t");
        System.err.println("  @<cmd-arg-file>");
        System.exit(1);
    }

    private final class CmdLineOptions {
        String destinationDirectory = null;
        boolean doTiming = false;
        boolean verbose = false;
        boolean quiet = false;
        boolean forceWrite = false;
        boolean noWrite = false;

        private CmdLineOptions() {
        }
    }
}

