/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer;

import com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer;
import com.sun.jdo.api.persistence.enhancer.EnhancerFatalError;
import com.sun.jdo.api.persistence.enhancer.EnhancerUserException;
import com.sun.jdo.api.persistence.enhancer.OutputStreamWrapper;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassFile;
import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.impl.EnhancerControl;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataModelImpl;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataPropertyImpl;
import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.enhancer.util.UserException;
import com.sun.jdo.api.persistence.model.Model;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class FilterEnhancer
extends Support
implements ByteCodeEnhancer {
    public static final String DO_SIMPLE_TIMING = "ByteCodeEnhancer.doSimpleTiming";
    public static final String VERBOSE_LEVEL = "ByteCodeEnhancer.verboseLevel";
    public static final String VERBOSE_LEVEL_QUIET = "quiet";
    public static final String VERBOSE_LEVEL_WARN = "warn";
    public static final String VERBOSE_LEVEL_VERBOSE = "verbose";
    public static final String VERBOSE_LEVEL_DEBUG = "debug";
    private Environment env = new Environment();
    private EnhancerControl econtrol = new EnhancerControl(this.env);

    protected void init(JDOMetaData jDOMetaData, Properties properties, PrintWriter printWriter, PrintWriter printWriter2) throws EnhancerUserException, EnhancerFatalError {
        String string;
        if (jDOMetaData == null) {
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        this.env.setJDOMetaData(jDOMetaData);
        if (printWriter2 != null) {
            this.env.setErrorWriter(printWriter2);
        }
        if (printWriter != null) {
            this.env.setOutputWriter(printWriter);
        }
        String string2 = string = properties == null ? null : properties.getProperty(VERBOSE_LEVEL);
        if (VERBOSE_LEVEL_QUIET.equals(string)) {
            this.env.setVerbose(false);
            this.env.setQuiet(true);
        } else if (VERBOSE_LEVEL_WARN.equals(string)) {
            this.env.setVerbose(false);
            this.env.setQuiet(false);
        } else if (VERBOSE_LEVEL_VERBOSE.equals(string)) {
            this.env.setVerbose(true);
            this.env.setQuiet(false);
        } else if (VERBOSE_LEVEL_DEBUG.equals(string)) {
            this.env.setVerbose(true);
            this.env.setQuiet(false);
        } else {
            this.env.setVerbose(false);
            this.env.setQuiet(false);
        }
        this.env.setNoOptimization(true);
        this.env.messageNL("FilterEnhancer: forced settings: -noopt");
    }

    public FilterEnhancer(JDOMetaData jDOMetaData, Properties properties, PrintWriter printWriter, PrintWriter printWriter2) throws EnhancerUserException, EnhancerFatalError {
        this.init(jDOMetaData, properties, printWriter, printWriter2);
    }

    public FilterEnhancer(Properties properties, Properties properties2, PrintWriter printWriter, PrintWriter printWriter2) throws EnhancerUserException, EnhancerFatalError {
        if (properties == null) {
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        JDOMetaDataPropertyImpl jDOMetaDataPropertyImpl = new JDOMetaDataPropertyImpl(properties, printWriter);
        this.init(jDOMetaDataPropertyImpl, properties2, printWriter, printWriter2);
    }

    public FilterEnhancer(Model model, Properties properties, PrintWriter printWriter, PrintWriter printWriter2) throws EnhancerUserException, EnhancerFatalError {
        if (model == null) {
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", "Illegal argument: metaData == null"));
        }
        JDOMetaDataModelImpl jDOMetaDataModelImpl = new JDOMetaDataModelImpl(model, this.env.getOutputWriter());
        this.init(jDOMetaDataModelImpl, properties, printWriter, printWriter2);
    }

    public boolean enhanceClassFile(InputStream inputStream, OutputStreamWrapper outputStreamWrapper) throws EnhancerUserException, EnhancerFatalError {
        boolean bl;
        this.env.messageNL("FilterEnhancer: enhancing classfile ...");
        this.env.reset();
        try {
            bl = this.enhanceClassFile1(inputStream, outputStreamWrapper);
        }
        catch (UserException userException) {
            this.env.reset();
            throw new EnhancerUserException(FilterEnhancer.getI18N("enhancer.error", userException.getMessage()), userException);
        }
        catch (RuntimeException runtimeException) {
            this.env.reset();
            runtimeException.printStackTrace();
            throw new EnhancerFatalError(FilterEnhancer.getI18N("enhancer.internal_error", runtimeException.getMessage()), runtimeException);
        }
        this.env.messageNL(bl ? "FilterEnhancer: classfile enhanced successfully." : "FilterEnhancer: classfile not changed.");
        return bl;
    }

    private boolean enhanceClassFile1(InputStream inputStream, OutputStreamWrapper outputStreamWrapper) {
        ClassControl classControl;
        ClassFile classFile;
        FilterEnhancer.affirm(inputStream, "Illegal argument: inByteCode == null.");
        FilterEnhancer.affirm(outputStreamWrapper, "Illegal argument: outByteCode == null.");
        try {
            ClassFileSource classFileSource = new ClassFileSource(null, inputStream);
            DataInputStream dataInputStream = classFileSource.classFileContents();
            classFile = new ClassFile(dataInputStream, true);
            classControl = new ClassControl(classFileSource, classFile, this.env);
            this.env.addClass(classControl);
            String string = classControl.className();
            classFileSource.setExpectedClassName(string);
        }
        catch (IOException iOException) {
            throw new UserException(FilterEnhancer.getI18N("enhancer.io_error_while_reading_stream"), iOException);
        }
        catch (ClassFormatError classFormatError) {
            throw new UserException(FilterEnhancer.getI18N("enhancer.class_format_error"), classFormatError);
        }
        this.econtrol.modifyClasses();
        if (this.env.errorCount() > 0) {
            this.env.getErrorWriter().flush();
            throw new UserException(this.env.getLastErrorMessage());
        }
        boolean bl = classControl.updated() && classControl.filterRequired();
        try {
            if (bl) {
                this.env.message("writing enhanced class " + classControl.userClassName() + " to output stream");
            } else {
                this.env.message("no changes on class " + classControl.userClassName());
            }
            outputStreamWrapper.setClassName(classControl.userClassName());
            DataOutputStream dataOutputStream = new DataOutputStream(outputStreamWrapper.getStream());
            classFile.write(dataOutputStream);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new UserException(FilterEnhancer.getI18N("enhancer.io_error_while_writing_stream"), iOException);
        }
        return bl;
    }

    public boolean enhanceClassFile(InputStream inputStream, OutputStream outputStream) throws EnhancerUserException, EnhancerFatalError {
        return this.enhanceClassFile(inputStream, new OutputStreamWrapper(outputStream));
    }
}

