/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import archiver.XMLInputStream;
import archiver.XMLOutputStream;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemoryCollection;
import com.sun.forte4j.modules.dbmodel.SchemaElementUtil;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.IDEUtil;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class SchemaElement
extends DBElement {
    public static final int STATUS_NOT = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_PARTIAL = 2;
    public static final int STATUS_OK = 3;
    public static final int CURRENT_VERSION_NO = 2;
    private int versionNo;
    protected static Map schemaCache = new HashMap();
    private static SchemaElement lastSchema;
    static /* synthetic */ Class class$com$sun$forte4j$modules$dbmodel$SchemaElement;

    public SchemaElement() {
        this(new Memory());
    }

    public SchemaElement(Impl impl) {
        super(impl);
    }

    final Impl getSchemaImpl() {
        return (Impl)this.getElementImpl();
    }

    public boolean isCompatibleVersion() {
        return this.getVersionNo() == 2;
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public void setVersionNo(int n) {
        this.versionNo = n;
    }

    protected static SchemaElement getLastSchema() {
        return lastSchema;
    }

    protected static void setLastSchema(SchemaElement schemaElement) {
        lastSchema = schemaElement;
    }

    public static void removeFromCache(String string) {
        Map map = schemaCache;
        synchronized (map) {
            if (SchemaElement.getLastSchema() != null && SchemaElement.getLastSchema().getName().getFullName().equals(string)) {
                SchemaElement.setLastSchema(null);
            }
            schemaCache.remove(string);
        }
    }

    public static SchemaElement forName(String string, ClassLoader classLoader) {
        SchemaElement schemaElement = SchemaElement.getLastSchema();
        if (schemaElement != null && schemaElement.getName().getFullName().equals(string)) {
            return schemaElement;
        }
        Map map = schemaCache;
        synchronized (map) {
            Object object;
            block12: {
                schemaElement = (SchemaElement)schemaCache.get(string);
                if (schemaElement != null) {
                    SchemaElement schemaElement2 = schemaElement;
                    return schemaElement2;
                }
                InputStream inputStream = classLoader.getResourceAsStream(NameUtil.getSchemaResourceName(string));
                if (inputStream != null) {
                    try {
                        TableElement[] tableElementArray;
                        object = new XMLInputStream(inputStream);
                        schemaElement = (SchemaElement)object.readObject();
                        if (!schemaElement.isCompatibleVersion()) {
                            tableElementArray = MessageFormat.format(DBElement.bundle.getString("PreviousVersion"), string);
                            System.out.println((String)tableElementArray);
                        }
                        object.close();
                        schemaElement.setName(DBIdentifier.create(string));
                        schemaCache.put(string, schemaElement);
                        SchemaElement.setLastSchema(schemaElement);
                        tableElementArray = schemaElement.getTables();
                        int n = tableElementArray != null ? tableElementArray.length : 0;
                        int n2 = 0;
                        while (n2 < n) {
                            tableElementArray[n2].setDeclaringSchema(schemaElement);
                            ++n2;
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            System.out.println(DBElement.bundle.getString("SchemaNotFound"));
                        }
                        break block12;
                    }
                }
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    System.out.println(DBElement.bundle.getString("SchemaNotFound"));
                }
            }
            object = schemaElement;
            return object;
        }
    }

    public static SchemaElement forName(String string) {
        if (IDEUtil.isIDERunning()) {
            return SchemaElementUtil.forName(string);
        }
        return SchemaElement.forName(string, (class$com$sun$forte4j$modules$dbmodel$SchemaElement == null ? (class$com$sun$forte4j$modules$dbmodel$SchemaElement = SchemaElement.class$("com.sun.forte4j.modules.dbmodel.SchemaElement")) : class$com$sun$forte4j$modules$dbmodel$SchemaElement).getClassLoader());
    }

    public int getStatus() {
        return this.getSchemaImpl().getStatus();
    }

    public void setSchema(DBIdentifier dBIdentifier) throws DBException {
        this.getSchemaImpl().setSchema(dBIdentifier);
    }

    public DBIdentifier getSchema() {
        return this.getSchemaImpl().getSchema();
    }

    public void setCatalog(DBIdentifier dBIdentifier) throws DBException {
        this.getSchemaImpl().setCatalog(dBIdentifier);
    }

    public DBIdentifier getCatalog() {
        return this.getSchemaImpl().getCatalog();
    }

    public void addTable(TableElement tableElement) throws DBException {
        this.addTables(new TableElement[]{tableElement});
    }

    public void addTables(TableElement[] tableElementArray) throws DBException {
        int n = 0;
        while (n < tableElementArray.length) {
            if (this.getTable(tableElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddTable", tableElementArray[n]);
            }
            if (tableElementArray[n].getDeclaringSchema() == null) {
                tableElementArray[n].setDeclaringSchema(this);
            }
            ++n;
        }
        this.getSchemaImpl().changeTables(tableElementArray, 1);
    }

    public void removeTable(TableElement tableElement) throws DBException {
        this.removeTables(new TableElement[]{tableElement});
    }

    public void removeTables(TableElement[] tableElementArray) throws DBException {
        this.getSchemaImpl().changeTables(tableElementArray, -1);
    }

    public void setTables(TableElement[] tableElementArray) throws DBException {
        if (tableElementArray == null) {
            throw new NullPointerException(DBElement.bundle.getString("NullTables"));
        }
        this.getSchemaImpl().changeTables(tableElementArray, 0);
    }

    public TableElement[] getTables() {
        return this.getSchemaImpl().getTables();
    }

    public TableElement getTable(DBIdentifier dBIdentifier) {
        return this.getSchemaImpl().getTable(dBIdentifier);
    }

    private void throwAddException(String string, TableElement tableElement) throws DBException {
        String string2 = tableElement.getName().getName();
        throw new DBException(string2);
    }

    public String getUrl() {
        return this.getSchemaImpl().getUrl();
    }

    public void setUrl(String string) throws DBException {
        this.getSchemaImpl().setUrl(string);
    }

    public String getUsername() {
        return this.getSchemaImpl().getUsername();
    }

    public void setUsername(String string) throws DBException {
        this.getSchemaImpl().setUsername(string);
    }

    public String getDriver() {
        return this.getSchemaImpl().getDriver();
    }

    public void setDriver(String string) {
        this.getSchemaImpl().setDriver(string);
    }

    public String getDatabaseProductName() {
        return this.getSchemaImpl().getDatabaseProductName();
    }

    public void setDatabaseProductName(String string) throws DBException {
        this.getSchemaImpl().setDatabaseProductName(string);
    }

    public String getDatabaseProductVersion() {
        return this.getSchemaImpl().getDatabaseProductVersion();
    }

    public void setDatabaseProductVersion(String string) throws DBException {
        this.getSchemaImpl().setDatabaseProductVersion(string);
    }

    public String getDriverName() {
        return this.getSchemaImpl().getDriverName();
    }

    public void setDriverName(String string) throws DBException {
        this.getSchemaImpl().setDriverName(string);
    }

    public String getDriverVersion() {
        return this.getSchemaImpl().getDriverVersion();
    }

    public void setDriverVersion(String string) throws DBException {
        this.getSchemaImpl().setDriverVersion(string);
    }

    public void save(String string) {
        this.setVersionNo(2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            XMLOutputStream xMLOutputStream = new XMLOutputStream(fileOutputStream);
            xMLOutputStream.writeObject(this);
            xMLOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(OutputStream outputStream) {
        this.setVersionNo(2);
        try {
            XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
            xMLOutputStream.writeObject(this);
            xMLOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Memory
    extends DBElement.Memory
    implements Impl {
        private DBMemoryCollection.Table tables;
        private DBIdentifier _catalog;
        private DBIdentifier _schema;
        private int _status;
        private String _url;
        private String _username;
        private String _driver;
        private String _databaseProductName;
        private String _databaseProductVersion;
        private String _driverName;
        private String _driverVersion;

        public Memory() {
        }

        public Memory(SchemaElement schemaElement) {
            super(schemaElement);
            this._catalog = schemaElement.getCatalog();
            this._schema = schemaElement.getSchema();
            this._status = schemaElement.getStatus();
            this._url = schemaElement.getUrl();
            this._username = schemaElement.getUsername();
            this._driver = schemaElement.getDriver();
            this._databaseProductName = schemaElement.getDatabaseProductName();
            this._databaseProductVersion = schemaElement.getDatabaseProductVersion();
            this._driverName = schemaElement.getDriverName();
            this._driverVersion = schemaElement.getDriverVersion();
        }

        public void copyFrom(SchemaElement schemaElement) throws DBException {
            this.changeTables(schemaElement.getTables(), 0);
        }

        public synchronized void changeTables(TableElement[] tableElementArray, int n) throws DBException {
            this.initTables();
            this.tables.change(tableElementArray, n);
        }

        public synchronized TableElement[] getTables() {
            this.initTables();
            return (TableElement[])this.tables.getElements();
        }

        public synchronized TableElement getTable(DBIdentifier dBIdentifier) {
            this.initTables();
            return (TableElement)this.tables.getElement(dBIdentifier);
        }

        void initTables() {
            if (this.tables == null) {
                this.tables = new DBMemoryCollection.Table(this);
            }
        }

        final SchemaElement getSchemaElement() {
            return (SchemaElement)this._element;
        }

        public int getStatus() {
            return this._status;
        }

        public void setSchema(DBIdentifier dBIdentifier) throws DBException {
            DBIdentifier dBIdentifier2 = this._schema;
            this._schema = dBIdentifier;
            this.firePropertyChange("schema", dBIdentifier2, dBIdentifier);
        }

        public DBIdentifier getSchema() {
            if (this._schema == null) {
                this._schema = DBIdentifier.create("");
            }
            return this._schema;
        }

        public void setCatalog(DBIdentifier dBIdentifier) throws DBException {
            DBIdentifier dBIdentifier2 = this._catalog;
            this._catalog = dBIdentifier;
            this.firePropertyChange("catalog", dBIdentifier2, dBIdentifier);
        }

        public DBIdentifier getCatalog() {
            if (this._catalog == null) {
                this._catalog = DBIdentifier.create("");
            }
            return this._catalog;
        }

        public String getUrl() {
            return this._url;
        }

        public void setUrl(String string) throws DBException {
            this._url = string;
        }

        public String getUsername() {
            return this._username;
        }

        public void setUsername(String string) throws DBException {
            this._username = string;
        }

        public String getDriver() {
            return this._driverName;
        }

        public void setDriver(String string) {
            this._driver = string;
        }

        public String getDatabaseProductName() {
            return this._databaseProductName;
        }

        public void setDatabaseProductName(String string) throws DBException {
            this._databaseProductName = string;
        }

        public String getDatabaseProductVersion() {
            return this._databaseProductVersion;
        }

        public void setDatabaseProductVersion(String string) throws DBException {
            this._databaseProductVersion = string;
        }

        public String getDriverName() {
            return this._driverName;
        }

        public void setDriverName(String string) throws DBException {
            this._driverName = string;
        }

        public String getDriverVersion() {
            return this._driverVersion;
        }

        public void setDriverVersion(String string) throws DBException {
            this._driverVersion = string;
        }
    }

    public static interface Impl
    extends DBElement.Impl {
        public int getStatus();

        public void setSchema(DBIdentifier var1) throws DBException;

        public DBIdentifier getSchema();

        public void setCatalog(DBIdentifier var1) throws DBException;

        public DBIdentifier getCatalog();

        public void changeTables(TableElement[] var1, int var2) throws DBException;

        public TableElement[] getTables();

        public TableElement getTable(DBIdentifier var1);

        public String getUrl();

        public void setUrl(String var1) throws DBException;

        public String getUsername();

        public void setUsername(String var1) throws DBException;

        public String getDriver();

        public void setDriver(String var1);

        public String getDatabaseProductName();

        public void setDatabaseProductName(String var1) throws DBException;

        public String getDatabaseProductVersion();

        public void setDatabaseProductVersion(String var1) throws DBException;

        public String getDriverName();

        public void setDriverName(String var1) throws DBException;

        public String getDriverVersion();

        public void setDriverVersion(String var1) throws DBException;
    }
}

