/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElementHolder;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemoryCollection;
import com.sun.forte4j.modules.dbmodel.KeyElement;
import com.sun.forte4j.modules.dbmodel.ReferenceKey;
import com.sun.forte4j.modules.dbmodel.TableElement;

public final class ForeignKeyElement
extends KeyElement
implements ReferenceKey,
ColumnPairElementHolder {
    public ForeignKeyElement() {
        this(new Memory(), null);
    }

    public ForeignKeyElement(Impl impl, TableElement tableElement) {
        super(impl, tableElement);
    }

    final Impl getForeignKeyImpl() {
        return (Impl)this.getElementImpl();
    }

    public TableElement getReferencedTable() {
        ColumnPairElement[] columnPairElementArray = this.getColumnPairs();
        if (columnPairElementArray != null && columnPairElementArray.length > 0) {
            return columnPairElementArray[0].getReferencedColumn().getDeclaringTable();
        }
        return null;
    }

    public ColumnElement[] getReferencedColumns() {
        ColumnPairElement[] columnPairElementArray = this.getColumnPairs();
        int n = columnPairElementArray != null ? columnPairElementArray.length : 0;
        ColumnElement[] columnElementArray = new ColumnElement[n];
        int n2 = 0;
        while (n2 < n) {
            columnElementArray[n2] = columnPairElementArray[n2].getReferencedColumn();
            ++n2;
        }
        return columnElementArray;
    }

    public String getKeyName() {
        return this.getName().getFullName();
    }

    public void setKeyName(String string) throws DBException {
        this.setName(DBIdentifier.create(string));
    }

    public void addColumnPair(ColumnPairElement columnPairElement) throws DBException {
        this.addColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void addColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getForeignKeyImpl().changeColumnPairs(columnPairElementArray, 1);
    }

    public void removeColumnPair(ColumnPairElement columnPairElement) throws DBException {
        this.removeColumnPairs(new ColumnPairElement[]{columnPairElement});
    }

    public void removeColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getForeignKeyImpl().changeColumnPairs(columnPairElementArray, -1);
    }

    public void setColumnPairs(ColumnPairElement[] columnPairElementArray) throws DBException {
        this.getForeignKeyImpl().changeColumnPairs(columnPairElementArray, 0);
    }

    public ColumnPairElement[] getColumnPairs() {
        return this.getForeignKeyImpl().getColumnPairs();
    }

    public ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
        return this.getForeignKeyImpl().getColumnPair(dBIdentifier);
    }

    public ColumnElement[] getLocalColumns() {
        return this.getForeignKeyImpl().getColumns();
    }

    public void addColumn(ColumnElement columnElement) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void addColumns(ColumnElement[] columnElementArray) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeColumn(ColumnElement columnElement) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeColumns(ColumnElement[] columnElementArray) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setColumns(ColumnElement[] columnElementArray) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ColumnElement[] getColumns() {
        return this.getForeignKeyImpl().getColumns();
    }

    public ColumnElement getColumn(DBIdentifier dBIdentifier) {
        return this.getForeignKeyImpl().getColumn(dBIdentifier);
    }

    static class Memory
    extends KeyElement.Memory
    implements Impl {
        private DBMemoryCollection.ColumnPair pairs;

        Memory() {
        }

        Memory(ForeignKeyElement foreignKeyElement) {
            super(foreignKeyElement);
        }

        public synchronized ColumnPairElement[] getColumnPairs() {
            this.initColumnPairs();
            return (ColumnPairElement[])this.pairs.getElements();
        }

        public synchronized ColumnPairElement getColumnPair(DBIdentifier dBIdentifier) {
            this.initColumnPairs();
            return (ColumnPairElement)this.pairs.getElement(dBIdentifier);
        }

        public synchronized void changeColumnPairs(ColumnPairElement[] columnPairElementArray, int n) throws DBException {
            this.initColumnPairs();
            this.pairs.change(columnPairElementArray, n);
        }

        void initColumnPairs() {
            if (this.pairs == null) {
                this.pairs = new DBMemoryCollection.ColumnPair(this);
            }
        }
    }

    public static interface Impl
    extends KeyElement.Impl {
        public void changeColumnPairs(ColumnPairElement[] var1, int var2) throws DBException;

        public ColumnPairElement[] getColumnPairs();

        public ColumnPairElement getColumnPair(DBIdentifier var1);
    }
}

