/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.web.resourceRefs;

import com.iplanet.ias.tools.common.dd.DefaultResourcePrincipal;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.common.ResRefMap;
import com.iplanet.ias.tools.forte.util.BundleHelper;
import com.iplanet.ias.tools.forte.util.ui.JNDINameMappingModel;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;

public class ResRefMapModel
extends JNDINameMappingModel {
    public static final int JNDI_COLUMN = 1;
    public static final int REF_COLUMN = 0;
    private SunWebApp ejbNode = null;
    private WebStandardData.WebDDData ejbJ2EE = null;
    private String[] j2eeRefNames = null;
    private ResRefMap[] maps = null;
    private int numRefs = 0;
    private String[] columnNames = new String[2];
    static /* synthetic */ Class class$java$lang$String;

    public ResRefMapModel(SunWebApp n, WebStandardData.WebDDData e) {
        Reporter.assertIt((Object)n);
        Reporter.assertIt(e);
        this.ejbJ2EE = e;
        this.ejbNode = n;
        this.columnNames[0] = BundleHelper.getString(this, "TTL_J2EEColumn");
        this.columnNames[1] = BundleHelper.getString(this, "TTL_JNDIColumn");
        this.load();
    }

    public String getColumnName(int c) {
        return this.columnNames[c];
    }

    public Class getColumnClass(int c) {
        return class$java$lang$String == null ? (class$java$lang$String = ResRefMapModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.numRefs;
    }

    public Object getValueAt(int r, int c) {
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: getValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return null;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: getValueAt() asked for column# " + c + " but only 2 exist.");
            return null;
        }
        if (c == 0) {
            return this.maps[r].getJ2EE();
        }
        return this.maps[r].getJNDI();
    }

    public void setValueAt(Object obj, int r, int c) {
        Reporter.info("Setting row# " + r + "'s JNDI Name to: " + obj);
        Reporter.assertIt(obj instanceof String);
        String s = (String)obj;
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: setValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: setValueAt() asked for column# " + c + " but only 2 exist.");
            return;
        }
        if (c == 0) {
            this.maps[r].setJ2EE(s);
        } else {
            this.maps[r].setJNDI(s);
        }
        Reporter.verbose("setValueAt(" + r + ", " + c + "): " + s);
    }

    public boolean isCellEditable(int r, int c) {
        return c == 1;
    }

    public Object saveData() {
        int num = this.howManyMaps();
        Reporter.info("Saving Resource Reference Maps --- numMaps: " + num + ",  numRefs: " + this.numRefs);
        if (num <= 0) {
            this.ejbNode.setResourceRef(null);
        }
        ResourceRef[] rrs = new ResourceRef[num];
        int currentMap = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            String jndi = this.maps[i].getJNDI();
            String j2ee = this.maps[i].getJ2EE();
            String name = this.maps[i].getUsername();
            String pword = this.maps[i].getPassword();
            if (jndi.length() <= 0) continue;
            ResourceRef rr = new ResourceRef();
            rr.setJndiName(jndi);
            rr.setResRefName(j2ee);
            if (null != name && null != pword) {
                DefaultResourcePrincipal drp = new DefaultResourcePrincipal();
                drp.setName(name);
                drp.setPassword(pword);
                rr.setDefaultResourcePrincipal(drp);
            }
            rrs[currentMap++] = rr;
        }
        Reporter.assertIt(currentMap == num);
        this.ejbNode.setResourceRef(rrs);
        return this.ejbNode;
    }

    int howManyMaps() {
        int count = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            if (this.maps[i].getJNDI().length() <= 0) continue;
            ++count;
        }
        return count;
    }

    private void load() {
        this.loadJ2EERefs();
        this.maps = new ResRefMap[this.numRefs];
        for (int i = 0; i < this.numRefs; ++i) {
            this.maps[i] = new ResRefMap(this.j2eeRefNames[i]);
        }
        this.loadExistingMaps();
    }

    private void loadJ2EERefs() {
        Reporter.assertIt(this.ejbJ2EE);
        this.numRefs = 0;
        WebStandardData.ResourceRefData[] rr = this.ejbJ2EE.getResourceRefs();
        if (rr == null || rr.length <= 0) {
            this.j2eeRefNames = new String[0];
            return;
        }
        this.numRefs = rr.length;
        this.j2eeRefNames = new String[this.numRefs];
        for (int i = 0; i < this.numRefs; ++i) {
            this.j2eeRefNames[i] = rr[i].getResRefName();
        }
    }

    private void loadExistingMaps() {
        ResourceRef[] iasRefs = this.ejbNode.getResourceRef();
        block0: for (int i = 0; i < iasRefs.length; ++i) {
            String jndi = iasRefs[i].getJndiName();
            String j2ee = iasRefs[i].getResRefName();
            DefaultResourcePrincipal drp = iasRefs[i].getDefaultResourcePrincipal();
            String name = null;
            String pword = null;
            if (null != drp) {
                name = drp.getName();
                pword = drp.getPassword();
            }
            for (int j = 0; j < this.numRefs; ++j) {
                if (!j2ee.equals(this.maps[j].getJ2EE())) continue;
                this.maps[j].setJNDI(jndi);
                this.maps[j].setPassword(pword);
                this.maps[j].setUsername(name);
                continue block0;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

