/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.web.ejbRefs;

import com.iplanet.ias.tools.common.dd.EjbRef;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.util.BundleHelper;
import com.iplanet.ias.tools.forte.util.ui.JNDINameMappingModel;
import com.iplanet.ias.tools.forte.web.ejbRefs.ejbRefMap;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;

public class ejbRefMapModel
extends JNDINameMappingModel {
    public static final int JNDI_COLUMN = 1;
    public static final int REF_COLUMN = 0;
    private WebStandardData.WebDDData stdWebXml = null;
    private SunWebApp iasWebXml = null;
    private String[] j2eeRefNames = null;
    private ejbRefMap[] maps = null;
    private int numRefs = 0;
    private String[] columnNames = new String[2];
    static /* synthetic */ Class class$java$lang$String;

    public ejbRefMapModel(SunWebApp n, WebStandardData.WebDDData e) {
        Reporter.assertIt((Object)n);
        Reporter.assertIt(e);
        this.stdWebXml = e;
        this.iasWebXml = n;
        this.columnNames[0] = BundleHelper.getString(this, "TTL_J2EEColumn");
        this.columnNames[1] = BundleHelper.getString(this, "TTL_JNDIColumn");
        this.load();
    }

    public String getColumnName(int c) {
        return this.columnNames[c];
    }

    public Class getColumnClass(int c) {
        return class$java$lang$String == null ? (class$java$lang$String = ejbRefMapModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.numRefs;
    }

    public Object getValueAt(int r, int c) {
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: getValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return null;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: getValueAt() asked for column# " + c + " but only 2 exist.");
            return null;
        }
        if (c == 0) {
            return this.maps[r].getJ2EE();
        }
        return this.maps[r].getJNDI();
    }

    public void setValueAt(Object obj, int r, int c) {
        Reporter.info("Setting row# " + r + "'s JNDI Name to: " + obj);
        Reporter.assertIt(obj instanceof String);
        String s = (String)obj;
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: setValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: setValueAt() asked for column# " + c + " but only 2 exist.");
            return;
        }
        if (c == 0) {
            this.maps[r].setJ2EE(s);
        } else {
            this.maps[r].setJNDI(s);
        }
        Reporter.verbose("setValueAt(" + r + ", " + c + "): " + s);
    }

    public boolean isCellEditable(int r, int c) {
        return c == 1;
    }

    public Object saveData() {
        int num = this.howManyMaps();
        Reporter.info("Saving Ejb Reference Maps --- numMaps: " + num + ",  numRefs: " + this.numRefs);
        if (num <= 0) {
            this.iasWebXml.setEjbRef(null);
        }
        EjbRef[] rrs = new EjbRef[num];
        int currentMap = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            String jndi = this.maps[i].getJNDI();
            String j2ee = this.maps[i].getJ2EE();
            if (jndi.length() <= 0) continue;
            EjbRef rr = new EjbRef();
            rr.setJndiName(jndi);
            rr.setEjbRefName(j2ee);
            rrs[currentMap++] = rr;
        }
        Reporter.assertIt(currentMap == num);
        this.iasWebXml.setEjbRef(rrs);
        return this.iasWebXml;
    }

    int howManyMaps() {
        int count = 0;
        for (int i = 0; i < this.numRefs; ++i) {
            if (this.maps[i].getJNDI().length() <= 0) continue;
            ++count;
        }
        return count;
    }

    private void load() {
        this.loadJ2EERefs();
        this.maps = new ejbRefMap[this.numRefs];
        for (int i = 0; i < this.numRefs; ++i) {
            this.maps[i] = new ejbRefMap(this.j2eeRefNames[i]);
        }
        this.loadExistingMaps();
    }

    private void loadJ2EERefs() {
        Reporter.assertIt(this.stdWebXml);
        this.numRefs = 0;
        WebStandardData.EjbRefData[] rr = this.stdWebXml.getEjbRefs();
        if (rr == null || rr.length <= 0) {
            this.j2eeRefNames = new String[0];
            return;
        }
        this.numRefs = rr.length;
        this.j2eeRefNames = new String[this.numRefs];
        for (int i = 0; i < this.numRefs; ++i) {
            this.j2eeRefNames[i] = rr[i].getEjbRefName();
        }
    }

    private void loadExistingMaps() {
        EjbRef[] iasRefs = this.iasWebXml.getEjbRef();
        block0: for (int i = 0; i < iasRefs.length; ++i) {
            String jndi = iasRefs[i].getJndiName();
            String j2ee = iasRefs[i].getEjbRefName();
            for (int j = 0; j < this.numRefs; ++j) {
                if (!j2ee.equals(this.maps[j].getJ2EE())) continue;
                this.maps[j].setJNDI(jndi);
                continue block0;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

