/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.web;

import com.iplanet.ias.tools.forte.web.WebDDTableModel;
import com.sun.forte4j.j2ee.lib.ui.DDTableModelEditor;
import com.sun.forte4j.j2ee.lib.ui.MessageArea;
import com.sun.forte4j.j2ee.lib.ui.MultiLineField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebDDTablePanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$web$WebDDTablePanel == null ? (class$com$iplanet$ias$tools$forte$web$WebDDTablePanel = WebDDTablePanel.class$("com.iplanet.ias.tools.forte.web.WebDDTablePanel")) : class$com$iplanet$ias$tools$forte$web$WebDDTablePanel));
    private WebDDTableModel model;
    private JScrollPane scrollPane;
    private JTable tab;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private int sortCol;
    private Dialog editDialog;
    boolean getPropertyValueCalled = false;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$web$WebDDTablePanel;

    public WebDDTablePanel(WebDDTableModel m, String[] toolTips) {
        this.initComponents(m, toolTips, true, true, true, 500, 70, 12);
    }

    public WebDDTablePanel(WebDDTableModel m, String[] toolTips, int insetVal) {
        this.initComponents(m, toolTips, true, true, true, 500, 70, insetVal);
    }

    public WebDDTablePanel(WebDDTableModel m, String[] toolTips, boolean allowAdd, boolean allowRemove) {
        this.initComponents(m, toolTips, allowAdd, allowRemove, true, 500, 70, 12);
    }

    public WebDDTablePanel(WebDDTableModel m) {
        this.initComponents(m, new String[0], false, false, false, 500, 70, 12);
    }

    public WebDDTablePanel(WebDDTableModel m, String[] toolTips, int width, int height) {
        this.initComponents(m, toolTips, true, true, true, width, height, 12);
    }

    private void initComponents(WebDDTableModel m, String[] toolTips, boolean allowAdd, boolean allowRemove, boolean allowEdit, int width, int height, int insetVal) {
        this.model = m;
        this.sortCol = -1;
        this.setBorder(new EmptyBorder(insetVal, insetVal, insetVal, insetVal));
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.tab = new JTable((TableModel)((Object)this.model));
        this.tab.setSelectionMode(0);
        this.tab.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.scrollPane.setViewportView(this.tab);
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.addButton = new JButton();
        this.addButton.setText(bundle.getString("CTL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebDDTablePanel.this.addButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.addButton);
        this.addButton.setVisible(allowAdd);
        this.editButton = new JButton();
        this.editButton.setText(bundle.getString("CTL_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebDDTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.editButton);
        this.removeButton = new JButton();
        this.removeButton.setText(bundle.getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebDDTablePanel.this.removeButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.removeButton.setVisible(allowRemove);
        this.add((Component)buttonPanel, "South");
        this.setHeaderToolTips(toolTips);
        if (allowRemove || allowEdit) {
            this.tab.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting() && WebDDTablePanel.this.tab.getRowCount() > 0) {
                        boolean rowSelected = WebDDTablePanel.this.tab.getSelectedRow() != -1;
                        WebDDTablePanel.this.removeButton.setEnabled(rowSelected);
                        WebDDTablePanel.this.editButton.setEnabled(rowSelected);
                    }
                }
            });
        }
        if (allowEdit) {
            this.tab.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    int row;
                    if (me.getClickCount() == 2 && (row = WebDDTablePanel.this.tab.rowAtPoint(me.getPoint())) != -1) {
                        WebDDTablePanel.this.tab.setRowSelectionInterval(row, row);
                        WebDDTablePanel.this.editButtonActionPerformed(null);
                    }
                }
            });
        }
        this.editButton.setEnabled(false);
        this.editButton.setVisible(allowEdit);
        this.initColumnSizes();
        this.addAncestorListener(new AListener());
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WebDDTablePanel"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_add"));
        this.addButton.setMnemonic(bundle.getString("CTL_Add_Mnemonic").charAt(0));
        this.editButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_edit"));
        this.editButton.setMnemonic(bundle.getString("CTL_Edit_Mnemonic").charAt(0));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_remove"));
        this.removeButton.setMnemonic(bundle.getString("CTL_Remove_Mnemonic").charAt(0));
        this.tab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DDTable"));
        this.tab.getAccessibleContext().setAccessibleName(this.model.getModelName());
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.tab.getSelectionModel().addListSelectionListener(l);
    }

    public void addVerticalScrollBarAdjustmentListener(AdjustmentListener l) {
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(l);
    }

    public void setVerticalScrollBarValue(int val) {
        int curVal = this.scrollPane.getVerticalScrollBar().getValue();
        if (curVal != val) {
            this.scrollPane.getVerticalScrollBar().setValue(val);
        }
    }

    public void linkLabel(JLabel label) {
        label.setLabelFor(this.tab);
    }

    public Color getHeaderColor() {
        if (this.tab.getColumnCount() < 1) {
            return Color.black;
        }
        TableColumn c = this.tab.getColumnModel().getColumn(0);
        TableCellRenderer cellR = c.getHeaderRenderer();
        Component comp = cellR.getTableCellRendererComponent(this.tab, c.getHeaderValue(), false, false, -1, 0);
        return comp.getForeground();
    }

    public int getSelectedRow() {
        return this.tab.getSelectedRow();
    }

    public void setSelectedRow(int row) {
        if (row == -1) {
            this.tab.clearSelection();
        } else {
            this.tab.addRowSelectionInterval(row, row);
        }
    }

    private void setHeaderToolTips(String[] toolTips) {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn c = this.tab.getColumnModel().getColumn(i);
            TableCellRenderer cellR = c.getHeaderRenderer();
            DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JTableHeader header;
                    if (table != null && (header = table.getTableHeader()) != null) {
                        this.setForeground(header.getForeground());
                        this.setBackground(header.getBackground());
                        int style = WebDDTablePanel.this.tab.convertColumnIndexToModel(column) == WebDDTablePanel.this.sortCol ? 1 : 0;
                        this.setFont(header.getFont().deriveFont(style));
                    }
                    this.setText(value == null ? "" : value.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return this;
                }
            };
            label.setHorizontalAlignment(0);
            c.setHeaderRenderer(label);
            cellR = label;
            Component comp = cellR.getTableCellRendererComponent(this.tab, c.getHeaderValue(), false, false, -1, i);
            if (comp == null || !(comp instanceof JComponent) || i >= toolTips.length) continue;
            JComponent jComp = (JComponent)comp;
            jComp.setToolTipText(toolTips[i]);
        }
    }

    private int maxSize(int col) {
        Component c = null;
        int max = 0;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            c = this.tab.getDefaultRenderer(this.model.getColumnClass(col)).getTableCellRendererComponent(this.tab, this.model.getValueAt(i, col), false, false, i, col);
            if (c.getPreferredSize().width <= max) continue;
            max = c.getPreferredSize().width;
        }
        return max;
    }

    private void initColumnSizes() {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn column = this.tab.getColumnModel().getColumn(i);
            Component comp = column.getHeaderRenderer().getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width;
            int cellWidth = this.maxSize(i);
            column.setPreferredWidth(Math.max(headerWidth, cellWidth));
        }
    }

    public void setCellEditor(int col, TableCellEditor cEdit) {
        this.tab.getColumnModel().getColumn(col).setCellEditor(cEdit);
    }

    public void setCellRenderer(int col, TableCellRenderer cRender) {
        this.tab.getColumnModel().getColumn(col).setCellRenderer(cRender);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.editRow(this.tab.getSelectedRow(), true);
    }

    private void closeEditDialog() {
        this.editDialog.setVisible(false);
        this.editDialog.dispose();
        this.editDialog = null;
    }

    public void editSelectedRow() {
        this.editRow(this.tab.getSelectedRow(), false);
    }

    private void editRow(final int row, final boolean isNew) {
        final DDTableModelEditor editor = this.model.getEditor();
        final Object obj = isNew ? this.model.makeNewElement() : this.model.getValueAt(row);
        editor.setValue(obj);
        JPanel p = new JPanel();
        JPanel editorPanel = editor.getPanel();
        HelpCtx hCtx = HelpCtx.findHelp((Component)editorPanel);
        if (hCtx != null) {
            HelpCtx.setHelpIDString((JComponent)p, (String)hCtx.getHelpID());
        }
        p.add("North", editorPanel);
        p.getAccessibleContext().setAccessibleDescription(editorPanel.getAccessibleContext().getAccessibleDescription());
        String editType = isNew ? bundle.getString("TTL_ADD") : bundle.getString("TTL_EDIT");
        String title = MessageFormat.format(bundle.getString("TTL_DIALOG"), editType, this.model.getModelName());
        DialogDescriptor dd = new DialogDescriptor((Object)p, title, true, 2, null, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() != NotifyDescriptor.OK_OPTION) {
                    if (isNew) {
                        WebDDTablePanel.this.model.newElementCancelled(obj);
                    }
                } else {
                    List errors = WebDDTablePanel.this.model.isValueValid(editor.getValue(), isNew ? -1 : row);
                    if (!errors.isEmpty()) {
                        NotifyDescriptor d = new NotifyDescriptor((Object)WebDDTablePanel.this.getErrorComponent("MSG_TableErrors", errors), MessageFormat.format(bundle.getString("TTL_DIALOG"), bundle.getString("TTL_ERROR"), WebDDTablePanel.this.model.getModelName()), 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                        TopManager.getDefault().notify(d);
                        return;
                    }
                    if (!isNew) {
                        if (!WebDDTablePanel.this.model.isEditValid(editor.getValue(), row)) {
                            return;
                        }
                        int[] rows = WebDDTablePanel.this.tab.getSelectedRows();
                        WebDDTablePanel.this.tab.clearSelection();
                        WebDDTablePanel.this.model.setValueAt(row, editor.getValue());
                        if (rows != null) {
                            for (int i = 0; i < rows.length; ++i) {
                                WebDDTablePanel.this.tab.setRowSelectionInterval(rows[i], rows[i]);
                            }
                        }
                    } else {
                        WebDDTablePanel.this.model.addRowAt(row, obj, editor.getValue());
                    }
                }
                WebDDTablePanel.this.closeEditDialog();
            }
        });
        dd.setClosingOptions(new Object[0]);
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Cancel"));
        cancel.setVerifyInputWhenFocusTarget(false);
        dd.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, cancel});
        this.editDialog = TopManager.getDefault().createDialog(dd);
        this.editDialog.show();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editRow(this.tab.getSelectedRow(), false);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.tab.getSelectedRow();
        List errors = this.model.canRemoveRow(row);
        if (!errors.isEmpty()) {
            Component c = this.getErrorComponent("MSG_RemoveWarning", errors);
            NotifyDescriptor.Confirmation confirmDesc = new NotifyDescriptor.Confirmation((Object)c, bundle.getString("CTL_Remove") + " " + this.model.getModelName() + " " + bundle.getString("TTL_WARNING"));
            Object[] options = new Object[]{bundle.getString("CTL_Remove"), NotifyDescriptor.CANCEL_OPTION};
            confirmDesc.setOptions(options);
            Object o = TopManager.getDefault().notify((NotifyDescriptor)confirmDesc);
            if (o == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
        }
        this.tab.removeRowSelectionInterval(row, row);
        DDTableModelEditor editor = this.model.getEditor();
        editor.setValue(this.model.getValueAt(row));
        this.model.removeRowAt(row);
    }

    private Component getErrorComponent(String summaryString, List errors) {
        if (errors.size() == 1) {
            return new MultiLineField((String)errors.get(0));
        }
        MessageArea msg = new MessageArea();
        Object[] o = new Object[]{this.model.getModelName()};
        msg.setText(MessageFormat.format(bundle.getString(summaryString), o));
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            msg.appendBulletItem((String)iter.next());
        }
        return msg;
    }

    public Object getPropertyValue() throws IllegalStateException {
        this.getPropertyValueCalled = true;
        return this.model.getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AListener
    implements AncestorListener {
        AListener() {
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
            if (!WebDDTablePanel.this.isShowing() && !WebDDTablePanel.this.getPropertyValueCalled) {
                WebDDTablePanel.this.model.editsCancelled();
            }
        }
    }
}

