/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.web;

import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetInfo;
import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetMap;
import java.beans.PropertyEditorSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class LocalePropertyEditor
extends PropertyEditorSupport {
    private String curr_Sel = null;
    private LocaleCharsetInfo ni;

    public LocalePropertyEditor(LocaleCharsetInfo ni, ResourceBundle bundle) {
        this.ni = ni;
    }

    public String getAsText() {
        return this.curr_Sel;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException();
        }
        this.curr_Sel = string;
        String[] tags = this.getTags();
        for (int i = 0; i < tags.length; ++i) {
            if (!this.curr_Sel.equals(tags[i])) continue;
            this.ni.setAttributeValue("DefaultLocale", this.curr_Sel);
        }
    }

    public void setValue(Object val) {
        if (val == null) {
            this.curr_Sel = "";
        } else {
            if (!(val instanceof String)) {
                throw new IllegalArgumentException();
            }
            this.curr_Sel = (String)val;
        }
    }

    public Object getValue() {
        return this.curr_Sel;
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String[] getTags() {
        return this.definedLocales(this.ni);
    }

    private String[] definedLocales(LocaleCharsetInfo ni) {
        String[] retVal;
        LocaleCharsetMap[] maps = ni.getLocaleCharsetMap();
        if (null == maps) {
            retVal = new String[]{};
        } else {
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (int i = 0; i < maps.length; ++i) {
                String val = maps[i].getAttributeValue("Locale");
                tmp.put(val, val);
            }
            Collection t = tmp.values();
            retVal = new String[t.size()];
            Iterator iter = t.iterator();
            int j = 0;
            while (iter.hasNext()) {
                retVal[j] = (String)iter.next();
                ++j;
            }
        }
        return retVal;
    }
}

