/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.web;

import com.iplanet.ias.tools.common.dd.webapp.CacheHelper;
import com.iplanet.ias.tools.common.dd.webapp.WebProperty;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.web.CacheCellEditor;
import com.iplanet.ias.tools.forte.web.CacheCellRenderer;
import com.iplanet.ias.tools.forte.web.CacheHelperEditor;
import com.iplanet.ias.tools.forte.web.WebAppDialog;
import com.iplanet.ias.tools.forte.web.WebDDTableModel;
import com.iplanet.ias.tools.forte.web.WebDDTablePanel;
import com.sun.forte4j.j2ee.lib.editors.RefArrayEditor;
import com.sun.forte4j.j2ee.lib.ui.DDTableModelEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CacheHelperArrayEditor
extends RefArrayEditor
implements TableModelListener {
    static final ResourceBundle helpBundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.HelpIDBundle");
    CacheHelper[] chArr = null;
    int paramType = 0;
    private ParamModel model = null;
    private CacheCellEditor cellEditor = null;
    static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$web$CacheHelperArrayEditor == null ? (class$com$iplanet$ias$tools$forte$web$CacheHelperArrayEditor = CacheHelperArrayEditor.class$("com.iplanet.ias.tools.forte.web.CacheHelperArrayEditor")) : class$com$iplanet$ias$tools$forte$web$CacheHelperArrayEditor));
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected WebDDTablePanel panel = null;
    protected static String[] requiredToolTips = new String[]{bundle.getString("tipCacheHelperName"), bundle.getString("tipCacheHelperClassName"), bundle.getString("tipCacheHelperProperty")};
    private WebAppDialogAdapter wadAdapter = null;
    private WebAppDialog td = null;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$web$CacheHelperArrayEditor;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public CacheHelperArrayEditor(CacheHelper[] chArr) {
        this.chArr = chArr;
    }

    public CacheHelperArrayEditor(CacheHelper[] chArr, int paramType) {
        this.chArr = chArr;
        this.paramType = paramType;
    }

    public Component getCustomEditor() {
        this.model = new ParamModel((Object[])this.chArr);
        this.model.addTableModelListener(this);
        this.panel = new WebDDTablePanel(this.model, requiredToolTips);
        HelpCtx.setHelpIDString((JComponent)this.panel, (String)helpBundle.getString("weapp_cache_helper_editor"));
        this.setupCacheCellEditor(this.panel, 2);
        this.setupCacheCellRenderer(this.panel, 2);
        return this.panel;
    }

    public void tableChanged(TableModelEvent e) {
        ParamModel model = (ParamModel)((Object)e.getSource());
        CacheHelper[] oldValue = this.chArr;
        Object[] sObj = model.getValue();
        this.chArr = new CacheHelper[sObj.length];
        for (int i = 0; i < sObj.length; ++i) {
            this.chArr[i] = (CacheHelper)((Object)sObj[i]);
        }
        this.changes.firePropertyChange("CacheHelperArray", oldValue, model.getValue());
        if (this.td != null && this.wadAdapter != null) {
            this.td.removePropertyChangeListener(this.wadAdapter);
        }
    }

    protected String getPaintableString() {
        Object[] entries = (Object[])this.getValue();
        if (entries == null || entries.length == 0) {
            return bundle.getString("TXT_Param");
        }
        if (entries.length == 1) {
            return bundle.getString("TXT_OneParam");
        }
        return MessageFormat.format(bundle.getString("TXT_MultiParam"), Integer.toString(entries.length));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    private void setupCacheCellEditor(WebDDTablePanel panel, int col) {
        final JButton button = new JButton();
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        this.cellEditor = new CacheCellEditor(button);
        panel.setCellEditor(col, this.cellEditor);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CacheHelperArrayEditor.this.td = new WebAppDialog(button, true, CacheHelperArrayEditor.this.chArr, 9);
                CacheHelperArrayEditor.this.wadAdapter = new WebAppDialogAdapter();
                CacheHelperArrayEditor.this.td.addPropertyChangeListener(CacheHelperArrayEditor.this.wadAdapter);
                button.setLabel(String.valueOf(((Object[])CacheHelperArrayEditor.this.cellEditor.getCellEditorValue()).length) + bundle.getString("TXT_Param"));
                CacheHelperArrayEditor.this.td.setRow(CacheHelperArrayEditor.this.cellEditor.getRow());
                CacheHelperArrayEditor.this.td.setValue(CacheHelperArrayEditor.this.cellEditor.getCellEditorValue());
                CacheHelperArrayEditor.this.td.show();
            }
        });
    }

    private void setupCacheCellRenderer(WebDDTablePanel panel, int col) {
        CacheCellRenderer ccR = new CacheCellRenderer(true);
        panel.setCellRenderer(col, ccR);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ParamModel
    extends WebDDTableModel {
        public ParamModel(Object[] rows) {
            super(rows);
        }

        public String getColumnName(int col) {
            if (0 == col) {
                return bundle.getString("colHdrCacheHelperName");
            }
            if (1 == col) {
                return bundle.getString("colHdrCacheHelperClassName");
            }
            if (2 == col) {
                return bundle.getString("colHdrCacheHelperProperties");
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            CacheHelper ch = (CacheHelper)((Object)this.data.get(row));
            Object obj = null;
            if (ch != null) {
                switch (col) {
                    case 0: {
                        obj = ch.getAttributeValue("Name");
                        break;
                    }
                    case 1: {
                        obj = ch.getAttributeValue("ClassName");
                        break;
                    }
                    case 2: {
                        obj = ch.getWebProperty();
                    }
                }
            }
            return obj;
        }

        public List isValueValid(Object rowObj, int row) {
            Vector<String> errors = new Vector<String>();
            CacheHelper ch = (CacheHelper)((Object)rowObj);
            String name = ch.getAttributeValue("Name");
            String className = ch.getAttributeValue("ClassName");
            CacheHelper chRow = null;
            String chRowName = null;
            if (null == name || name.length() == 0) {
                errors.add(bundle.getString("ERR_InvalidEntry"));
            }
            if (null == className || className.length() == 0) {
                errors.add(bundle.getString("ERR_InvalidEntry"));
            }
            for (int i = 0; i < this.data.size(); ++i) {
                chRow = (CacheHelper)((Object)this.data.elementAt(i));
                chRowName = chRow.getAttributeValue("Name");
                if (i == row || !chRowName.equals(name)) continue;
                errors.add(bundle.getString("ERR_DuplicateEntry"));
            }
            return errors;
        }

        public boolean isEditValid(Object obj, int index) {
            return true;
        }

        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public String getModelName() {
            return bundle.getString("ParamModel_modelName");
        }

        public DDTableModelEditor getEditor() {
            return new CacheHelperEditor();
        }

        protected void setValueAt(Object valObj, Object rowObj, int row, int col) {
            CacheHelper ch = (CacheHelper)((Object)rowObj);
            if (ch != null) {
                switch (col) {
                    case 0: {
                        ch.setAttributeValue("Name", (String)valObj);
                        break;
                    }
                    case 1: {
                        ch.setAttributeValue("ClassName", (String)valObj);
                        break;
                    }
                    case 2: {
                        Object[] sObj = (Object[])valObj;
                        Reporter.info(new Integer(sObj.length));
                        WebProperty[] elCH = new WebProperty[sObj.length];
                        int size = 0;
                        for (int i = 0; i < sObj.length; ++i) {
                            elCH[i] = (WebProperty)((Object)sObj[i]);
                            size = ch.sizeWebProperty();
                            if (size <= i) continue;
                            ch.setAttributeValue("WebProperty", i, "Name", elCH[i].getAttributeValue("Name"));
                            ch.setAttributeValue("WebProperty", i, "Value", elCH[i].getAttributeValue("Value"));
                        }
                        ch.setWebProperty(elCH);
                        break;
                    }
                }
            }
        }

        public Object makeNewElement() {
            CacheHelper ch = new CacheHelper();
            ch.setAttributeValue("Name", "");
            ch.setAttributeValue("ClassName", "");
            ch.setWebProperty(new WebProperty[0]);
            return ch;
        }

        public Object[] getValue() {
            return this.data.toArray();
        }

        public int getColumnCount() {
            return 3;
        }
    }

    class WebAppDialogAdapter
    implements PropertyChangeListener {
        WebAppDialogAdapter() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object[] sObj = (Object[])e.getNewValue();
            CacheHelperArrayEditor.this.cellEditor.setCellEditorValue(sObj);
        }
    }
}

