/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.pool;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.tools.common.deploy.NameValuePair;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings;
import com.iplanet.ias.tools.forte.pool.CPBean;
import com.iplanet.ias.tools.forte.server.AdminInstanceBean;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.swing.JOptionPane;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class ConnPoolUtil {
    static final ResourceBundle bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.pool.Bundle");
    public static int PROPERTY_NAME_PREFIX_LENGTH = "property.".length();
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$pool$CPBean;

    public static CPBean getJDBCConnectionPool(ServerComponent regres) {
        try {
            CPBean bn = new CPBean();
            Reporter.info(regres.getDisplayName());
            Object value = null;
            value = regres.getAttribute("name");
            if (value == null) {
                Reporter.error("Pool ID returns null");
                bn.setId(regres.getDisplayName());
            } else {
                bn.setId((String)value);
            }
            value = regres.getAttribute("dsClassName");
            if (value == null) {
                bn.setJdbcFactoryClassName(null);
            } else {
                bn.setJdbcFactoryClassName(value.toString());
            }
            value = regres.getAttribute("steadyPoolSize");
            if (value == null) {
                bn.setMinConnectionsInPool(null);
            } else {
                bn.setMinConnectionsInPool(value.toString());
            }
            value = regres.getAttribute("maxPoolSize");
            if (value == null) {
                bn.setMaxConnectionsInPool(null);
            } else {
                bn.setMaxConnectionsInPool(value.toString());
            }
            value = regres.getAttribute("maxWaitTime");
            if (value == null) {
                bn.setMaxConnectionWaitTimeInMillis(null);
            } else {
                bn.setMaxConnectionWaitTimeInMillis(value.toString());
            }
            value = regres.getAttribute("resizeValue");
            if (value == null) {
                bn.setConnectionsIncrement(null);
            } else {
                bn.setConnectionsIncrement(value.toString());
            }
            value = regres.getAttribute("idleTimeout");
            if (value == null) {
                bn.setConnectionIdleTimeoutInSeconds(null);
            } else {
                bn.setConnectionIdleTimeoutInSeconds(value.toString());
            }
            value = regres.getAttribute("isValidationRequired");
            if (value == null) {
                bn.setIsConnectionValidationRequired(null);
            } else {
                bn.setIsConnectionValidationRequired(value.toString());
            }
            value = regres.getAttribute("validationMethod");
            if (value == null) {
                bn.setConnectionValidationType(null);
            } else {
                bn.setConnectionValidationType(value.toString());
            }
            value = (String)regres.getAttribute("validationTable");
            if (value == null) {
                bn.setValidationTableName(null);
            } else {
                bn.setValidationTableName(value.toString());
            }
            value = regres.getAttribute("failAll");
            if (value == null) {
                bn.setFailAllConnections(null);
            } else {
                bn.setFailAllConnections(value.toString());
            }
            try {
                value = regres.getAttribute("resType");
                if (value == null) {
                    bn.setResType(null);
                } else {
                    bn.setResType(value.toString());
                }
                value = regres.getAttribute("transactionIsolationLevel");
                if (value == null) {
                    bn.setXIsolationLevel(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$pool$CPBean == null ? (class$com$iplanet$ias$tools$forte$pool$CPBean = ConnPoolUtil.class$("com.iplanet.ias.tools.forte.pool.CPBean")) : class$com$iplanet$ias$tools$forte$pool$CPBean), (String)"LBL_driver_default"));
                } else {
                    bn.setXIsolationLevel(value.toString());
                }
                value = regres.getAttribute("isIsolationLevelGuaranteed");
                if (value == null) {
                    bn.setIsIsolationLevelGuaranteed(null);
                } else {
                    bn.setIsIsolationLevelGuaranteed(value.toString());
                }
            }
            catch (AttributeNotFoundException ex) {
                Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
            }
            AttributeList props = regres.getAttributes(new String[]{"property."});
            if (props.size() > 0) {
                Object[] pairs = new NameValuePair[props.size()];
                for (int i = 0; i < props.size(); ++i) {
                    Attribute prop = (Attribute)props.get(i);
                    NameValuePair pair = new NameValuePair();
                    pair.setParamName(prop.getName().substring(PROPERTY_NAME_PREFIX_LENGTH));
                    pair.setParamValue((String)prop.getValue());
                    pairs[i] = pair;
                }
                bn.setExtParams(pairs);
            }
            return bn;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
        }
        catch (AFException ex) {
            Reporter.error("Got AFException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_Access") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
        }
        catch (Throwable ex) {
            Reporter.critical(new StackTrace(ex));
        }
        return null;
    }

    public static boolean setAttribute(ServerComponent regres, String name, Object value) {
        Reporter.info("name = " + name + ", value = " + value);
        try {
            if (name.equals("id")) {
                regres.setAttribute("name", (String)value);
            } else if (name.equals("JdbcFactoryClassName")) {
                regres.setAttribute("dsClassName", (String)value);
            } else if (name.equals("MinConnectionsInPool")) {
                regres.setAttribute("steadyPoolSize", new Integer((String)value));
            } else if (name.equals("MaxConnectionsInPool")) {
                regres.setAttribute("maxPoolSize", new Integer((String)value));
            } else if (name.equals("MaxConnectionWaitTimeInMillis")) {
                regres.setAttribute("maxWaitTime", new Integer((String)value));
            } else if (name.equals("ConnectionsIncrement")) {
                regres.setAttribute("resizeValue", new Integer((String)value));
            } else if (name.equals("ConnectionIdleTimeoutInSeconds")) {
                regres.setAttribute("idleTimeout", new Integer((String)value));
            } else if (name.equals("IsConnectionValidationRequired")) {
                regres.setAttribute("isValidationRequired", new Boolean((String)value));
            } else if (name.equals("ConnectionValidationType")) {
                Reporter.info("");
                regres.setAttribute("validationMethod", (String)value);
                Reporter.info(value);
            } else if (name.equals("ValidationTableName")) {
                regres.setAttribute("validationTable", (String)value);
            } else if (name.equals("FailAllConnections")) {
                regres.setAttribute("failAll", new Boolean((String)value));
            } else if (name.equals("ResType")) {
                regres.setAttribute("resType", (String)value);
            } else if (name.equals("XIsolationLevel")) {
                String isolation = (String)value;
                if (isolation != null && (isolation.length() == 0 || isolation.equals(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$pool$CPBean == null ? (class$com$iplanet$ias$tools$forte$pool$CPBean = ConnPoolUtil.class$("com.iplanet.ias.tools.forte.pool.CPBean")) : class$com$iplanet$ias$tools$forte$pool$CPBean), (String)"LBL_driver_default")))) {
                    isolation = null;
                }
                regres.setAttribute("transactionIsolationLevel", isolation);
            } else if (name.equals("IsIsolationLevelGuaranteed")) {
                regres.setAttribute("isIsolationLevelGuaranteed", new Boolean((String)value));
            }
            return true;
        }
        catch (AttributeNotFoundException ex) {
            Reporter.error("Got AttributeNotFoundException: " + ex.getMessage());
            return false;
        }
        catch (InvalidAttributeValueException ex) {
            Reporter.error("Got InvalidAttributeValueException: " + ex.getMessage());
            return false;
        }
        catch (AccessViolationException ex) {
            Reporter.error("Got AccessViolationException: " + ex.getMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_Access"), bundle.getString("Error"), 0);
            return false;
        }
        catch (AFTargetNotFoundException ex) {
            Reporter.error("Got AFTargetNotFoundException: " + ex.getMessage());
            TopManager.getDefault().setStatusText(bundle.getString("Err_NoTarget") + ": " + ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, bundle.getString("Err_NoTarget"), bundle.getString("Error"), 0);
            return false;
        }
    }

    public static Vector getRegisteredConnectionPools(boolean withPostFix) {
        Vector<String> pools = new Vector<String>();
        List adinstances = IasGlobalOptionsSettings.getSingleton().getAdminInstances();
        if (adinstances.size() != 0) {
            for (int i = 0; i < adinstances.size(); ++i) {
                AdminInstanceBean bn = (AdminInstanceBean)IasGlobalOptionsSettings.getSingleton().getAdminInstance(i);
                try {
                    HostAndPort hp = new HostAndPort(bn.getHost(), bn.getPort());
                    ServerModelIterator it = ServerInstanceManagerFactory.getFactory().getServerInstanceManager(hp, bn.getUserName(), bn.getPassword()).getAllServerInstances();
                    while (it.hasNext()) {
                        AppServerInstance si = (AppServerInstance)it.next();
                        ServerModelIterator deployedConnPool = si.getJDBCConnectionPools();
                        while (deployedConnPool.hasNext()) {
                            String val = deployedConnPool.next().toString();
                            if (withPostFix) {
                                val = val + "(" + si.getName() + ":" + hp + ")";
                            }
                            pools.addElement(val);
                        }
                    }
                    continue;
                }
                catch (AFTargetNotFoundException te) {
                    Reporter.error("Got Exception: " + te.getMessage());
                    continue;
                }
                catch (AFException ex) {
                    Reporter.error("Got Exception: " + ex.getMessage());
                    continue;
                }
                catch (Exception exp) {
                    Reporter.error("Got Exception: " + exp.getMessage());
                }
            }
        }
        return pools;
    }

    public static boolean isRegisteredConnectionPool(String poolName, boolean withPostFix) {
        Vector pools = ConnPoolUtil.getRegisteredConnectionPools(withPostFix);
        for (int i = 0; i < pools.size(); ++i) {
            String regPoolName = (String)pools.elementAt(i);
            if (!regPoolName.equals(poolName)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

