/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.i18n;

import com.iplanet.ias.tools.forte.i18n.DirectoryModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

class MDirList
extends JList {
    String doubleClickCommand;
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final int APPROVE_OPTION = 0;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    MDirList(DirectoryModel dm) {
        super(dm);
        this.setCellRenderer(new FileRenderer());
        this.addMouseListener(new DoubleClickListener(this));
    }

    public void approveSelection() {
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MDirList.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = MDirList.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? MDirList.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, command);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setDoubleClickCommand(String command) {
        String oldCommand = this.doubleClickCommand;
        this.doubleClickCommand = command;
        this.firePropertyChange("doubleClickCommand", oldCommand, command);
    }

    public String getDoubleClickCommand() {
        return this.doubleClickCommand;
    }

    File[] getSelectedFiles() {
        DirectoryModel dm = (DirectoryModel)this.getModel();
        int[] sel = this.getSelectedIndices();
        if (sel == null) {
            return null;
        }
        File[] flist = new File[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            flist[i] = (File)dm.getElementAt(sel[i]);
        }
        return flist;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList list) {
            this.list = list;
        }

        public void mouseClicked(MouseEvent e) {
            int index;
            if (e.getClickCount() == 2 && (index = this.list.locationToIndex(e.getPoint())) >= 0) {
                File f = (File)((DirectoryModel)this.list.getModel()).getElementAt(index);
                if (f.isDirectory()) {
                    this.list.clearSelection();
                    ((DirectoryModel)this.list.getModel()).setCurrentDirectory(f);
                    this.list.repaint();
                } else {
                    MDirList.this.approveSelection();
                }
            }
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        ImageIcon fileIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/file.gif"));
        ImageIcon directoryIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/dir.gif"));
        ImageIcon templateIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/tmplfile.gif"));
        ImageIcon jspIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/jsp16.gif"));
        ImageIcon gxmIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/projfile.gif"));
        ImageIcon javaIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/agntfile.gif"));
        ImageIcon classIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/classfile.gif"));
        ImageIcon queryIcon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/i18n/resources/qryfile.gif"));

        FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = file.getName();
            this.setText(fileName);
            ImageIcon icon = file.isDirectory() ? this.directoryIcon : this.fileIcon;
            String fileStr = file.getName().toLowerCase();
            icon = file.isDirectory() ? this.directoryIcon : (fileStr.endsWith("html") ? this.templateIcon : (fileStr.endsWith("jsp") ? this.jspIcon : (fileStr.endsWith("java") ? this.javaIcon : (fileStr.endsWith("class") ? this.classIcon : (fileStr.endsWith("gxq") ? this.queryIcon : (fileStr.endsWith("gxm") || fileStr.endsWith("iab") ? this.gxmIcon : this.fileIcon))))));
            this.setIcon(icon);
            return this;
        }
    }
}

