/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.i18n;

import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetInfo;
import com.iplanet.ias.tools.common.dd.webapp.LocaleCharsetMap;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.forte.i18n.FileSelectionPanel;
import com.iplanet.ias.tools.forte.i18n.ImportLocalizedJSPInterface;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class ImportLocalizedJSP
extends JFrame
implements ActionListener,
ImportLocalizedJSPInterface {
    private FileSelectionPanel _fileSelPanel;
    private JComboBox _selLocale = null;
    private JLabel _lbLocale = null;
    private JButton _ok;
    private JButton _help;
    private JButton _cancel = null;
    private String file_extension = "jsp";
    private LocaleCharsetInfo nls = null;
    private static String path = null;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$actions$HelpAction;

    public ImportLocalizedJSP() {
    }

    public ImportLocalizedJSP(Node node) {
        this.setNode(node);
    }

    public void setNode(Node node) {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/com/iplanet/ias/tools/forte/resources/sun-cluster_16_pad.gif"));
        this.setIconImage(icon.getImage());
        this.setTitle(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("titleImport"));
        this.initialize(node);
    }

    public boolean isNLSDefined(Node node) {
        LocaleCharsetInfo nls = ImportLocalizedJSP.getCurrentNlsInfo(node);
        return nls != null;
    }

    private static LocaleCharsetInfo getCurrentNlsInfo(Node node) {
        String webAppDir = "WEB-INF";
        DataObject dob = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ImportLocalizedJSP.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
        if (dob == null) {
            return null;
        }
        String dobName = dob.getName();
        if (dobName == null) {
            return null;
        }
        if (!dobName.equals(webAppDir)) {
            return null;
        }
        Set set = dob.files();
        Object[] aObj = set.toArray();
        if (aObj.length != 1) {
            return null;
        }
        FileObject folder = (FileObject)aObj[0];
        FileSystem fs = null;
        try {
            fs = folder.getFileSystem();
        }
        catch (FileStateInvalidException ee) {
            System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgFileStateInvalid"));
            ee.printStackTrace();
        }
        path = fs.getSystemName();
        if (!path.endsWith(webAppDir)) {
            path = path + "/" + webAppDir;
        }
        FileObject[] aFile = folder.getChildren();
        FileObject fo = null;
        for (int i = 0; i < aFile.length; ++i) {
            String name = aFile[i].getNameExt();
            if (!name.equalsIgnoreCase("web.websun")) continue;
            fo = aFile[i];
            break;
        }
        if (fo == null) {
            return null;
        }
        SunWebApp wap = null;
        try {
            wap = SunWebApp.createGraph(fo.getInputStream());
        }
        catch (FileNotFoundException e) {
            System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgFileNotFound"));
            e.printStackTrace();
            return null;
        }
        LocaleCharsetInfo nls = wap.getLocaleCharsetInfo();
        if (nls == null) {
            return null;
        }
        return nls;
    }

    private void initialize(Node node) {
        HelpCtx.setHelpIDString((JComponent)this.getRootPane(), (String)ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("idImportLoc"));
        this.nls = ImportLocalizedJSP.getCurrentNlsInfo(node);
        this._lbLocale = new JLabel(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("labelLocale"));
        this._selLocale = new JComboBox();
        this._fileSelPanel = new FileSelectionPanel(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("panelSelLocale"));
        Dimension dm = new Dimension(100, 30);
        this._ok = new JButton(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("btnOK"));
        this._ok.addActionListener(this);
        this._ok.setPreferredSize(dm);
        this._cancel = new JButton(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("btnCancel"));
        this._cancel.addActionListener(this);
        this._cancel.setPreferredSize(dm);
        this._help = new JButton(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("btnHelp"));
        this._help.addActionListener(this);
        this._help.setPreferredSize(dm);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ImportLocalizedJSP.this.exitForm(evt);
            }
        });
        this.layoutComponents();
        for (int i = 0; i < this.nls.sizeLocaleCharsetMap(); ++i) {
            LocaleCharsetMap lcm = this.nls.getLocaleCharsetMap(i);
            this._selLocale.addItem(lcm.getAttributeValue("Locale"));
        }
    }

    private void layoutComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.fill = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)this._lbLocale, c);
        c.gridwidth = 0;
        c.weightx = 2.0;
        this.getContentPane().add((Component)this._selLocale, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this._fileSelPanel, c);
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.getContentPane().add((Component)this._ok, c);
        c.gridwidth = -1;
        this.getContentPane().add((Component)this._cancel, c);
        c.gridwidth = 0;
        this.getContentPane().add((Component)this._help, c);
        this.pack();
        int x = this.getWidth() * 2 - this.getWidth() / 2;
        this.setLocation(x, this.getHeight());
        this.setVisible(true);
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this._ok)) {
            boolean ret = this.saveImportLocFile();
            if (ret) {
                this.setVisible(false);
            }
        } else if (source.equals(this._cancel) || source.equals(this._ok)) {
            this.setVisible(false);
        } else if (source.equals(this._help)) {
            SystemAction sa = SystemAction.get((Class)(class$org$openide$actions$HelpAction == null ? (class$org$openide$actions$HelpAction = ImportLocalizedJSP.class$("org.openide.actions.HelpAction")) : class$org$openide$actions$HelpAction));
            sa.actionPerformed(null);
        }
    }

    private boolean saveImportLocFile() {
        String loc = (String)this._selLocale.getSelectedItem();
        File[] selFile = this._fileSelPanel.getSelectedFiles();
        File projFile = new File(path);
        String jspExt = ".jsp";
        boolean okCopy = false;
        boolean okSave = false;
        for (int i = 0; i < selFile.length; ++i) {
            String fileName = selFile[i].getName();
            String extension = fileName.substring(fileName.indexOf(46) + 1);
            String baseName = fileName.substring(0, fileName.indexOf(46));
            File out = null;
            Object[] options = new Object[]{ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgHelp"), ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("btnOK")};
            if (!extension.toUpperCase().equals("JSP")) {
                okCopy = false;
                NotifyUtil.showError(fileName + ": " + ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgJSPonly"), ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("titleImport"));
            } else {
                String localeName = this.getValidLocFileName(fileName);
                if (localeName == null) {
                    out = new File(projFile, baseName + "_" + loc + jspExt);
                    okCopy = true;
                    okSave = true;
                } else if (localeName.toUpperCase().equals(loc.toUpperCase())) {
                    out = new File(projFile, selFile[i].getName());
                    okCopy = true;
                    okSave = true;
                } else {
                    okCopy = false;
                    NotifyUtil.showError(fileName + ": " + ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgInvalidLocaleExt"), ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("titleImport"));
                }
            }
            if (!okCopy) continue;
            boolean checkCopy = true;
            try {
                checkCopy = this.copyFile(selFile[i], out, loc);
            }
            catch (IOException e) {
                System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgFileError"));
                e.printStackTrace();
            }
            if (checkCopy) continue;
            System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgUnsuccessfulCopy"));
        }
        return okSave;
    }

    private String getValidLocFileName(String fileName) {
        String baseName = fileName.substring(0, fileName.indexOf(46));
        if (baseName.lastIndexOf(95) == -1) {
            return null;
        }
        String localeName = baseName.substring(baseName.lastIndexOf(95) + 1, baseName.length());
        String beginStr = null;
        if (this.isValidLocale(localeName)) {
            return localeName;
        }
        if (baseName.lastIndexOf(95) == -1) {
            return null;
        }
        beginStr = baseName.substring(0, baseName.lastIndexOf(localeName) - 1);
        localeName = (beginStr = beginStr.substring(beginStr.lastIndexOf(95) + 1, beginStr.length())) + "_" + localeName;
        if (this.isValidLocale(localeName)) {
            return localeName;
        }
        if (baseName.lastIndexOf(95) == -1 || localeName.equals(baseName)) {
            return null;
        }
        beginStr = baseName.substring(0, baseName.lastIndexOf(localeName) - 1);
        localeName = (beginStr = beginStr.substring(beginStr.lastIndexOf(95) + 1, beginStr.length())) + "_" + localeName;
        if (this.isValidLocale(localeName)) {
            return localeName;
        }
        return null;
    }

    private boolean isValidLocale(String loc) {
        String[] locStr = new String[]{"ar", "ar_AE", "ar_BH", "ar_DZ", "ar_EG", "ar_IQ", "ar_JO", "ar_KW", "ar_LB", "ar_LY", "ar_MA", "ar_OM", "ar_QA", "ar_SA", "ar_SD", "ar_SY", "ar_TN", "ar_YE", "be", "be_BY", "bg", "bg_BG", "ca", "ca_ES", "ca_ES_EURO", "cs", "cs_CZ", "da", "da_DK", "de", "de_AT", "de_AT_EURO", "de_CH", "de_DE", "de_DE_EURO", "de_LU", "de_LU_EURO", "de_CH", "de_DE", "de_DE_EURO", "de_LU", "de_LU_EURO", "el", "el_GR", "en", "en_AU", "en_BE", "en_CA", "en_GB", "en_IE", "en_EI_EURO", "en_NZ", "en_US", "en_ZA", "es", "es_AR", "es_BO", "es_CL", "es_CO", "es_CR", "es_DO", "es_EC", "es_ES", "es_ES_EURO", "es_GT", "es_HN", "es_MX", "es_NI", "es_PA", "es_PE", "es_PR", "es_PY", "es_SV", "es_UY", "es_VE", "et", "et_EE", "fi", "fi_FI", "fi_FI_EURO", "fr", "fr_BE", "fr_BE_EURO", "fr_CA", "fr_CH", "fr_FR", "fr_FR_EURO", "fr_LU", "fr_LU_EURO", "hr", "hr_HR", "hu", "hu_HU", "is", "is_IS", "it", "it_CH", "it_IT", "it_IT_EURO", "iw", "iw_IL", "ja", "ja_JP", "ko", "ko_KR", "lt_LT", "lv", "lv_LV", "mk", "mk_MK", "nl", "nl_BE", "nl_BE_EURO", "nl_NL", "nl_NL_EURO", "lt", "no", "no_NO", "no_NO_NY", "pl", "pl_PL", "pt", "pt_BR", "pt_PT", "pt_PT_EURO", "ro", "ro_RO", "ru", "ru_RU", "sh", "sh_YU", "sk", "sk_SK", "sl", "sl_SI", "sq", "sq_AL", "sr", "sr_YU", "sv", "sv_SE", "th", "th_TH", "tr", "tr_TR", "uk", "uk_UA", "vi", "vi_VN", "zh", "zh_CN", "zh_HK", "zh_TW"};
        for (int index = 0; index < locStr.length; ++index) {
            if (!locStr[index].equals(loc)) continue;
            return true;
        }
        return false;
    }

    private boolean copyFile(File input, File output, String localeName) throws IOException {
        BufferedWriter bufWriter;
        BufferedReader bufReader;
        try {
            FileReader reader = new FileReader(input);
            FileWriter writer = new FileWriter(output);
            bufReader = new BufferedReader(reader);
            bufWriter = new BufferedWriter(writer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            int i;
            String charset = null;
            for (int index = 0; index < this.nls.sizeLocaleCharsetMap(); ++index) {
                LocaleCharsetMap lcm = this.nls.getLocaleCharsetMap(index);
                if (!localeName.equalsIgnoreCase(lcm.getAttributeValue("Locale"))) continue;
                charset = lcm.getAttributeValue("Charset");
                break;
            }
            String pageDirective = "<%@ page contentType=\"text/html; charset=" + charset + "\"%>";
            bufWriter.write(pageDirective, 0, pageDirective.length());
            bufWriter.newLine();
            do {
                if ((i = bufReader.read()) == -1) continue;
                bufWriter.write(i);
            } while (i != -1);
        }
        catch (IOException e) {
            System.out.println(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgCopyError"));
            e.printStackTrace();
            bufReader.close();
            bufWriter.close();
            return false;
        }
        bufReader.close();
        bufWriter.close();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

