/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.i18n;

import java.io.File;
import javax.swing.Icon;

public interface FileType {
    public static final GenericFile SharedGenericFile = new GenericFile();
    public static final Folder SharedFolder = new Folder();
    public static final Hidden SharedHidden = new Hidden();
    public static final Computer SharedComputer = new Computer();
    public static final FloppyDrive SharedFloppyDrive = new FloppyDrive();
    public static final HardDrive SharedHardDrive = new HardDrive();

    public String getPresentationName();

    public boolean testFile(File var1);

    public Icon getIcon();

    public boolean isContainer();

    public static class ExtensionBased
    implements FileType {
        private String[] extensions;
        private String presentationName;
        private Icon icon;

        public ExtensionBased(String presentationName, String extension, Icon icon) {
            this.presentationName = presentationName;
            this.extensions = new String[1];
            this.extensions[0] = extension;
            this.icon = icon;
        }

        public ExtensionBased(String presentationName, String[] extensions, Icon icon) {
            if (extensions.length < 1) {
                throw new IllegalArgumentException("Empty extensions array");
            }
            this.presentationName = presentationName;
            this.extensions = (String[])extensions.clone();
            this.icon = icon;
        }

        public boolean testFile(File file) {
            int count = this.extensions.length;
            String path = file.getPath();
            for (int i = 0; i < count; ++i) {
                String ext = this.extensions[i];
                if (!path.endsWith(ext) || path.charAt(path.length() - ext.length()) != '.') continue;
                return true;
            }
            return false;
        }

        public String getPresentationName() {
            return this.presentationName == null ? this.extensions[0] : this.presentationName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public boolean isContainer() {
            return false;
        }
    }

    public static class HardDrive
    implements FileType {
        protected HardDrive() {
        }

        public String getPresentationName() {
            return "Disk Drive";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            String path = file.getPath();
            if (path.length() == 3 && path.charAt(1) == ':' && path.charAt(2) == '\\') {
                char c = path.charAt(0);
                return c >= 'C' && c <= 'Z' || c >= 'c' && c <= 'z';
            }
            return false;
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class FloppyDrive
    implements FileType {
        protected FloppyDrive() {
        }

        public String getPresentationName() {
            return "3\u00bd Inch Floppy Disk";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            String path = file.getPath();
            if (path.length() == 3 && path.charAt(1) == ':' && path.charAt(2) == '\\') {
                char c = path.charAt(0);
                return c == 'A' || c == 'a' || c == 'B' || c == 'b';
            }
            return false;
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class Computer
    implements FileType {
        protected Computer() {
        }

        public String getPresentationName() {
            return "Computer";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            return false;
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class Hidden
    implements FileType {
        protected Hidden() {
        }

        public String getPresentationName() {
            return "Hidden";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            String n = file.getName();
            return n.length() > 0 && n.charAt(0) == '.';
        }

        public boolean isContainer() {
            return false;
        }
    }

    public static class Folder
    implements FileType {
        protected Folder() {
        }

        public String getPresentationName() {
            return "Folder";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            return file.isDirectory();
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class GenericFile
    implements FileType {
        protected GenericFile() {
        }

        public String getPresentationName() {
            return "File";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            return true;
        }

        public boolean isContainer() {
            return false;
        }
    }
}

