/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.i18n;

import com.iplanet.ias.tools.forte.i18n.FileType;
import com.iplanet.ias.tools.forte.i18n.TypedFile;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DirectoryModel
implements ListModel {
    protected transient Vector currentFiles = new Vector();
    protected transient boolean currentFilesFresh = false;
    protected Vector knownTypes = new Vector();
    protected FileType shownType = null;
    protected FileType hiddenRule;
    protected FileType[] overrideTypes = null;
    protected FileType[] cleanupTypes = new FileType[]{FileType.SharedFolder, FileType.SharedGenericFile};
    protected File curDir;
    protected boolean haveCheckedWindows = false;
    protected boolean isWindows;
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport changeSupport;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public DirectoryModel() {
        this(null);
    }

    public DirectoryModel(File path) {
        this.setCurrentDirectory(path);
        if (this.isWindowsFileSystem()) {
            this.overrideTypes = new FileType[2];
            this.overrideTypes[0] = FileType.SharedFloppyDrive;
            this.overrideTypes[1] = FileType.SharedHardDrive;
        }
    }

    protected File makeAbsolute(File f) {
        File dir = this.curDir;
        if (!f.isAbsolute()) {
            f = dir == null ? (f instanceof TypedFile ? new TypedFile(f.getAbsolutePath(), ((TypedFile)f).getType()) : new File(f.getAbsolutePath())) : (f instanceof TypedFile ? new TypedFile(dir.getPath(), f.getPath(), ((TypedFile)f).getType()) : new File(dir.getPath(), f.getPath()));
        }
        return f;
    }

    public File getCurrentDirectory() {
        return this.curDir;
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            dir = new File(System.getProperty("user.home"));
        }
        dir = this.makeAbsolute(dir);
        if (this.curDir == null || !this.curDir.equals(dir)) {
            this.invalidateCache();
            File oldDir = this.curDir;
            this.curDir = dir;
            this.firePropertyChange("currentDirectory", oldDir, dir);
            this.fireContentsChanged();
        }
    }

    protected void invalidateCache() {
        this.currentFilesFresh = false;
    }

    public TypedFile getTypedFile(String path, String name) {
        TypedFile f = new TypedFile(path, name);
        this.deduceAndSetTypeOfFile(f);
        return f;
    }

    public TypedFile getTypedFile(String path) {
        TypedFile f = new TypedFile(path);
        this.deduceAndSetTypeOfFile(f);
        return f;
    }

    public Vector getTypedFiles() {
        return this.getTypedFilesForDirectory(this.getCurrentDirectory());
    }

    public Vector getTypedFilesForDirectory(File dir) {
        Vector<TypedFile> resultSet;
        boolean useCache = dir.equals(this.getCurrentDirectory());
        if (useCache && this.currentFilesFresh) {
            return this.currentFiles;
        }
        if (useCache) {
            resultSet = this.currentFiles;
            resultSet.removeAllElements();
        } else {
            resultSet = new Vector<TypedFile>();
        }
        String[] names = dir.list();
        int nameCount = names == null ? 0 : names.length;
        for (int i = 0; i < nameCount; ++i) {
            TypedFile f = dir instanceof WindowsRootDir ? this.getTypedFile(names[i]) : this.getTypedFile(dir.getPath(), names[i]);
            FileType t = f.getType();
            if (this.shownType != null && !t.isContainer() && this.shownType != t || this.hiddenRule != null && this.hiddenRule.testFile(f)) continue;
            resultSet.addElement(f);
        }
        if (!(dir instanceof WindowsRootDir)) {
            this.sort(resultSet);
        }
        if (useCache) {
            this.currentFilesFresh = true;
        }
        return resultSet;
    }

    protected boolean applyTypeToFile(FileType t, TypedFile f) {
        if (t.testFile(f)) {
            f.setType(t);
            return true;
        }
        return false;
    }

    protected void deduceAndSetTypeOfFile(TypedFile f) {
        int j;
        boolean foundOne = false;
        if (this.overrideTypes != null) {
            int overrideCount = this.overrideTypes.length;
            for (j = 0; j < overrideCount && !foundOne; ++j) {
                if (!this.applyTypeToFile(this.overrideTypes[j], f)) continue;
                foundOne = true;
            }
        }
        if (!foundOne) {
            Enumeration e = this.knownTypes.elements();
            while (e.hasMoreElements() && !foundOne) {
                FileType t = (FileType)e.nextElement();
                if (!this.applyTypeToFile(t, f)) continue;
                foundOne = true;
            }
        }
        if (!foundOne && this.cleanupTypes != null) {
            int cleanupCount = this.cleanupTypes.length;
            for (j = 0; j < cleanupCount && !foundOne; ++j) {
                if (!this.applyTypeToFile(this.cleanupTypes[j], f)) continue;
                foundOne = true;
            }
        }
        f.getType();
    }

    public boolean canGoUp() {
        File dir = this.getCurrentDirectory();
        return dir.getParent() != null || !this.isWindowsFileSystem();
    }

    public void goUp() {
        File parent;
        File curDir = this.getCurrentDirectory();
        String parentPath = curDir.getParent();
        File file = parent = parentPath == null ? null : new File(parentPath);
        if (parent != null) {
            this.setCurrentDirectory(parent);
        }
    }

    public void setHiddenRule(FileType rule) {
        if (rule != this.hiddenRule) {
            FileType oldRule = this.hiddenRule;
            this.hiddenRule = rule;
            this.invalidateCache();
            this.firePropertyChange("hiddenRule", oldRule, rule);
            this.fireContentsChanged();
        }
    }

    public FileType getHiddenRule() {
        return this.hiddenRule;
    }

    public FileType getShownType() {
        return this.shownType;
    }

    public void setShownType(FileType t) {
        this.shownType = t;
        if (t != null) {
            this.addKnownFileType(t);
        }
        this.invalidateCache();
        this.firePropertyChange("shownType", null, null);
        this.fireContentsChanged();
    }

    public void addKnownFileType(FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("msgDMCannotAdd"));
        }
        if (!this.knownTypes.contains(type)) {
            this.knownTypes.addElement(type);
            this.invalidateCache();
            this.firePropertyChange("knownFileTypes", null, null);
            this.fireContentsChanged();
        }
    }

    public Enumeration enumerateKnownFileTypes() {
        return this.knownTypes.elements();
    }

    public Vector getKnownFileTypes() {
        return (Vector)this.knownTypes.clone();
    }

    public boolean isKnownFileType(FileType t) {
        return this.knownTypes.contains(t);
    }

    public void setKnownFileTypes(FileType[] types) {
        int count = types.length;
        Vector<FileType> newTypes = this.knownTypes = new Vector<FileType>(count);
        newTypes.setSize(count);
        for (int i = 0; i < count; ++i) {
            FileType t = types[i];
            newTypes.setElementAt(t, i);
        }
        this.invalidateCache();
        this.firePropertyChange("knownFileTypes", null, null);
        this.fireContentsChanged();
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    protected boolean isWindowsFileSystem() {
        if (!this.haveCheckedWindows) {
            String p;
            this.isWindows = false;
            if (File.pathSeparator.equals(";") && File.separator.equals("\\") && (p = this.getCurrentDirectory().getAbsolutePath()).length() >= 3) {
                char zero = p.charAt(0);
                char one = p.charAt(1);
                char two = p.charAt(2);
                this.isWindows = one == ':' && two == '\\' && (zero >= 'A' && zero <= 'Z' || zero >= 'a' && zero <= 'z');
            }
            this.haveCheckedWindows = true;
        }
        return this.isWindows;
    }

    protected void sort(Vector v) {
        this.quickSort(v, 0, v.size() - 1);
    }

    protected boolean lt(TypedFile a, TypedFile b) {
        boolean bIsADirectory;
        boolean aIsADirectory = a.getType().isContainer();
        if (aIsADirectory != (bIsADirectory = b.getType().isContainer())) {
            return aIsADirectory;
        }
        return a.getName().toLowerCase().compareTo(b.getName().toLowerCase()) < 0;
    }

    private void swap(Vector a, int i, int j) {
        Object T = a.elementAt(i);
        a.setElementAt(a.elementAt(j), i);
        a.setElementAt(T, j);
    }

    protected void quickSort(Vector v, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            TypedFile mid = (TypedFile)v.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && this.lt((TypedFile)v.elementAt(lo), mid)) {
                    ++lo;
                }
                while (hi > lo0 && this.lt(mid, (TypedFile)v.elementAt(hi))) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(v, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(v, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(v, lo, hi0);
            }
        }
    }

    public int getSize() {
        Vector files = this.getTypedFiles();
        return files.size();
    }

    public Object getElementAt(int index) {
        return this.getTypedFiles().elementAt(index);
    }

    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = DirectoryModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = DirectoryModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l);
    }

    protected void fireContentsChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? DirectoryModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WindowsRootDir
    extends TypedFile {
        protected WindowsRootDir() {
            super("");
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean exists() {
            return true;
        }

        public String getAbsolutePath() {
            return this.getName();
        }

        public String getCanonicalPath() throws IOException {
            throw new IOException();
        }

        public String getName() {
            String hostName;
            try {
                char[] name = InetAddress.getLocalHost().getHostName().toCharArray();
                name[0] = Character.toUpperCase(name[0]);
                hostName = new String(name);
            }
            catch (UnknownHostException e) {
                hostName = ResourceBundle.getBundle("com/iplanet/ias/tools/forte/i18n/Bundle").getString("DM_myCompyuter");
            }
            return hostName;
        }

        public String getParent() {
            return null;
        }

        public String getPath() {
            return this.getName();
        }

        public boolean isAbsolute() {
            return true;
        }

        public boolean isDirectory() {
            return true;
        }

        public boolean isFile() {
            return false;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String[] list() {
            return this.list(null);
        }

        public String[] list(FilenameFilter filter) {
            boolean windows = true;
            Vector<String> deviceVector = new Vector<String>();
            for (char c = 'C'; c <= 'Z'; c = (char)((char)(c + 1))) {
                char[] device = new char[]{c, ':', '\\'};
                String devName = new String(device);
                File devFile = new File(devName);
                if (devFile == null || !devFile.exists()) continue;
                deviceVector.addElement(devName);
            }
            int count = deviceVector.size() + 1;
            String[] devices = new String[count];
            devices[0] = "A:\\";
            if (count > 1) {
                for (int i = 1; i < count; ++i) {
                    devices[i] = (String)deviceVector.elementAt(i - 1);
                }
            }
            return devices;
        }

        public boolean mkdir() {
            return false;
        }

        public boolean mkdirs() {
            return false;
        }

        public boolean renameTo() {
            return false;
        }
    }
}

