/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.globalsettings;

import com.iplanet.ias.tools.common.datasource.IDSBean;
import com.iplanet.ias.tools.common.deploy.IAdminInstanceBean;
import com.iplanet.ias.tools.common.deploy.IJdbcConnectionPool;
import com.iplanet.ias.tools.common.deploy.IJmsResource;
import com.iplanet.ias.tools.common.deploy.IMailResource;
import com.iplanet.ias.tools.common.deploy.IPMFactory;
import com.iplanet.ias.tools.common.deploy.IServerInstanceBean;
import com.iplanet.ias.tools.common.util.ViewLogInterval;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.Installer;
import com.iplanet.ias.tools.forte.globalsettings.ReadExtraOptionsInterface;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerRegistry;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class IasGlobalOptionsSettings
extends SystemOption {
    static final long serialVersionUID = 6075618933219905520L;
    private static IasGlobalOptionsSettings DEFAULT;
    public static final String PROP_IASInstallDirectory = "IASInstallDirectory";
    private boolean initialized = false;
    private static List AdminInstances;
    private static List ServerInstances;
    private static List DataSourcesList;
    private static List PMFactoryList;
    private static List JmsResourceList;
    private static List MailResourceList;
    private static List JdbcConnectionPoolList;
    private static List InstancesList;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings;

    protected void initialize() {
        super.initialize();
        this.getReporterLevel();
        this.getLogInterval();
        Reporter.verbose("in IasGlobalOptionsSettings initialize ServerInstances=" + ServerInstances);
        if (AdminInstances == null) {
            AdminInstances = new ArrayList();
        }
        if (ServerInstances == null) {
            ServerInstances = new ArrayList();
        }
        if (DataSourcesList == null) {
            DataSourcesList = new ArrayList();
        }
        if (PMFactoryList == null) {
            PMFactoryList = new ArrayList();
        }
        if (JmsResourceList == null) {
            JmsResourceList = new ArrayList();
        }
        if (MailResourceList == null) {
            MailResourceList = new ArrayList();
        }
        if (JdbcConnectionPoolList == null) {
            JdbcConnectionPoolList = new ArrayList();
        }
        Reporter.verbose("in IasGlobalOptionsSettings initialize this=" + (Object)((Object)this));
    }

    public String displayName() {
        IasGlobalOptionsSettings.getSingleton();
        return NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings == null ? (class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings = IasGlobalOptionsSettings.class$("com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings")) : class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings), (String)"LBL_settings");
    }

    public static IasGlobalOptionsSettings getSingleton() {
        if (DEFAULT == null) {
            DEFAULT = (IasGlobalOptionsSettings)IasGlobalOptionsSettings.findObject((Class)(class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings == null ? (class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings = IasGlobalOptionsSettings.class$("com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings")) : class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings), (boolean)true);
        }
        return DEFAULT;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("S1_options.html");
    }

    public File getTempDir() {
        Object o = this.getProperty("TempDir");
        if (o == null || !(o instanceof File) || !((File)o).exists()) {
            String forteUserDir = System.getProperty("netbeans.user");
            File dir = this.isUNIX() ? new File(forteUserDir + "/tmp/sunOne") : new File(forteUserDir + "\\temp\\sunOne");
            this.setTempDir(dir);
            return dir;
        }
        return (File)o;
    }

    public void setTempDir(File dir) {
        if (dir == null || dir.getPath().length() <= 0) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists() && !dir.isDirectory()) {
            NotifyUtil.showError(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings == null ? (class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings = IasGlobalOptionsSettings.class$("com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings")) : class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings), (String)"Msg_ChosenDirFile"), NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings == null ? (class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings = IasGlobalOptionsSettings.class$("com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings")) : class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings), (String)"Err_TempDir"));
            return;
        }
        if (!dir.exists()) {
            NotifyUtil.showError(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings == null ? (class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings = IasGlobalOptionsSettings.class$("com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings")) : class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings), (String)"Msg_ChosenDirNoExist"), NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings == null ? (class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings = IasGlobalOptionsSettings.class$("com.iplanet.ias.tools.forte.globalsettings.IasGlobalOptionsSettings")) : class$com$iplanet$ias$tools$forte$globalsettings$IasGlobalOptionsSettings), (String)"Err_TempDir"));
            return;
        }
        this.putProperty("TempDir", dir, true);
    }

    public String getReporterLevel() {
        String lev = (String)this.getProperty("ForteReporterDebugLevel");
        if (lev == null) {
            lev = System.getProperty("ForteReporterDebugLevel");
        }
        if (lev == null) {
            lev = System.getProperty("ReporterDebugLevel");
        }
        if (lev == null) {
            lev = System.getProperty("ReporterSeverityLevel");
        }
        if (lev == null) {
            lev = System.getProperty("ReporterLevel");
        }
        if (lev == null) {
            lev = System.getProperty("Reporter");
        }
        if (lev == null) {
            lev = "1000";
        }
        Reporter.setSeverityLevel(lev);
        return lev;
    }

    public void setReporterLevel(String level) {
        InetAddress IP = null;
        this.putProperty("ForteReporterDebugLevel", level, true);
        Reporter.setSeverityLevel(level);
        String msg = null;
        ArrayList<String> ads = new ArrayList<String>();
        System.setProperty("ForteReporterDebugLevel", "" + Reporter.getSeverityLevel());
        int severitylevel = Integer.parseInt(level.trim());
        Class[] argsEnab = new Class[]{Boolean.TYPE};
        Class[] args = new Class[]{Integer.TYPE};
        Object[] objEnab = new Object[1];
        Object[] obj = new Object[]{new Integer(1)};
        objEnab[0] = severitylevel >= 0 && severitylevel < 7 ? Boolean.TRUE : Boolean.FALSE;
        try {
            Class<?> cc = Installer.getIASPluginClassLoader().loadClass("com.iplanet.ias.admin.util.Debug");
            Method setEnabled = cc.getMethod("setEnabled", argsEnab);
            Method setDebugLevel = cc.getMethod("setDebugLevel", args);
            for (int i = 0; i < AdminInstances.size(); ++i) {
                IAdminInstanceBean instance = this.getAdminInstance(i);
                try {
                    IP = InetAddress.getByName(instance.getHost());
                    Socket s = new Socket(IP, instance.getPort());
                    s.close();
                    setEnabled.invoke((Object)instance, objEnab);
                    setDebugLevel.invoke((Object)instance, obj);
                    continue;
                }
                catch (UnknownHostException e) {
                    msg = e.getLocalizedMessage();
                    ads.add(instance.getDisplayName());
                    continue;
                }
                catch (IOException con) {
                    msg = con.getLocalizedMessage();
                    ads.add(instance.getDisplayName());
                    continue;
                }
                catch (IllegalAccessException iae) {
                    msg = iae.getLocalizedMessage();
                    continue;
                }
                catch (IllegalArgumentException iat) {
                    msg = iat.getLocalizedMessage();
                    continue;
                }
                catch (InvocationTargetException it) {
                    msg = it.getLocalizedMessage();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getLogInterval() {
        String ms = (String)this.getProperty("ViewLogInterval");
        ViewLogInterval.setLogInterval(ms);
        ms = "" + ViewLogInterval.getLogInterval();
        return ms;
    }

    public void setLogInterval(String ms) {
        this.putProperty("ViewLogInterval", ms, true);
        ViewLogInterval.setLogInterval(ms);
        System.setProperty("ViewLogInterval", "" + ViewLogInterval.getLogInterval());
    }

    public String[] getGroups() {
        String[] groups = (String[])this.getProperty("SecurityRoleGroups");
        return groups;
    }

    public void setGroups(String[] groups) {
        this.putProperty("SecurityRoleGroups", groups, true);
    }

    public String[] getUsers() {
        String[] users = (String[])this.getProperty("SecurityRoleUsers");
        return users;
    }

    public void setUsers(String[] users) {
        this.putProperty("SecurityRoleUsers", users, true);
    }

    public File getIASInstallDirectory() {
        File f = (File)this.getProperty(PROP_IASInstallDirectory);
        if (f == null) {
            this.setIASInstallDirectory(Installer.getIASInstallDirectory());
        }
        return (File)this.getProperty(PROP_IASInstallDirectory);
    }

    public void setIASInstallDirectory(File IASInstallDirectory) {
        this.putProperty(PROP_IASInstallDirectory, IASInstallDirectory, true);
    }

    public List getAdminInstances() {
        return AdminInstances;
    }

    public void insertIntoAdminInstances(IAdminInstanceBean m) {
        AdminInstances.add(m);
        this.firePropertyChange("AdminInstances", null, AdminInstances);
    }

    public void removeAdminInstance(IAdminInstanceBean m) {
        ArrayList<IServerInstanceBean> temp = new ArrayList<IServerInstanceBean>();
        for (int i = 0; i < ServerInstances.size(); ++i) {
            IServerInstanceBean instance = this.getServerInstance(i);
            String serv_inst = instance.getName();
            if (serv_inst.indexOf(m.getName()) == -1) continue;
            temp.add(instance);
        }
        for (int j = 0; j < temp.size(); ++j) {
            ServerInstances.remove(temp.get(j));
        }
        AdminInstances.remove(m);
        this.firePropertyChange("AdminInstances", null, AdminInstances);
    }

    public synchronized void removeAllAdminInstances() {
        this.removeAllServerInstances();
        AdminInstances.clear();
        this.firePropertyChange("AdminInstances", null, AdminInstances);
    }

    public IServerInstanceBean getServerInstanceBean(String name) {
        for (int i = 0; i < ServerInstances.size(); ++i) {
            IServerInstanceBean instance = this.getServerInstance(i);
            String serv_inst = instance.getName();
            if (!serv_inst.equals(name)) continue;
            return instance;
        }
        return null;
    }

    public IAdminInstanceBean getAdminInstanceBean(String aname) {
        IAdminInstanceBean admin_bean = null;
        for (int i = 0; i < AdminInstances.size(); ++i) {
            IAdminInstanceBean instance = this.getAdminInstance(i);
            String a_inst = instance.getName();
            if (!a_inst.equals(aname)) continue;
            admin_bean = instance;
        }
        return admin_bean;
    }

    public IAdminInstanceBean getAdminInstance(int where) {
        return (IAdminInstanceBean)AdminInstances.get(where);
    }

    public List getServerInstances() {
        return ServerInstances;
    }

    public List getAServerInstances(String name) {
        InstancesList = new ArrayList();
        for (int i = 0; i < ServerInstances.size(); ++i) {
            IServerInstanceBean instance = this.getServerInstance(i);
            String serv_inst = instance.getName();
            if (serv_inst.indexOf(name) == -1) continue;
            InstancesList.add(instance);
        }
        return InstancesList;
    }

    public List getDataSources() {
        return DataSourcesList;
    }

    public void insertIntoDSInstance(IDSBean m) {
        DataSourcesList.add(m);
        this.firePropertyChange("DataSourcesList", null, DataSourcesList);
    }

    public void removeDSInstance(IDSBean m) {
        DataSourcesList.remove(m);
        this.firePropertyChange("DataSourcesList", null, DataSourcesList);
    }

    public IDSBean getDSInstance(int loc) {
        return (IDSBean)DataSourcesList.get(loc);
    }

    public int getDataSourceLoc(String dname) {
        int loc = 0;
        for (int i = 0; i < DataSourcesList.size(); ++i) {
            IDSBean instance = this.getDSInstance(i);
            String ds_inst = instance.getName();
            if (!ds_inst.equals(dname)) continue;
            loc = i;
        }
        return loc;
    }

    public IServerInstanceBean getServerInstance(int where) {
        return (IServerInstanceBean)ServerInstances.get(where);
    }

    public IServerInstanceBean getDefaultServerInstance() {
        if (ServerInstances.size() == 0) {
            try {
                this.insertIntoServerInstances((IServerInstanceBean)Installer.getIASPluginClassLoader().loadClass("com.iplanet.ias.tools.forte.server.ServerInstanceBean").newInstance());
                ServerRegistry.getServerRegistry().setDefaultAppInstance((ServerInstance)this.getServerInstance(0));
                Reporter.verbose(" ServerInstanceBean getDefaultServerInstance ZERO OF THEM" + this.getServerInstance(0));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Reporter.verbose(" ServerInstanceBean getDefaultServerInstance ZERO OF THEM" + this.getServerInstance(0));
            return this.getServerInstance(0);
        }
        Object si = null;
        if (si != null) {
            if (si instanceof IServerInstanceBean) {
                return si;
            }
        } else {
            ServerRegistry.getServerRegistry().setDefaultAppInstance((ServerInstance)this.getServerInstance(0));
        }
        return this.getServerInstance(0);
    }

    public IServerInstanceBean getLocalServerInstance() {
        String localhost = "localhost";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            // empty catch block
        }
        IServerInstanceBean local_instance = null;
        for (int i = 0; i < ServerInstances.size(); ++i) {
            IServerInstanceBean instance = this.getServerInstance(i);
            String serv_inst = instance.getHost();
            if (!serv_inst.equals(localhost)) continue;
            local_instance = instance;
        }
        return local_instance;
    }

    public int getServerInstanceLoc(String dname) {
        int loc = 0;
        String localhost = "localhost";
        for (int i = 0; i < ServerInstances.size(); ++i) {
            IServerInstanceBean instance = this.getServerInstance(i);
            try {
                localhost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
            String serv_inst = instance.getName();
            if (!serv_inst.equals(dname)) continue;
            loc = i;
        }
        return loc;
    }

    public void insertIntoServerInstances(IServerInstanceBean m) {
        ServerInstances.add(m);
        this.firePropertyChange("ServerInstances", null, ServerInstances);
    }

    public void insertIntoServerInstancesAt(IServerInstanceBean m, int where) {
        ServerInstances.add(where, m);
        this.firePropertyChange("ServerInstances", null, ServerInstances);
    }

    public void moveInServerInstances(int oldIndex, int newIndex, int numberOfElements) {
        if (oldIndex < 0 || newIndex < 0 || oldIndex + numberOfElements > ServerInstances.size() || newIndex > ServerInstances.size()) {
            throw new ArrayIndexOutOfBoundsException("Move(" + oldIndex + "," + newIndex + "," + numberOfElements + ") on ServerInstances[" + ServerInstances.size() + "]");
        }
        for (int i = 0; i < numberOfElements; ++i) {
            IServerInstanceBean x = (IServerInstanceBean)ServerInstances.get(oldIndex);
            ServerInstances.remove(oldIndex);
            ServerInstances.add(newIndex, x);
        }
        this.firePropertyChange("ServerInstances", null, ServerInstances);
    }

    public void removeServerInstancesofAdmin(IAdminInstanceBean bn) {
        String admin = bn.getName();
        for (int i = ServerInstances.size() - 1; i >= 0; --i) {
            IServerInstanceBean instance = this.getServerInstance(i);
            String serv_inst = instance.getName();
            if (serv_inst.indexOf(admin) == -1) continue;
            ServerInstances.remove(this.getServerInstance(i));
        }
    }

    public void removeFromServerInstances(IServerInstanceBean m) {
        ServerInstances.remove(m);
        this.firePropertyChange("ServerInstances", null, ServerInstances);
    }

    public synchronized void removeAllServerInstances() {
        ServerInstances.clear();
        this.firePropertyChange("ServerInstances", null, ServerInstances);
    }

    public void setServerInstances(int where, IServerInstanceBean n) {
        ServerInstances.set(where, n);
        this.firePropertyChange("ServerInstances", null, ServerInstances);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IasGlobalOptionsSettings.writeIasSettings();
    }

    public static void writeIasSettings() {
        try {
            ReadExtraOptionsInterface reader = (ReadExtraOptionsInterface)Installer.getIASPluginClassLoader().loadClass("com.iplanet.ias.tools.forte.globalsettings.ReadExtraOptions").newInstance();
            reader.saveList(AdminInstances);
            reader.saveList(ServerInstances);
            reader.saveList(DataSourcesList);
            reader.saveList(PMFactoryList);
            reader.saveList(JmsResourceList);
            reader.saveList(JdbcConnectionPoolList);
            reader.saveList(MailResourceList);
            reader.close();
            Reporter.verbose("writeExternal " + ServerInstances);
        }
        catch (Exception e) {
            Reporter.verbose("exception in writing options" + e);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static void readIasSettings() {
        try {
            ReadExtraOptionsInterface reader = (ReadExtraOptionsInterface)Installer.getIASPluginClassLoader().loadClass("com.iplanet.ias.tools.forte.globalsettings.ReadExtraOptions").newInstance();
            AdminInstances = reader.readList();
            ServerInstances = reader.readList();
            DataSourcesList = reader.readList();
            PMFactoryList = reader.readList();
            JmsResourceList = reader.readList();
            JdbcConnectionPoolList = reader.readList();
            MailResourceList = reader.readList();
            reader.close();
        }
        catch (Exception e) {
            Reporter.verbose("exception in reading options" + e);
        }
    }

    private boolean isUNIX() {
        return File.pathSeparatorChar == ':';
    }

    public List getPMFactoryInsts() {
        return PMFactoryList;
    }

    public void insertIntoPMFactoryInstance(IPMFactory m) {
        PMFactoryList.add(m);
        this.firePropertyChange("PMFactoryList", null, PMFactoryList);
    }

    public void removePMFactoryInstance(IPMFactory m) {
        PMFactoryList.remove(m);
        this.firePropertyChange("PMFactoryList", null, PMFactoryList);
    }

    public IPMFactory getPMFactoryInstance(int loc) {
        return (IPMFactory)PMFactoryList.get(loc);
    }

    public int getPMFactoryLoc(String dname) {
        int loc = 0;
        for (int i = 0; i < PMFactoryList.size(); ++i) {
            IPMFactory instance = this.getPMFactoryInstance(i);
            String ds_inst = instance.getName();
            if (!ds_inst.equals(dname)) continue;
            loc = i;
        }
        return loc;
    }

    public List getJmsResources() {
        if (JmsResourceList == null) {
            JmsResourceList = new ArrayList();
        }
        return JmsResourceList;
    }

    public void insertIntoJmsResourceInstance(IJmsResource m) {
        JmsResourceList.add(m);
        this.firePropertyChange("JmsResourceList", null, JmsResourceList);
    }

    public void removeJmsResourceInstance(IJmsResource m) {
        JmsResourceList.remove(m);
        this.firePropertyChange("JmsResourceList", null, JmsResourceList);
    }

    public IJmsResource getJmsResourceInstance(int loc) {
        return (IJmsResource)JmsResourceList.get(loc);
    }

    public int getJmsResourceLoc(String dname) {
        int loc = 0;
        for (int i = 0; i < JmsResourceList.size(); ++i) {
            IJmsResource instance = this.getJmsResourceInstance(i);
            String jmsres_inst = instance.getName();
            if (!jmsres_inst.equals(dname)) continue;
            loc = i;
        }
        return loc;
    }

    public List getMailResources() {
        if (MailResourceList == null) {
            MailResourceList = new ArrayList();
        }
        return MailResourceList;
    }

    public void insertIntoMailResourceInstance(IMailResource m) {
        MailResourceList.add(m);
        this.firePropertyChange("MailResourceList", null, MailResourceList);
    }

    public void removeMailResourceInstance(IMailResource m) {
        MailResourceList.remove(m);
        this.firePropertyChange("MailResourceList", null, MailResourceList);
    }

    public IMailResource getMailResourceInstance(int loc) {
        return (IMailResource)MailResourceList.get(loc);
    }

    public int getMailResourceLoc(String dname) {
        int loc = 0;
        for (int i = 0; i < MailResourceList.size(); ++i) {
            IMailResource instance = this.getMailResourceInstance(i);
            String mailres_inst = instance.getName();
            if (!mailres_inst.equals(dname)) continue;
            loc = i;
        }
        return loc;
    }

    public List getJdbcConnectionPoolList() {
        if (JdbcConnectionPoolList == null) {
            JdbcConnectionPoolList = new ArrayList();
        }
        return JdbcConnectionPoolList;
    }

    public void insertIntoJdbcConnectionPoolInstance(IJdbcConnectionPool m) {
        JdbcConnectionPoolList.add(m);
        this.firePropertyChange("JdbcConnectionPoolList", null, JdbcConnectionPoolList);
    }

    public void removeJdbcConnectionPoolInstance(IJdbcConnectionPool m) {
        JdbcConnectionPoolList.remove(m);
        this.firePropertyChange("JdbcConnectionPoolList", null, JdbcConnectionPoolList);
    }

    public IJdbcConnectionPool getJdbcConnectionPoolInstance(int loc) {
        return (IJdbcConnectionPool)JdbcConnectionPoolList.get(loc);
    }

    public int getJdbcConnectionPoolLoc(String dname) {
        int loc = 0;
        for (int i = 0; i < JdbcConnectionPoolList.size(); ++i) {
            IJdbcConnectionPool instance = this.getJdbcConnectionPoolInstance(i);
            String cp_inst = instance.getName();
            if (!cp_inst.equals(dname)) continue;
            loc = i;
        }
        return loc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AdminInstances = new ArrayList();
        ServerInstances = new ArrayList();
        DataSourcesList = new ArrayList();
        PMFactoryList = new ArrayList();
        JmsResourceList = new ArrayList();
        MailResourceList = new ArrayList();
        JdbcConnectionPoolList = new ArrayList();
        InstancesList = new ArrayList();
        IasGlobalOptionsSettings.readIasSettings();
    }
}

