/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejbmodule;

import com.iplanet.ias.tools.common.util.ExtractUtils;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.IASServer;
import com.iplanet.ias.tools.forte.ejbmodule.EjbJarModel;
import com.sun.forte4j.j2ee.ejb.EJBeanDataObject;
import com.sun.forte4j.j2ee.ejb.types.EntJavaBean;
import com.sun.forte4j.j2ee.ejbmodule.EJBModuleDataObject;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.EjbJar;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.EnterpriseBeans;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.Entity;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.MessageDriven;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.Session;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.server.ConfigInputStream;
import org.netbeans.modules.j2ee.server.ConfigOutputStream;
import org.netbeans.modules.j2ee.server.ConfigSupport;
import org.netbeans.modules.j2ee.server.app.AppServer;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;
import org.netbeans.modules.j2ee.server.datamodel.J2eeAppStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.ejbmodule.EjbModuleConfigSupport;
import org.netbeans.modules.j2ee.server.importear.ImportDescription;
import org.netbeans.modules.j2ee.server.importear.ServerImport;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.cookies.SaveCookie;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class ExtractEjbJarFile {
    private EjbJarModel ejbJarModel;
    private DataObject ejbJarObject;
    FileObject templateFolder = null;
    Repository repository = null;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public ExtractEjbJarFile(DataObject ejbJarObject, EjbJarModel model) {
        Reporter.verbose("ExtractEjbJarFile");
        this.ejbJarModel = model;
        this.ejbJarObject = ejbJarObject;
    }

    public synchronized void extract() throws IOException {
        Reporter.verbose("extract");
        this.repository = (Repository)Lookup.getDefault().lookup(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = ExtractEjbJarFile.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository);
        this.templateFolder = this.repository.findResource("/J2EE/ImportTemplates");
        String baseName = "import-" + this.ejbJarObject.getPrimaryFile().getName();
        Reporter.verbose("baseName :" + baseName);
        DataFolder importFolder = this.getUniqueFolder(this.ejbJarObject.getFolder(), baseName);
        Reporter.verbose("importFolder :" + importFolder);
        AppServer[] servers = ServerRegistryImpl.getRegistry().getAppServers();
        AppServer server = null;
        for (int i = 0; i < servers.length; ++i) {
            if (!(servers[i] instanceof IASServer)) continue;
            server = servers[i];
            Reporter.verbose("server :" + server);
            break;
        }
        ServerImport serverImport = server.getServerImport();
        Reporter.verbose(" serverImport :" + serverImport);
        DataObject obj = this.extractModule(importFolder, serverImport, server);
    }

    DataObject extractModule(DataFolder importFolder, ServerImport serverImport, AppServer server) throws IOException {
        Reporter.verbose("extractModule");
        EJBModuleDataObject ret = null;
        EJBModuleDataObject mdo = null;
        EjbJar ejbJar = this.ejbJarModel.getEjbJar();
        Reporter.verbose("ejbJar" + ejbJar);
        DataFolder classesFolder = null;
        classesFolder = this.getUniqueFolder(importFolder, "ejbmodule-classes");
        if (classesFolder != null) {
            Reporter.verbose("****************** classesFolder" + classesFolder);
            this.ejbJarModel.extractJar(classesFolder, new String[]{"META-INF"});
            this.mountFolder(classesFolder);
        }
        String name = ejbJar.getDisplayName();
        Reporter.verbose("name" + name);
        if (name == null || name.equals("")) {
            name = "EjbModule";
        }
        FileObject newFO = this.mkNewObject("EJB_Module.ejbmodule", importFolder, name, "ejbmodule");
        mdo = (EJBModuleDataObject)DataObject.find((FileObject)newFO);
        EjbJar descrip = mdo.getOverrides();
        Reporter.verbose("descrip" + descrip);
        ExtractUtils.copyUserInfo(ejbJar, descrip);
        if (mdo != null) {
            Reporter.verbose("mdo " + mdo);
            SaveCookie save = (SaveCookie)mdo.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ExtractEjbJarFile.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (save != null) {
                try {
                    save.save();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        String[] names = this.ejbJarModel.getContents("META-INF");
        ImportDescription importDescription = this.mkDescrip(serverImport, "META-INF/", names);
        EjbModuleConfigSupport configSupport = server.getEjbModuleConfigSupport();
        Reporter.verbose("configSupport :" + configSupport);
        ConfigOutputStream[] outs = this.mkConfigOutput((DataObject)mdo, (ConfigSupport)configSupport);
        ModuleImpl data = new ModuleImpl(){

            public String getEjb() {
                return null;
            }
        };
        serverImport.importModule((StandardData)data, null, importDescription, outs);
        if (mdo != null) {
            mdo = (EJBModuleDataObject)this.reloadObj((DataObject)mdo);
        }
        Vector<EntJavaBean> ejbs = new Vector<EntJavaBean>();
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        configSupport = server.getEjbConfigSupport();
        Reporter.verbose("configSupport :" + configSupport);
        Entity[] entities = beans.getEntity();
        Reporter.verbose("no of entity beans:" + entities.length);
        for (int i = 0; i < entities.length; ++i) {
            EJBeanDataObject obj = this.extractEjb(entities[i], importFolder, serverImport, importDescription, (ConfigSupport)configSupport);
            if (obj == null) continue;
            ejbs.add(obj.getEntJavaBean());
        }
        Session[] sessions = beans.getSession();
        Reporter.verbose("no of session beans:" + sessions.length);
        for (int i = 0; i < sessions.length; ++i) {
            EJBeanDataObject obj = this.extractEjb(sessions[i], importFolder, serverImport, importDescription, (ConfigSupport)configSupport);
            if (obj == null) continue;
            ejbs.add(obj.getEntJavaBean());
        }
        MessageDriven[] messages = beans.getMessageDriven();
        Reporter.verbose("no of message beans:" + messages.length);
        for (int i = 0; i < messages.length; ++i) {
            EJBeanDataObject obj = this.extractEjb(messages[i], importFolder, serverImport, importDescription, (ConfigSupport)configSupport);
            if (obj == null) continue;
            ejbs.add(obj.getEntJavaBean());
        }
        if (mdo != null) {
            Object[] ents = new EntJavaBean[ejbs.size()];
            ejbs.copyInto(ents);
            mdo.addEJB((EntJavaBean[])ents);
            ret = mdo;
        }
        return ret;
    }

    private EJBeanDataObject mkEjbDataObject(String template, String name, DataFolder importFolder) throws IOException {
        Reporter.verbose("mkEjbDataObject");
        DataObject ret = null;
        name = this.getUniqueFileName(importFolder, name, "ejbdd");
        Reporter.verbose("name : " + name);
        DataObject ejbTemplate = DataObject.find((FileObject)this.templateFolder.getFileObject(template));
        ret = ejbTemplate.createFromTemplate(importFolder, name);
        return (EJBeanDataObject)ret;
    }

    private EJBeanDataObject extractEjb(String temp, String name, BaseBean bean, DataFolder importFolder, ServerImport serverImport, ImportDescription importDescription, ConfigSupport configSupport) throws IOException {
        Reporter.verbose("extractEjb");
        EJBeanDataObject dobj = this.mkEjbDataObject(temp, name, importFolder);
        if (dobj == null) {
            return null;
        }
        BaseBean newBean = (BaseBean)dobj.getEntJavaBean().getDDBean();
        newBean.merge(bean, 3);
        SaveCookie save = (SaveCookie)dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ExtractEjbJarFile.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (save != null) {
            try {
                save.save();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ConfigOutputStream[] outs = this.mkConfigOutput((DataObject)dobj, configSupport);
        EjbStandardData.Ejb data = dobj.getEntJavaBean().getEjbStandardData();
        serverImport.importEjb((StandardData)data, null, importDescription, outs);
        dobj = (EJBeanDataObject)this.reloadObj((DataObject)dobj);
        return dobj;
    }

    private DataObject reloadObj(DataObject obj) throws IOException {
        Reporter.verbose("reloadObj");
        FileObject primary = obj.getPrimaryFile();
        try {
            obj.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return DataObject.find((FileObject)primary);
    }

    private EJBeanDataObject extractEjb(Entity ejb, DataFolder importFolder, ServerImport serverImport, ImportDescription importDescription, ConfigSupport configSupport) throws IOException {
        Reporter.verbose("extractEjb");
        String template = "Entity.ejbdd";
        if ("Container".equals(ejb.getPersistenceType())) {
            template = "Cmp.ejbdd";
            if (ejb.graphManager().getXmlDocument().getDoctype().getSystemId().indexOf("1_1") > 0) {
                ejb.setCmpVersion("1.x");
            }
        }
        return this.extractEjb(template, ejb.getEjbName(), (BaseBean)ejb, importFolder, serverImport, importDescription, configSupport);
    }

    private EJBeanDataObject extractEjb(MessageDriven ejb, DataFolder importFolder, ServerImport serverImport, ImportDescription importDescription, ConfigSupport configSupport) throws IOException {
        Reporter.verbose("extractEjb");
        return this.extractEjb("Message.ejbdd", ejb.getEjbName(), (BaseBean)ejb, importFolder, serverImport, importDescription, configSupport);
    }

    private EJBeanDataObject extractEjb(Session ejb, DataFolder importFolder, ServerImport serverImport, ImportDescription importDescription, ConfigSupport configSupport) throws IOException {
        Reporter.verbose("extractEjb");
        return this.extractEjb("Session.ejbdd", ejb.getEjbName(), (BaseBean)ejb, importFolder, serverImport, importDescription, configSupport);
    }

    private DataFolder mountFolder(DataFolder folder) throws IOException {
        Reporter.verbose("mountFolder");
        File file = NbClassPath.toFile((FileObject)folder.getPrimaryFile());
        FileSystem fs = this.mkLocalFileSystem(file);
        return (DataFolder)DataObject.find((FileObject)fs.getRoot());
    }

    private FileSystem mkLocalFileSystem(File root) throws IOException {
        LocalFileSystem fs = new LocalFileSystem();
        try {
            fs.setRootDirectory(root);
        }
        catch (PropertyVetoException pve) {
            throw new IOException(pve.getMessage());
        }
        this.repository.addFileSystem((FileSystem)fs);
        return fs;
    }

    private DataFolder getNewFsRoot(String path) throws IOException {
        File loc = new File(path);
        loc.createNewFile();
        FileSystem fs = this.mkLocalFileSystem(loc);
        return (DataFolder)DataObject.find((FileObject)fs.getRoot());
    }

    private DataFolder getUniqueFolder(DataFolder parent, String baseName) throws IOException {
        Reporter.verbose("getUniqueFolder");
        baseName = this.getUniqueFileName(parent, baseName, "");
        FileObject fo = this.templateFolder.getFileObject("Folder");
        DataObject template = DataObject.find((FileObject)fo);
        return (DataFolder)template.createFromTemplate(parent, baseName);
    }

    private String getUniqueFileName(DataFolder parent, String baseName, String ext) throws IOException {
        FileObject folder = parent.getPrimaryFile();
        FileObject tmp = folder.getFileObject(baseName, ext);
        int i = 0;
        while (tmp != null) {
            tmp = folder.getFileObject(baseName + ++i, ext);
        }
        if (i > 0) {
            baseName = baseName + i;
        }
        return baseName;
    }

    private FileObject getFolder(String str, FileSystem def) throws IOException {
        FileObject ret = this.repository.findResource(str);
        if (ret == null) {
            int index = str.lastIndexOf("/");
            FileObject dir = index < 1 ? def.getRoot() : this.getFolder(str.substring(0, index), def);
            ret = dir.createFolder(index < 1 ? str : str.substring(index));
        }
        return ret;
    }

    private FileObject mkNewObject(String temp, DataFolder folder, String name, String ext) throws IOException {
        Reporter.verbose("mkNewObject");
        name = this.getUniqueFileName(folder, name, ext);
        Reporter.verbose("name" + name);
        DataObject template = DataObject.find((FileObject)this.templateFolder.getFileObject(temp));
        try {
            template.createFromTemplate(folder, name).getPrimaryFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        return folder.getPrimaryFile().getFileObject(name, ext);
    }

    private FileObject mkNewObject(String temp, String target, String ext, FileSystem def) throws IOException {
        String name;
        DataFolder dest;
        int index = target.lastIndexOf("/");
        if (index < 0) {
            dest = (DataFolder)DataObject.find((FileObject)def.getRoot());
            name = target;
        } else {
            dest = (DataFolder)DataObject.find((FileObject)this.getFolder(target.substring(0, index), def));
            name = target.substring(index);
        }
        return this.mkNewObject(temp, dest, name, ext);
    }

    ImportDescription mkDescrip(ServerImport serverImport, String prefix, String[] names) throws IOException {
        Reporter.verbose("mkDescrip");
        return this.mkDescrip(serverImport, prefix, names, null);
    }

    ImportDescription mkDescrip(ServerImport serverImport, String prefix, String[] names, DataFolder target) throws IOException {
        Reporter.verbose("mkDescrip");
        Vector<String> v = new Vector<String>();
        for (int j = 0; j < names.length; ++j) {
            Reporter.verbose("names[" + j + "]" + names[j]);
            if (!serverImport.acceptsXmlFile(names[j])) continue;
            v.add(names[j]);
            if (target == null) continue;
            FileObject dir = target.getPrimaryFile().getFileObject(prefix.substring(0, prefix.length() - 1));
            FileObject obj = dir.getFileObject(names[j]);
            obj.delete();
        }
        Reporter.verbose("size" + v.size());
        if (v.size() == 0) {
            return null;
        }
        ConfigInputStream[] ins = new ConfigInputStream[v.size()];
        int index = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Reporter.verbose("name" + name);
            ins[index++] = new ImportConfigInputStream(name, this.ejbJarModel.getInputStream(prefix + name));
        }
        return serverImport.wrapStreams(ins);
    }

    ConfigOutputStream[] mkConfigOutput(DataObject obj, ConfigSupport support) throws IOException {
        Reporter.verbose("mkConfigOutput");
        return this.mkConfigOutput(obj, support.getFileExtensions());
    }

    ConfigOutputStream[] mkConfigOutput(DataObject obj, String[] exts) throws IOException {
        Reporter.verbose("mkConfigOutput");
        ConfigOutputStream[] outs = new ConfigOutputStream[exts.length];
        for (int j = 0; j < exts.length; ++j) {
            Reporter.verbose("exts[" + j + "]" + exts[j]);
            FileObject fo = obj.getPrimaryFile();
            String name = fo.getName();
            FileObject cfo = fo.getParent().getFileObject(name, exts[j]);
            if (cfo == null) {
                cfo = fo.getParent().createData(name, exts[j]);
            }
            outs[j] = new ImportConfigOutputStream(exts[j], cfo.getOutputStream(cfo.lock()));
        }
        return outs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static abstract class ModuleImpl
    implements J2eeAppStandardData.Module {
        ModuleImpl() {
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
        }

        public String getJava() {
            return null;
        }

        public String getEjb() {
            return null;
        }

        public String getConnector() {
            return null;
        }

        public String getAltDd() {
            return null;
        }

        public J2eeAppStandardData.Web getWeb() {
            return null;
        }
    }

    static class ImportConfigOutputStream
    implements ConfigOutputStream {
        String ext;
        OutputStream stream;

        ImportConfigOutputStream(String ext, OutputStream stream) {
            Reporter.verbose("ImportConfigOutputStream");
            Reporter.verbose("ext: " + ext);
            Reporter.verbose("stream: " + stream);
            this.ext = ext;
            this.stream = stream;
        }

        public String getFileExtension() {
            return this.ext;
        }

        public OutputStream getOutputStream() {
            return this.stream;
        }
    }

    static class ImportConfigInputStream
    implements ConfigInputStream {
        String ext;
        InputStream stream;

        ImportConfigInputStream(String ext, InputStream stream) {
            Reporter.verbose("ImportConfigInputStream");
            Reporter.verbose("ext: " + ext);
            Reporter.verbose("stream: " + stream);
            this.ext = ext;
            this.stream = stream;
        }

        public String getFileExtension() {
            return this.ext;
        }

        public InputStream getInputStream() {
            return this.stream;
        }
    }
}

