/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejbmodule;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejbmodule.EjbJarModel;
import com.sun.forte4j.j2ee.lib.dd.ejb2.gen.EjbJar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;

public class EjbJarModelImpl
implements EjbJarModel {
    FileObject ejbmodule;
    JarFile jar;

    public EjbJarModelImpl(FileObject ejbmodule) {
        Reporter.verbose("EjbJarModelImpl");
        this.ejbmodule = ejbmodule;
    }

    JarFile getJar() throws IOException {
        if (this.jar == null) {
            this.jar = this.createJar("ejbmodule", this.ejbmodule.getInputStream());
        }
        return this.jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile createJar(String name, InputStream in) throws IOException {
        JarFile jarFile;
        FileOutputStream out = null;
        try {
            File tmpFile = File.createTempFile(name, "ejbjarimport");
            out = new FileOutputStream(tmpFile);
            this.copyStream(in, out);
            jarFile = new JarFile(tmpFile);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_7 = null;
                in.close();
                if (out == null) break block3;
                ((OutputStream)out).close();
            }
            throw throwable;
        }
        in.close();
        if (out != null) {
            ((OutputStream)out).close();
        }
        return jarFile;
    }

    void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] tmp = new byte[10000];
        while ((len = in.read(tmp)) > 0) {
            out.write(tmp, 0, len);
        }
    }

    static InputStream getEntryStream(JarFile file, String path) throws IOException {
        Reporter.verbose("getEntryStream");
        JarEntry entry = file.getJarEntry(path);
        return file.getInputStream(entry);
    }

    public void extractJar(DataFolder directory) throws IOException {
        this.extractJar(directory, new String[0]);
    }

    public void extractJar(DataFolder directory, String[] filters) throws IOException {
        Reporter.verbose("extractJar");
        Enumeration<JarEntry> e = this.jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            boolean filtered = false;
            for (int i = 0; i < filters.length; ++i) {
                if (!name.startsWith(filters[i])) continue;
                filtered = true;
            }
            if (filtered) continue;
            this.writeInputStream(this.jar, entry, directory);
        }
    }

    void writeInputStream(JarFile jfile, ZipEntry entry, DataFolder target) throws IOException {
        String name = entry.getName();
        StringTokenizer path = new StringTokenizer(name, "/");
        String token = path.nextToken();
        FileObject dir = target.getPrimaryFile();
        while (path.hasMoreTokens()) {
            FileObject tmp = dir.getFileObject(token);
            dir = tmp == null ? dir.createFolder(token) : tmp;
            token = path.nextToken();
        }
        FileObject f = dir.getFileObject(token);
        if (entry.isDirectory()) {
            if (f == null) {
                dir.createFolder(token);
            }
        } else {
            if (f == null) {
                f = dir.createData(token);
            }
            FileLock lock = f.lock();
            this.copyStream(jfile.getInputStream(entry), f.getOutputStream(lock));
            lock.releaseLock();
        }
    }

    public EjbJar getEjbJar() throws IOException {
        this.getJar();
        Reporter.verbose("getEjbJar");
        InputStream in = EjbJarModelImpl.getEntryStream(this.jar, "META-INF/ejb-jar.xml");
        return EjbJar.createGraph((InputStream)in);
    }

    JarFile getJarFile() throws IOException {
        return this.getJar();
    }

    public void extractFiles(DataFolder directory, String[] names) throws IOException {
        for (int i = 0; i < names.length; ++i) {
            JarEntry entry = this.jar.getJarEntry(names[i]);
            if (entry == null) continue;
            this.writeInputStream(this.jar, entry, directory);
        }
    }

    public String[] getContents(String directory) throws IOException {
        Reporter.verbose("getContents");
        Vector<String> v = new Vector<String>();
        Enumeration<JarEntry> e = this.jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().startsWith(directory)) continue;
            v.add(entry.getName().substring(directory.length() + 1));
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public InputStream getInputStream(String fileUrl) throws IOException {
        Reporter.verbose("getInputStream");
        Reporter.verbose("fileUrl" + fileUrl);
        return EjbJarModelImpl.getEntryStream(this.jar, fileUrl);
    }

    public void extractFile(String name, FileObject fo) throws IOException {
        JarEntry entry = this.jar.getJarEntry(name);
        if (entry != null) {
            FileLock lock = fo.lock();
            this.copyStream(this.jar.getInputStream(entry), fo.getOutputStream(lock));
            lock.releaseLock();
        }
    }
}

