/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.security.Role;
import com.iplanet.ias.tools.forte.ejb.security.Utils;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.openide.util.NbBundle;

class RoleTree {
    private DefaultMutableTreeNode root = null;
    private DefaultTreeModel treeModel = null;
    private JTree tree = null;
    private Vector data = null;
    private JScrollPane scrollPane = null;
    private static final String userPrepend = "U ";
    private static final String groupPrepend = "G ";
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$ejb$security$RoleTree;

    RoleTree(Vector data) {
        this.data = data;
        this.initTreeData();
        this.tree = new JTree(this.treeModel);
        this.scrollPane = new JScrollPane(this.tree);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.treeModel.setAsksAllowsChildren(true);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.setSelectionMode(1);
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    JTree getJTree() {
        return this.tree;
    }

    void addRole(String name, String description) {
        if (this.findRole(name) != null) {
            Reporter.warn("Role already exists: " + name);
            NotifyUtil.showError(Utils.getString("WARN_RoleAlreadyExists") + ": " + name, Utils.getString("SecurityRoleMapping"));
            return;
        }
        Role role = new Role(name, description);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
        node.setAllowsChildren(true);
        int index = this.getRoleInsertionIndex(role);
        this.data.insertElementAt(role, index);
        this.treeModel.insertNodeInto(node, this.root, index);
        Object[] nodes = this.treeModel.getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        this.tree.scrollPathToVisible(path);
    }

    void remove() {
        DefaultMutableTreeNode sel = this.getSelection();
        if (sel == null) {
            return;
        }
        if (this.isRole(sel)) {
            this.removeRole(sel);
        } else if (this.isLDAPUser(sel)) {
            this.removeLDAPUser(sel);
        } else {
            Reporter.error("Internal Error:  Selected node is neither role or LDAPUser.");
        }
    }

    boolean isRoleSelected() {
        DefaultMutableTreeNode node = this.getSelection();
        if (node == null) {
            return false;
        }
        return this.isRole(node);
    }

    boolean isLDAPUserSelected() {
        DefaultMutableTreeNode node = this.getSelection();
        if (node == null) {
            return false;
        }
        return this.isLDAPUser(node);
    }

    void addUsers(String[] users) {
        Reporter.assertIt(users);
        Reporter.assertIt(users.length > 0);
        for (int i = 0; i < users.length; ++i) {
            String s = users[i];
            this.addUser(s);
        }
    }

    void addGroups(String[] groups) {
        Reporter.assertIt(groups);
        Reporter.assertIt(groups.length > 0);
        for (int i = 0; i < groups.length; ++i) {
            String s = groups[i];
            this.addGroup(s);
        }
    }

    void addUser(String user) {
        Reporter.assertIt(user);
        this.addUserOrGroup(user, true);
    }

    void addGroup(String group) {
        Reporter.assertIt(group);
        this.addUserOrGroup(group, false);
    }

    private void removeRole(DefaultMutableTreeNode sel) {
        String name = (String)sel.getUserObject();
        Role role = this.findRole(name);
        if (role == null) {
            Reporter.error("Corrupt Data -- can't find the selected role (" + name + ") in the data model.");
            return;
        }
        this.data.removeElement(role);
        this.treeModel.removeNodeFromParent(sel);
    }

    private void removeLDAPUser(DefaultMutableTreeNode sel) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)sel.getParent();
        if (parent == null) {
            Reporter.error("Internal Error:  Selected LDAPUser-node has no parent node");
            return;
        }
        String parentName = (String)parent.getUserObject();
        Role role = this.findRole(parentName);
        if (role == null) {
            Reporter.error("Corrupt Data -- can't find the selected LDAPUser's Role (" + parentName + ") in the data model.");
            return;
        }
        String LDAPUserName = (String)sel.getUserObject();
        if (LDAPUserName.startsWith(userPrepend)) {
            LDAPUserName = LDAPUserName.substring(userPrepend.length());
            this.removeUser(role, LDAPUserName);
        } else if (LDAPUserName.startsWith(groupPrepend)) {
            LDAPUserName = LDAPUserName.substring(groupPrepend.length());
            this.removeGroup(role, LDAPUserName);
        } else {
            Reporter.critical("Bad user or group name stored in Tree Model");
        }
        this.treeModel.removeNodeFromParent(sel);
    }

    private void removeUser(Role role, String name) {
        Vector users = role.getUsers();
        int index = users.indexOf(name);
        if (index < 0) {
            Reporter.error("Couldn't find the User: " + name + " in the role: " + role.getName());
            return;
        }
        users.removeElementAt(index);
    }

    private void removeGroup(Role role, String name) {
        Vector groups = role.getGroups();
        int index = groups.indexOf(name);
        if (index < 0) {
            Reporter.error("Couldn't find the Group: " + name + " in the role: " + role.getName());
            return;
        }
        groups.removeElementAt(index);
    }

    private void addUserOrGroup(String name, boolean user) {
        Reporter.assertIt(name);
        String prepend = null;
        DefaultMutableTreeNode sel = this.getSelection();
        prepend = user ? userPrepend : groupPrepend;
        if (sel == null) {
            return;
        }
        if (!this.isRole(sel)) {
            return;
        }
        String roleName = (String)sel.getUserObject();
        Role role = this.findRole(roleName);
        if (role == null) {
            Reporter.error("Corrupt Data -- can't find the selected role (" + roleName + ") in the data model.");
            return;
        }
        if (user && role.hasUser(name)) {
            this.messageAlreadyExists(name);
            return;
        }
        if (!user && role.hasGroup(name)) {
            this.messageAlreadyExists(name);
            return;
        }
        int index = sel.getChildCount();
        if (user) {
            role.addUser(name);
        } else {
            role.addGroup(name);
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(prepend + name);
        node.setAllowsChildren(false);
        this.treeModel.insertNodeInto(node, sel, index);
        Object[] nodes = this.treeModel.getPathToRoot(node);
        TreePath path = new TreePath(nodes);
        this.tree.scrollPathToVisible(path);
    }

    private Role findRole(String name) {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    protected synchronized void initTreeData() {
        this.root = new DefaultMutableTreeNode(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$ejb$security$RoleTree == null ? (class$com$iplanet$ias$tools$forte$ejb$security$RoleTree = RoleTree.class$("com.iplanet.ias.tools.forte.ejb.security.RoleTree")) : class$com$iplanet$ias$tools$forte$ejb$security$RoleTree), (String)"LBL_RoleMapping"));
        this.treeModel = new DefaultTreeModel(this.root);
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            this.addRole(role);
        }
    }

    protected synchronized void updateData() {
        int numKids = this.treeModel.getChildCount(this.root);
        for (int i = 0; i < numKids; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeModel.getChild(this.root, 0);
            if (node == null) continue;
            this.treeModel.removeNodeFromParent(node);
        }
        Reporter.verbose("Removed all of Root's children");
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            this.addRole(role);
        }
        this.treeModel.reload();
    }

    private void addRole(Role role) {
        DefaultMutableTreeNode roleNode = new DefaultMutableTreeNode(role.getName());
        roleNode.setAllowsChildren(true);
        this.root.add(roleNode);
        Enumeration e = role.getUsersEnum();
        while (e.hasMoreElements()) {
            String user = (String)e.nextElement();
            DefaultMutableTreeNode roleUser = new DefaultMutableTreeNode(userPrepend + user);
            roleUser.setAllowsChildren(false);
            roleNode.add(roleUser);
        }
        e = role.getGroupsEnum();
        while (e.hasMoreElements()) {
            String group = (String)e.nextElement();
            DefaultMutableTreeNode roleGroup = new DefaultMutableTreeNode(groupPrepend + group);
            roleGroup.setAllowsChildren(false);
            roleNode.add(roleGroup);
        }
    }

    private DefaultMutableTreeNode getSelection() {
        DefaultMutableTreeNode sel = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (sel == null) {
            return null;
        }
        if (sel == this.root) {
            return null;
        }
        return sel;
    }

    private boolean isRole(DefaultMutableTreeNode node) {
        return node.getAllowsChildren();
    }

    private boolean isLDAPUser(DefaultMutableTreeNode node) {
        return !node.getAllowsChildren();
    }

    private int getRoleInsertionIndex(Role newRole) {
        int i = 0;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            if (newRole.compareTo(role) < 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void messageAlreadyExists(String name) {
        NotifyUtil.showError(Utils.getString("WARN_RoleAlreadyContains") + " " + name, Utils.getString("SecurityRoleMapping"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

