/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.dd.SecurityRoleMapping;
import com.iplanet.ias.tools.common.dd.application.SunApplication;
import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.iplanet.ias.tools.common.dd.webapp.SunWebApp;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;

public class RoleMappingDataHolder {
    private SunEjbJar ejbJar = null;
    private SunWebApp webApp = null;
    private Vector roleNames = null;
    private WebAppDescriptorHacker webH = null;
    private WebStandardData.WebDDData roleSource = null;
    private SunApplication iasApplication = null;

    public RoleMappingDataHolder(SunEjbJar ej, Vector roleNames) {
        Reporter.assertIt((Object)ej);
        Reporter.assertIt(roleNames);
        this.ejbJar = ej;
        this.iasApplication = null;
        this.webApp = null;
        this.roleNames = roleNames;
    }

    public RoleMappingDataHolder(SunApplication iasApplication, Vector roleNames) {
        Reporter.assertIt((Object)iasApplication);
        Reporter.assertIt(roleNames);
        this.ejbJar = null;
        this.iasApplication = iasApplication;
        this.webApp = null;
        this.roleNames = roleNames;
    }

    public RoleMappingDataHolder(SunWebApp iasWebApp, Vector roleNames) {
        Reporter.assertIt((Object)iasWebApp);
        Reporter.assertIt(roleNames);
        this.ejbJar = null;
        this.iasApplication = null;
        this.webApp = iasWebApp;
        this.roleNames = roleNames;
    }

    public Enumeration getRoleNames() {
        if (null != this.roleNames) {
            Reporter.assertIt(this.roleNames);
            return this.roleNames.elements();
        }
        if (null != this.roleSource) {
            Vector<String> tmp = new Vector<String>();
            WebStandardData.SecurityRoleData[] roles = this.roleSource.getSecurityRoles();
            for (int i = 0; null != roles && i < roles.length; ++i) {
                tmp.add(roles[i].getRoleName());
            }
            return tmp.elements();
        }
        return this.webH.getRoleNames();
    }

    public void setRoleNames(Vector v) {
        if (null != this.roleNames || null != this.roleSource) {
            return;
        }
        this.webH.setRoleNames(v);
    }

    public void setSecurityRoleMapping(SecurityRoleMapping[] rms) {
        if (this.isEJB()) {
            this.ejbJar.setSecurityRoleMapping(rms);
        } else if (this.isApp()) {
            this.iasApplication.setSecurityRoleMapping(rms);
        } else if (this.isWebApp()) {
            this.webApp.setSecurityRoleMapping(rms);
        } else {
            this.webH.setSecurityRoleMapping(rms);
        }
    }

    public SecurityRoleMapping[] getSecurityRoleMapping() {
        if (this.isEJB()) {
            return this.ejbJar.getSecurityRoleMapping();
        }
        if (this.isApp()) {
            return this.iasApplication.getSecurityRoleMapping();
        }
        if (this.isWebApp()) {
            return this.webApp.getSecurityRoleMapping();
        }
        return this.webH.getSecurityRoleMapping();
    }

    public Object getRealObject() {
        if (this.isEJB()) {
            return this.ejbJar;
        }
        if (this.isApp()) {
            return this.iasApplication;
        }
        Reporter.assertIt(this.isWebApp(), "InValidObject");
        return this.webApp;
    }

    public boolean isEJB() {
        return this.ejbJar != null;
    }

    public boolean isApp() {
        return this.iasApplication != null;
    }

    public boolean isWebApp() {
        return this.webApp != null;
    }

    public boolean isWeb() {
        return !this.isEJB();
    }

    public int getNumSecurityRoles() {
        SecurityRoleMapping[] foo2 = null;
        if (this.isEJB()) {
            foo2 = this.ejbJar.getSecurityRoleMapping();
        }
        if (this.isApp()) {
            foo2 = this.iasApplication.getSecurityRoleMapping();
        }
        if (this.isWebApp()) {
            foo2 = this.webApp.getSecurityRoleMapping();
        }
        if (null != this.webH) {
            foo2 = this.webH.getSecurityRoleMapping();
        }
        if (null == foo2) {
            return 0;
        }
        return foo2.length;
    }

    static class WebAppDescriptorHacker {
        WebAppDescriptorHacker() {
        }

        public SecurityRoleMapping[] getSecurityRoleMapping() {
            ArrayList rms = new ArrayList();
            SecurityRoleMapping[] final_rms = new SecurityRoleMapping[rms.size()];
            return rms.toArray(final_rms);
        }

        public void setSecurityRoleMapping(SecurityRoleMapping[] rms) {
            if (rms == null || rms.length == 0) {
                return;
            }
            for (int i = 0; i < rms.length; ++i) {
                SecurityRoleMapping rm = rms[i];
                String name = rm.getRoleName();
                String[] users = rm.getPrincipalName();
                String[] groups = rm.getGroupName();
                Reporter.info("Name = " + name + ", Num Users = " + users.length + ", Num Groups = " + groups.length);
                if (users != null) {
                    for (int j = 0; j < users.length; ++j) {
                    }
                }
                if (groups == null) continue;
                for (int k = 0; k < groups.length; ++k) {
                }
            }
        }

        public void setRoleNames(Vector v) {
            if (v == null) {
                return;
            }
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
            }
        }

        public Enumeration getRoleNames() {
            return null;
        }
    }
}

