/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.security.LDAPList;
import com.iplanet.ias.tools.forte.ejb.security.RoleMapperModel;
import com.iplanet.ias.tools.forte.ejb.security.RoleTree;
import com.iplanet.ias.tools.forte.ejb.security.Utils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;

public class RoleMapperView
extends JPanel
implements EnhancedCustomPropertyEditor,
ActionListener,
TreeSelectionListener,
ListSelectionListener {
    static final ResourceBundle bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.HelpIDBundle");
    boolean invalidNewName = true;
    private RoleTree roleTree;
    private LDAPList userList;
    private LDAPList groupList;
    private JButton addRoleButton;
    private JButton deleteRoleButton;
    private JButton addUserButton;
    private JButton deleteUserButton;
    private JButton addGroupButton;
    private JButton deleteGroupButton;
    private JButton addUserToRoleButton;
    private JButton addGroupToRoleButton;
    private JLabel userLabel;
    private JLabel groupLabel;
    private JLabel roleMappingLabel;
    private RoleMapperModel model;
    private boolean bAllowRoleNameManagement = false;
    private static final boolean bAllowRoleNameManagementDefault = false;

    public RoleMapperView(RoleMapperModel m) {
        this(m, false);
        HelpCtx.setHelpIDString((JComponent)this, (String)bundle.getString("map_security_roles"));
    }

    public RoleMapperView(RoleMapperModel m, boolean allowRoleManagement) {
        this.bAllowRoleNameManagement = allowRoleManagement;
        this.setModel(m);
        this.createWidgets();
        this.layoutWidgets();
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.model.saveData();
    }

    public void valueChanged(TreeSelectionEvent event) {
        this.enableButtons();
    }

    public void valueChanged(ListSelectionEvent event) {
        this.enableButtons();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addUserButton) {
            this.addUser();
        } else if (source == this.addGroupButton) {
            this.addGroup();
        } else if (this.allowRoleNameManagement() && source == this.addRoleButton) {
            this.addRole();
        } else if (source == this.deleteUserButton) {
            this.deleteUser();
        } else if (source == this.deleteGroupButton) {
            this.deleteGroup();
        } else if (source == this.deleteRoleButton) {
            this.deleteRole();
        } else if (source == this.addUserToRoleButton) {
            this.addUserToRole();
        } else if (source == this.addGroupToRoleButton) {
            this.addGroupToRole();
        }
        this.enableButtons();
    }

    RoleTree getRoleTree() {
        return this.roleTree;
    }

    JTree getRoleJTree() {
        return this.roleTree.getJTree();
    }

    private void enableButtons() {
        boolean userSelected = this.userList.hasSelections();
        boolean groupSelected = this.groupList.hasSelections();
        boolean roleSelected = this.roleTree.isRoleSelected();
        boolean LDAPUserSelected = this.roleTree.isLDAPUserSelected();
        if (this.allowRoleNameManagement() && roleSelected || LDAPUserSelected) {
            this.deleteRoleButton.setEnabled(true);
        } else {
            this.deleteRoleButton.setEnabled(false);
        }
        if (userSelected && roleSelected) {
            this.addUserToRoleButton.setEnabled(true);
        } else {
            this.addUserToRoleButton.setEnabled(false);
        }
        if (groupSelected && roleSelected) {
            this.addGroupToRoleButton.setEnabled(true);
        } else {
            this.addGroupToRoleButton.setEnabled(false);
        }
        if (userSelected) {
            this.deleteUserButton.setEnabled(true);
        } else {
            this.deleteUserButton.setEnabled(false);
        }
        if (groupSelected) {
            this.deleteGroupButton.setEnabled(true);
        } else {
            this.deleteGroupButton.setEnabled(false);
        }
    }

    private void addUser() {
        String s = this.getStringFromUser(Utils.getString("PromptForUserName"), bundle.getString("map_security_role_add_principal"));
        if (s == null || s.length() <= 0) {
            return;
        }
        Reporter.verbose("new user: " + s);
        this.userList.add(s);
    }

    private void addGroup() {
        String s = this.getStringFromUser(Utils.getString("PromptForGroupName"), bundle.getString("map_security_role_add_group"));
        if (s == null || s.length() <= 0) {
            return;
        }
        Reporter.verbose("new group: " + s);
        this.groupList.add(s);
    }

    private void addRole() {
        this.addRoleInfo();
    }

    private void deleteUser() {
        this.userList.remove();
    }

    private void deleteGroup() {
        this.groupList.remove();
    }

    private void deleteRole() {
        this.roleTree.remove();
    }

    private void addUserToRole() {
        String[] users = this.userList.getSelections();
        if (users == null || users.length <= 0) {
            return;
        }
        this.roleTree.addUsers(users);
    }

    private void addGroupToRole() {
        String[] groups = this.groupList.getSelections();
        if (groups == null || groups.length <= 0) {
            return;
        }
        this.roleTree.addGroups(groups);
    }

    private void setModel(RoleMapperModel m) {
        this.model = m;
        Reporter.assertIt(this.model);
    }

    private void createWidgets() {
        if (this.allowRoleNameManagement()) {
            this.addRoleButton = new JButton(Utils.getString("BUTTON_AddRole"));
            this.addRoleButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_AddRole"));
        } else {
            this.addRoleButton = null;
        }
        this.deleteRoleButton = new JButton(Utils.getString("BUTTON_Remove"));
        this.deleteRoleButton.setMnemonic(Utils.getString("BUTTON_Remove_Mnemonic").charAt(0));
        this.deleteRoleButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_Remove"));
        this.addUserButton = new JButton(Utils.getString("BUTTON_AddUser"));
        this.addUserButton.setMnemonic(Utils.getString("BUTTON_AddUser_Mnemonic").charAt(0));
        this.addUserButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_AddUser"));
        this.deleteUserButton = new JButton(Utils.getString("BUTTON_DeleteUser"));
        this.deleteUserButton.setMnemonic(Utils.getString("BUTTON_DeleteUser_Mnemonic").charAt(0));
        this.deleteUserButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_DeleteUser"));
        this.addGroupButton = new JButton(Utils.getString("BUTTON_AddGroup"));
        this.addGroupButton.setMnemonic(Utils.getString("BUTTON_AddGroup_Mnemonic").charAt(0));
        this.addGroupButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_AddGroup"));
        this.deleteGroupButton = new JButton(Utils.getString("BUTTON_DeleteGroup"));
        this.deleteGroupButton.setMnemonic(Utils.getString("BUTTON_DeleteGroup_Mnemonic").charAt(0));
        this.deleteGroupButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_DeleteGroup"));
        this.addUserToRoleButton = new JButton(Utils.getString("BUTTON_AddUserToRole"));
        this.addUserToRoleButton.setMnemonic(Utils.getString("BUTTON_AddUserToRole_Mnemonic").charAt(0));
        this.addUserToRoleButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_AddUserToRole"));
        this.addGroupToRoleButton = new JButton(Utils.getString("BUTTON_AddGroupToRole"));
        this.addGroupToRoleButton.setMnemonic(Utils.getString("BUTTON_AddGroupToRole_Mnemonic").charAt(0));
        this.addGroupToRoleButton.getAccessibleContext().setAccessibleDescription(Utils.getString("BUTTON_AddGroupToRole"));
        this.userLabel = new JLabel(Utils.getString("LABEL_Users"));
        this.userLabel.setLabelFor(this.userList);
        this.userLabel.setDisplayedMnemonic(Utils.getString("LABEL_Users_Mnemonic").charAt(0));
        this.userLabel.getAccessibleContext().setAccessibleDescription(Utils.getString("LABEL_Users"));
        this.groupLabel = new JLabel(Utils.getString("LABEL_Groups"));
        this.groupLabel.setLabelFor(this.groupList);
        this.groupLabel.setDisplayedMnemonic(Utils.getString("LABEL_Groups_Mnemonic").charAt(0));
        this.groupLabel.getAccessibleContext().setAccessibleDescription(Utils.getString("LABEL_Groups"));
        this.roleMappingLabel = new JLabel(Utils.getString("LABEL_RoleMappings"));
        this.roleMappingLabel.setDisplayedMnemonic(Utils.getString("LABEL_RoleMappings_Mnemonic").charAt(0));
        this.roleMappingLabel.getAccessibleContext().setAccessibleDescription(Utils.getString("LABEL_RoleMappings"));
        this.userList = new LDAPList(this.model.getUsers());
        this.groupList = new LDAPList(this.model.getGroups());
        this.roleTree = new RoleTree(this.model.getRoles());
        this.userList.addListSelectionListener(this);
        this.groupList.addListSelectionListener(this);
        this.roleTree.getJTree().addTreeSelectionListener(this);
        this.addUserToRoleButton.setEnabled(false);
        this.addGroupToRoleButton.setEnabled(false);
        this.deleteRoleButton.setEnabled(false);
        this.addUserButton.addActionListener(this);
        this.addGroupButton.addActionListener(this);
        this.deleteUserButton.addActionListener(this);
        this.deleteGroupButton.addActionListener(this);
        this.deleteRoleButton.addActionListener(this);
        this.addUserToRoleButton.addActionListener(this);
        this.addGroupToRoleButton.addActionListener(this);
        if (this.allowRoleNameManagement()) {
            this.addRoleButton.addActionListener(this);
        }
    }

    private void layoutWidgets() {
        boolean both = true;
        boolean none = false;
        int hori = 2;
        int vert = 3;
        int resize = 100;
        boolean nosize = false;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        this.add(this.roleMappingLabel, gbc, 1, 0, 0, 0, 0, 4, 1);
        this.add(this.roleTree.getScrollPane(), gbc, 1, 100, 100, 0, 1, 4, 19);
        if (this.allowRoleNameManagement()) {
            this.add(this.addRoleButton, gbc, 1, 0, 0, 0, 20, 2, 1);
        }
        this.add(this.deleteRoleButton, gbc, 1, 0, 0, 2, 20, 2, 1);
        this.add(this.addUserToRoleButton, gbc, 0, 100, 0, 4, 3, 1, 1);
        this.add(this.addGroupToRoleButton, gbc, 0, 100, 0, 4, 14, 1, 1);
        this.add(this.userLabel, gbc, 1, 0, 0, 5, 0, 2, 1);
        this.add(this.userList.getScrollPane(), gbc, 1, 100, 100, 5, 1, 2, 8);
        this.add(this.addUserButton, gbc, 1, 0, 0, 5, 9, 1, 1);
        this.add(this.deleteUserButton, gbc, 1, 0, 0, 6, 9, 1, 1);
        this.add(this.groupLabel, gbc, 1, 0, 0, 5, 11, 2, 1);
        this.add(this.groupList.getScrollPane(), gbc, 1, 100, 100, 5, 12, 2, 8);
        this.add(this.addGroupButton, gbc, 1, 0, 0, 5, 20, 1, 1);
        this.add(this.deleteGroupButton, gbc, 1, 0, 0, 6, 20, 1, 1);
        this.getAccessibleContext().setAccessibleName(Utils.getString("TTL_SecurityRolePropertySupport"));
        this.getAccessibleContext().setAccessibleDescription(Utils.getString("DESC_SecurityRolePropertySupport"));
    }

    private void add(Component c, GridBagConstraints gbc, int fill, int weightx, int weighty, int x, int y, int w, int h) {
        gbc.fill = fill;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        this.add(c, gbc);
    }

    private String getStringFromUser(String prompt, String helpID) {
        JOptionPane jop = new JOptionPane(prompt, 3, 2);
        JDialog d = jop.createDialog(this, Utils.getString("TTL_GET_INPUT"));
        d.getAccessibleContext().setAccessibleDescription(Utils.getString("DESC_SecurityRolePropertySupport"));
        HelpCtx.setHelpIDString((JComponent)jop, (String)helpID);
        jop.setWantsInput(true);
        d.pack();
        d.show();
        Object val = jop.getInputValue();
        if (null == val) {
            return null;
        }
        if (val == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        if (!(val instanceof String)) {
            Reporter.info("This is a strange val: " + val);
            return null;
        }
        String s = (String)val;
        if (s == null || s.length() <= 0) {
            return null;
        }
        return s;
    }

    private boolean allowRoleNameManagement() {
        return this.bAllowRoleNameManagement;
    }

    private void addRoleInfo() {
        this.invalidNewName = true;
        String title = new String(Utils.getString("ESR_Text_EnterRoleName"));
        JLabel nameLbl = new JLabel(new String(Utils.getString("CTL_nameLabel")));
        final JTextField nameTxt = new JTextField(40);
        nameLbl.setLabelFor(nameTxt);
        nameLbl.setDisplayedMnemonic(Utils.getString("LBL_Name_Mnemonic").charAt(0));
        JLabel descLbl = new JLabel(new String(Utils.getString("EEO_Label_Description")));
        final JTextArea descTxt = new JTextArea(3, 40);
        descLbl.setLabelFor(descTxt);
        descLbl.setDisplayedMnemonic(Utils.getString("EEO_Label_Description_Mnemonic").charAt(0));
        descTxt.setLineWrap(true);
        descTxt.setWrapStyleWord(true);
        JScrollPane descArea = new JScrollPane(descTxt);
        descArea.setVerticalScrollBarPolicy(20);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gridbag);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 6, 1, 1);
        c.weightx = 0.0;
        gridbag.setConstraints(nameLbl, c);
        panel.add(nameLbl);
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(12, 1, 1, 1);
        c.weightx = 1.0;
        gridbag.setConstraints(nameTxt, c);
        panel.add(nameTxt);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 6, 1, 1);
        c.weightx = 0.0;
        gridbag.setConstraints(descLbl, c);
        panel.add(descLbl);
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.insets = new Insets(3, 1, 0, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(descArea, c);
        panel.add(descArea);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newRoleName = nameTxt.getText().trim();
                if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                    if (newRoleName == null || newRoleName.length() <= 0) {
                        RoleMapperView.this.invalidNewName = true;
                    } else {
                        Reporter.verbose("new role: " + newRoleName);
                        RoleMapperView.this.roleTree.addRole(newRoleName, descTxt.getText());
                        RoleMapperView.this.invalidNewName = false;
                    }
                } else {
                    RoleMapperView.this.invalidNewName = false;
                }
            }
        });
        Dialog d = TopManager.getDefault().createDialog(dd);
        this.invalidNewName = true;
        while (this.invalidNewName) {
            d.show();
        }
    }
}

