/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.Sorter;
import com.iplanet.ias.tools.common.dd.SecurityRoleMapping;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.security.LDAP;
import com.iplanet.ias.tools.forte.ejb.security.LDAPImpl;
import com.iplanet.ias.tools.forte.ejb.security.Role;
import com.iplanet.ias.tools.forte.ejb.security.RoleMappingDataHolder;
import java.util.Enumeration;
import java.util.Vector;

public class RoleMapperModel {
    private Vector users = new Vector();
    private Vector groups = new Vector();
    private Vector roles = new Vector();
    private LDAP ldap = new LDAPImpl();
    private Enumeration ffjSecRoles = null;
    private RoleMappingDataHolder data = null;

    public RoleMapperModel(RoleMappingDataHolder data) {
        Reporter.assertIt(data);
        this.data = data;
        this.setFFJSecRoles(data.getRoleNames());
        this.fetchData();
    }

    public Vector getRoles() {
        return this.roles;
    }

    public Vector getUsers() {
        return this.users;
    }

    public Vector getGroups() {
        return this.groups;
    }

    public Object saveData() {
        Reporter.info("saving role-mapping information");
        this.saveUsers();
        this.saveGroups();
        this.saveRoles();
        this.getLDAP().save();
        return this.data.getRealObject();
    }

    public boolean hasMapping(String name) {
        Role role = this.getRole(name);
        if (role == null) {
            Reporter.warn("Internal Error in RoleMapperModel.hasMapping(): \"" + name + "\" isn't even a registered role!");
            return false;
        }
        return role.hasMapping();
    }

    protected void setFFJSecRoles(Enumeration e) {
        Reporter.assertIt(e);
        this.ffjSecRoles = e;
    }

    protected LDAP getLDAP() {
        return this.ldap;
    }

    private void saveUsers() {
        this.getLDAP().setUsers(this.users);
    }

    private void saveGroups() {
        this.getLDAP().setGroups(this.groups);
    }

    private void saveRoles() {
        Vector<SecurityRoleMapping> rms = new Vector<SecurityRoleMapping>();
        Vector<String> roleNames = new Vector<String>();
        Enumeration e = this.roles.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            String name = role.getName();
            roleNames.addElement(name);
            if (!role.hasMapping()) continue;
            SecurityRoleMapping rm = new SecurityRoleMapping();
            if (role.hasUsers()) {
                rm.setPrincipalName(this.vecToStrings(role.getUsers()));
            }
            if (role.hasGroups()) {
                rm.setGroupName(this.vecToStrings(role.getGroups()));
            }
            rm.setRoleName(name);
            rms.addElement(rm);
        }
        if (rms.size() <= 0) {
            this.data.setRoleNames(null);
            this.data.setSecurityRoleMapping(null);
            return;
        }
        SecurityRoleMapping[] final_rms = new SecurityRoleMapping[rms.size()];
        final_rms = rms.toArray(final_rms);
        this.data.setSecurityRoleMapping(final_rms);
        this.data.setRoleNames(roleNames);
    }

    private void fetchData() {
        Reporter.assertIt(this.ffjSecRoles);
        Reporter.info("fetching role-mapping information");
        this.fetchUsers();
        this.fetchGroups();
        this.fetchRoles();
        Sorter.sort(this.users);
        Sorter.sort(this.groups);
        Sorter.sort(this.roles);
        Enumeration e = this.roles.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            Sorter.sort(role.getUsers());
            Sorter.sort(role.getGroups());
        }
    }

    private void fetchGroups() {
        Reporter.assertIt(this.getLDAP());
        Reporter.assertIt(this.groups);
        Reporter.assertIt(this.groups.size() == 0);
        Vector gs = this.getLDAP().getGroups();
        Enumeration e = gs.elements();
        while (e.hasMoreElements()) {
            String group = (String)e.nextElement();
            if (group == null || group.length() <= 0) continue;
            if (this.groups.indexOf(group) >= 0) {
                Reporter.warn("Duplicate group found and discarded: " + group);
                continue;
            }
            Reporter.verbose("Group Added:  " + group);
            this.groups.addElement(group);
        }
    }

    private void fetchUsers() {
        Reporter.assertIt(this.getLDAP());
        Reporter.assertIt(this.users);
        Reporter.assertIt(this.users.size() == 0);
        Vector us = this.getLDAP().getUsers();
        Enumeration e = us.elements();
        while (e.hasMoreElements()) {
            String user = (String)e.nextElement();
            if (user == null || user.length() <= 0) continue;
            if (this.users.indexOf(user) >= 0) {
                Reporter.warn("Duplicate user found and discarded: " + user);
                continue;
            }
            Reporter.verbose("User Added:  " + user);
            this.users.addElement(user);
        }
    }

    private void fetchRoles() {
        Reporter.assertIt(this.ffjSecRoles);
        Reporter.assertIt(this.roles);
        Reporter.assertIt(this.roles.size() == 0);
        if (!this.ffjSecRoles.hasMoreElements()) {
            Reporter.info("NO ROLES FOUND!!!");
        }
        Enumeration e = this.ffjSecRoles;
        while (e.hasMoreElements()) {
            String roleName = (String)e.nextElement();
            Role newRole = new Role(roleName, "");
            if (this.roleExists(newRole)) {
                Reporter.error("Bad properties.  Found the same rolename twice: " + roleName);
                continue;
            }
            this.roles.addElement(newRole);
            Reporter.verbose("Role Added to RoleMapperModel: " + roleName);
            this.fetchRoleMembers(newRole);
        }
    }

    private void fetchRoleMembers(Role role) {
        SecurityRoleMapping[] rms = this.data.getSecurityRoleMapping();
        if (rms == null || rms.length <= 0) {
            return;
        }
        for (int i = 0; i < rms.length; ++i) {
            SecurityRoleMapping rm = rms[i];
            Reporter.assertIt((Object)rm);
            if (!rm.getRoleName().equals(role.getName())) continue;
            String[] us = rm.getPrincipalName();
            for (int j = 0; j < us.length; ++j) {
                String user = us[j];
                Reporter.assertIt(user);
                if (role.hasUser(user)) {
                    Reporter.error("Bad properties.  Found the same name twice in the users list: " + user);
                    continue;
                }
                if (!this.isValidUser(user)) {
                    Reporter.warn("Bad properties.  The role (" + role.getName() + ") has a non-existing User (" + user + ").  Added it to the global list of Users.");
                    this.users.add(user);
                }
                Reporter.verbose("Role: " + role.getName() + ", User Added:  " + user);
                role.addUser(user);
            }
            String[] gs = rm.getGroupName();
            for (int j = 0; j < gs.length; ++j) {
                String group = gs[j];
                Reporter.assertIt(group);
                if (role.hasGroup(group)) {
                    Reporter.error("Bad properties.  Found the same name twice in the groups list: " + group);
                    continue;
                }
                if (!this.isValidGroup(group)) {
                    Reporter.warn("Bad properties.  The role (" + role.getName() + ") has a non-existing Group (" + group + ")  Added it to the global list of Groups.");
                    this.groups.add(group);
                }
                Reporter.verbose("Role: " + role.getName() + ", group added:  " + group);
                role.addGroup(group);
            }
            return;
        }
    }

    private boolean isValidUser(String user) {
        return this.users.indexOf(user) >= 0;
    }

    private boolean isValidGroup(String group) {
        return this.groups.indexOf(group) >= 0;
    }

    private boolean roleExists(Role role) {
        Enumeration e = this.roles.elements();
        while (e.hasMoreElements()) {
            Role other = (Role)e.nextElement();
            if (!other.getName().equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    private Role getRole(String name) {
        Enumeration e = this.roles.elements();
        while (e.hasMoreElements()) {
            Role role = (Role)e.nextElement();
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    private String[] vecToStrings(Vector v) {
        Reporter.assertIt(v != null && v.size() > 0, "Programmer Error -- don't call this method with a null or empty Vector");
        return v.toArray(new String[v.size()]);
    }
}

