/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.security.Utils;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

class LDAPList
extends JList {
    private DefaultListModel model = null;
    private JScrollPane listPane = null;
    private Vector data = null;

    LDAPList(Vector data) {
        super(new DefaultListModel());
        this.data = data;
        this.model = (DefaultListModel)this.getModel();
        this.listPane = new JScrollPane(this);
        this.addData();
    }

    JScrollPane getScrollPane() {
        return this.listPane;
    }

    void add(String s) {
        Reporter.assertIt(s);
        if (this.data.indexOf(s) >= 0) {
            NotifyUtil.showError(Utils.getString("WARN_ListAlreadyContains") + " " + s, Utils.getString("SecurityRoleMapping"));
            return;
        }
        int index = this.getInsertionIndex(s);
        this.model.insertElementAt(s, index);
        this.data.insertElementAt(s, index);
        this.ensureIndexIsVisible(index);
    }

    String[] getSelections() {
        int[] sels = this.getSelectedIndices();
        if (sels == null || sels.length <= 0) {
            return null;
        }
        String[] ret = new String[sels.length];
        for (int i = 0; i < sels.length; ++i) {
            ret[i] = (String)this.model.getElementAt(sels[i]);
        }
        return ret;
    }

    boolean hasSelections() {
        int[] sels = this.getSelectedIndices();
        return sels != null && sels.length > 0;
    }

    void remove() {
        int[] sels = this.getSelectedIndices();
        if (sels == null || sels.length <= 0) {
            return;
        }
        for (int i = sels.length - 1; i >= 0; --i) {
            String s = (String)this.model.getElementAt(sels[i]);
            int vIndex = this.data.indexOf(s);
            if (vIndex >= 0) {
                this.data.removeElementAt(vIndex);
            } else {
                Reporter.error("Couldn't find " + s + " in listbox!!");
            }
            this.model.remove(sels[i]);
        }
    }

    private int getInsertionIndex(String s) {
        int i = 0;
        Enumeration e = this.model.elements();
        while (e.hasMoreElements()) {
            if (s.compareTo((String)e.nextElement()) < 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void addData() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            this.model.addElement((String)e.nextElement());
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setTitle("LDAPList Tester");
        frame.setSize(600, 900);
        Vector<String> v = new Vector<String>();
        v.addElement("One Item Only!!!!");
        LDAPList list = new LDAPList(v);
        frame.setContentPane(list.getScrollPane());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.show();
    }
}

