/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.resourceRefs;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.common.ResRefMap;
import com.iplanet.ias.tools.forte.ejb.resourceRefs.ResRefMapModel;
import com.iplanet.ias.tools.forte.util.BundleHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;

public class ResRefMapPanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final ResourceBundle helpBundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.HelpIDBundle");
    private ResRefMapModel model = null;
    private JLabel refNameLabel;
    private JTextField[] resRefNameLabels;
    private JLabel jndiLabel;
    private JComboBox[] jndiNameFields;
    private String[] resRefNames;
    private int maxRefNameSize = 0;
    private int maxJndiSize = 0;
    private GridBagConstraints gridBagConstraints;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel;

    public ResRefMapPanel(ResRefMapModel m) {
        Reporter.assertIt(m);
        this.model = m;
        this.resRefNames = this.model.getJ2eeRefNames();
        if (this.resRefNames.length == 0) {
            this.add(new JLabel(BundleHelper.getString(class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel == null ? (class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel = ResRefMapPanel.class$("com.iplanet.ias.tools.forte.ejb.resourceRefs.ResRefMapPanel")) : class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel, "No_ResourceRef")));
            this.setVisible(true);
            return;
        }
        this.setLayout(new GridBagLayout());
        this.createResRefNameLabels();
        this.createJndiFields();
        this.getAccessibleContext().setAccessibleName(BundleHelper.getString(class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel == null ? (class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel = ResRefMapPanel.class$("com.iplanet.ias.tools.forte.ejb.resourceRefs.ResRefMapPanel")) : class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel, "TTL_ResourceRefMapPropertySupport"));
        this.getAccessibleContext().setAccessibleDescription(BundleHelper.getString(class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel == null ? (class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel = ResRefMapPanel.class$("com.iplanet.ias.tools.forte.ejb.resourceRefs.ResRefMapPanel")) : class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel, "DESC_ResourceRefMapPropertySupport"));
        HelpCtx.setHelpIDString((JComponent)this, (String)helpBundle.getString("resref_map"));
        this.setFieldsWidth();
        this.setVisible(true);
    }

    public Object getPropertyValue() throws IllegalStateException {
        ResRefMap[] maps = this.model.getMaps();
        for (int i = 0; i < maps.length; ++i) {
            String selected = (String)this.jndiNameFields[i].getSelectedItem();
            Reporter.info("selected = " + selected + ",    " + this.extractResourceName(selected));
            maps[i].setJNDI(this.extractResourceName(selected));
        }
        return this.model.saveData();
    }

    private void createResRefNameLabels() {
        this.refNameLabel = new JLabel(BundleHelper.getString(this, "TTL_J2EEColumn"));
        this.refNameLabel.setBorder(new EmptyBorder(new Insets(1, 1, 10, 1)));
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.anchor = 10;
        this.add((Component)this.refNameLabel, this.gridBagConstraints);
        this.resRefNameLabels = new JTextField[this.resRefNames.length];
        for (int i = 0; i < this.resRefNames.length; ++i) {
            if (this.maxRefNameSize < this.resRefNames[i].length()) {
                this.maxRefNameSize = this.resRefNames[i].length();
            }
            this.resRefNameLabels[i] = new JTextField(this.resRefNames[i]);
            this.resRefNameLabels[i].setBackground(Color.white);
            this.resRefNameLabels[i].setEditable(false);
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.gridx = 0;
            this.gridBagConstraints.anchor = 17;
            this.add((Component)this.resRefNameLabels[i], this.gridBagConstraints);
        }
    }

    private void createJndiFields() {
        this.jndiLabel = new JLabel(BundleHelper.getString(this, "TTL_JNDIColumn"));
        this.jndiLabel.setBorder(new EmptyBorder(new Insets(1, 1, 10, 1)));
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.anchor = 10;
        this.add((Component)this.jndiLabel, this.gridBagConstraints);
        Vector[] resTags = this.model.getResourceTags();
        ResRefMap[] maps = this.model.getMaps();
        this.jndiNameFields = new JComboBox[this.resRefNames.length];
        for (int i = 0; i < this.resRefNames.length; ++i) {
            String jndi = maps[i].getJNDI();
            Vector tags = resTags[i];
            tags = tags == null ? new Vector() : (Vector)tags.clone();
            String selected = null;
            if (jndi == null || jndi.length() == 0) {
                jndi = "";
            }
            if (jndi != null && jndi.length() > 0) {
                selected = this.matchResource(tags, jndi);
            }
            if (selected == null) {
                tags.addElement(jndi);
                selected = jndi;
            }
            this.jndiNameFields[i] = new JComboBox<Object>(tags.toArray());
            this.jndiNameFields[i].setSelectedItem(selected);
            if (selected != null && this.maxJndiSize < selected.length()) {
                this.maxJndiSize = selected.length();
            }
            this.jndiNameFields[i].getAccessibleContext().setAccessibleName(BundleHelper.getString(class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel == null ? ResRefMapPanel.class$("com.iplanet.ias.tools.forte.ejb.resourceRefs.ResRefMapPanel") : class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel, "TTL_JNDIColumn") + i);
            this.jndiNameFields[i].getAccessibleContext().setAccessibleDescription(BundleHelper.getString(class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel == null ? ResRefMapPanel.class$("com.iplanet.ias.tools.forte.ejb.resourceRefs.ResRefMapPanel") : class$com$iplanet$ias$tools$forte$ejb$resourceRefs$ResRefMapPanel, "TTL_JNDIColumn") + i);
            this.jndiNameFields[i].setEditable(true);
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.gridx = 1;
            this.gridBagConstraints.anchor = 17;
            this.add((Component)this.jndiNameFields[i], this.gridBagConstraints);
        }
    }

    public String matchResource(Vector tags, String resource) {
        for (int i = 0; i < tags.size(); ++i) {
            String element = (String)tags.elementAt(i);
            Reporter.info(resource + "    " + this.extractResourceName(element));
            if (!this.extractResourceName(element).equals(resource)) continue;
            return element;
        }
        return null;
    }

    public String extractResourceName(String str) {
        if (str == null) {
            return "";
        }
        int offset = str.indexOf(40);
        if (offset >= 0) {
            return str.substring(0, offset);
        }
        return str;
    }

    public void setFieldsWidth() {
        Reporter.info(this.maxRefNameSize + "   " + this.maxJndiSize);
        this.maxRefNameSize *= 6;
        this.maxJndiSize *= 6;
        if (this.maxRefNameSize < 150) {
            this.maxRefNameSize = 150;
        }
        if (this.maxJndiSize < 250) {
            this.maxJndiSize = 250;
        }
        for (int i = 0; i < this.resRefNameLabels.length; ++i) {
            this.resRefNameLabels[i].setPreferredSize(new Dimension(this.maxRefNameSize, 26));
            this.jndiNameFields[i].setPreferredSize(new Dimension(this.maxJndiSize, 26));
        }
        this.setPreferredSize(new Dimension(this.maxRefNameSize + this.maxJndiSize + 50, 26 * this.resRefNameLabels.length + 100));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

