/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.cmp.transform;

import archiver.XMLOutputStream;
import com.iplanet.ias.tools.common.dd.cmpmapping.CmpFieldMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.CmrFieldMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.ColumnPair;
import com.iplanet.ias.tools.common.dd.cmpmapping.Consistency;
import com.iplanet.ias.tools.common.dd.cmpmapping.EntityMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.FetchedWith;
import com.iplanet.ias.tools.common.dd.cmpmapping.HasFetchedWith;
import com.iplanet.ias.tools.common.dd.cmpmapping.SecondaryTable;
import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMapping;
import com.iplanet.ias.tools.common.dd.cmpmapping.SunCmpMappings;
import com.iplanet.ias.tools.forte.ejb.cmp.transform.ConversionHelper;
import com.iplanet.ias.tools.forte.ejb.cmp.transform.EjbJarConversionHelper;
import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceClassElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceFieldElementImpl;
import com.sun.jdo.api.persistence.model.jdo.impl.RelationshipElementImpl;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingRelationshipElementImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class MappingFile {
    private static ResourceBundle bundle = null;
    private static final String JAVA_TYPE_SET = "java.util.Set";
    private static final String JAVA_TYPE_COLLECTION = "java.util.Collection";
    private static final List types = new ArrayList();
    public static String DEFAULT_LOCATION_IN_EJB_JAR = null;
    private Map inverseRelationships = null;
    private Map inverseRelationshipIs = null;
    private Map namedGroups = null;
    private int groupCount = -1;
    private ClassLoader classLoader = null;
    private Object[] errorMessageArgs = null;
    private String errorMessageFormat = null;
    private static int CURRENT_BEAN;
    private static int CURRENT_SCHEMA;
    private static int CURRENT_CLASSPATH;
    private static int CURRENT_TABLE;
    private static int CURRENT_COLUMN;
    private static int CURRENT_FIELD;
    private static int CURRENT_RELATION_FIELD_TYPE;
    private static int CURRENT_FETCH_WITH_LEVEL;
    private static int CURRENT_MAPPING_FILE;
    private static int LAST_INDEX;
    private static int MINIMUM_PRECISION;
    private ConversionHelper helper;
    private HashMap loadedSchema = new HashMap();

    public MappingFile() {
        this.errorMessageArgs = new Object[LAST_INDEX];
    }

    public MappingFile(ClassLoader cl) {
        this();
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public Map intoMappingClasses(SunCmpMappings content, ConversionHelper validator, PrintStream messageStream) {
        try {
            EntityMapping anIasBeanMapping = null;
            this.helper = validator;
            HashMap<String, MappingClassElement> mces = null;
            mces = new HashMap<String, MappingClassElement>();
            int k = 0;
            for (int i = 0; i < content.sizeSunCmpMapping(); ++i) {
                boolean foo2;
                SunCmpMapping beanSet = content.getSunCmpMapping(i);
                this.inverseRelationships = new HashMap();
                this.inverseRelationshipIs = new HashMap();
                this.namedGroups = new HashMap();
                if (validator.ensureCompleteRoles() && (foo2 = this.completeCmrMappings(beanSet, validator)) && null != messageStream) {
                    beanSet.write(messageStream);
                }
                for (k = 0; k < beanSet.sizeEntityMapping(); ++k) {
                    MappingClassElement aTpMapping;
                    block10: {
                        anIasBeanMapping = beanSet.getEntityMapping(k);
                        aTpMapping = null;
                        if (validator.ensureCompleteRoles()) {
                            aTpMapping = this.mapFieldsOfBean(anIasBeanMapping, beanSet.getSchema(), validator, messageStream);
                        } else {
                            try {
                                aTpMapping = this.mapFieldsOfBean(anIasBeanMapping, beanSet.getSchema(), validator, messageStream);
                            }
                            catch (Throwable t) {
                                if (null == messageStream) break block10;
                                t.printStackTrace(messageStream);
                            }
                        }
                    }
                    mces.put(anIasBeanMapping.getEjbName(), aTpMapping);
                }
            }
            return mces;
        }
        catch (Throwable re) {
            if (null != messageStream) {
                re.printStackTrace(messageStream);
            }
            RuntimeException foo3 = new RuntimeException(this.lastError());
            throw foo3;
        }
    }

    public Map intoMappingClasses(InputStream content, ConversionHelper validator, PrintStream messageStream) {
        SunCmpMappings foo2 = null;
        this.errorMessageFormat = bundle.getString("XML_ERROR_IN_MAPPING_FILE");
        this.errorMessageArgs[MappingFile.CURRENT_MAPPING_FILE] = DEFAULT_LOCATION_IN_EJB_JAR;
        try {
            foo2 = SunCmpMappings.createGraph(content);
        }
        catch (Throwable t) {
            if (validator.ensureCompleteRoles()) {
                if (null != messageStream) {
                    t.printStackTrace(messageStream);
                }
                RuntimeException bar = new RuntimeException(this.lastError());
                throw bar;
            }
            foo2 = SunCmpMappings.createGraph();
        }
        return this.intoMappingClasses(foo2, validator, messageStream);
    }

    public void fromMappingClasses(OutputStream dest, Map mappingClasses, PrintStream messageStream) throws IOException {
        SunCmpMappings tmp = this.fromMappingClasses(mappingClasses, messageStream);
        tmp.write(dest);
    }

    public SunCmpMappings fromMappingClasses(Map mappingClasses, PrintStream messageStream) {
        Iterator keyIter = mappingClasses.keySet().iterator();
        HashMap<String, SunCmpMapping> mapOfMapping = new HashMap<String, SunCmpMapping>();
        while (keyIter.hasNext()) {
            String schemaName;
            SunCmpMapping aMapping;
            String ejbName = (String)keyIter.next();
            MappingClassElement mce = (MappingClassElement)mappingClasses.get(ejbName);
            EntityMapping beanMapping = new EntityMapping();
            if (null == mce) continue;
            int consistency = mce.getConsistencyLevel();
            if (0 != consistency) {
                Consistency c = new Consistency();
                if (6 == consistency) {
                    c.setLockWhenModified(true);
                    c.setCheckAllAtCommit(true);
                }
                if (4 == consistency) {
                    c.setLockWhenModified(true);
                }
                if (2 == consistency) {
                    c.setCheckAllAtCommit(true);
                }
                if (8 == consistency) {
                    c.setLockWhenLoaded(true);
                }
                if (1 == consistency) {
                    c.setCheckModifiedAtCommit(true);
                }
                beanMapping.setConsistency(c);
            }
            if (null == (aMapping = (SunCmpMapping)((Object)mapOfMapping.get(schemaName = mce.getDatabaseRoot())))) {
                aMapping = new SunCmpMapping();
                aMapping.setSchema(schemaName);
                mapOfMapping.put(schemaName, aMapping);
            }
            ArrayList tables = mce.getTables();
            MappingTableElement primary = null;
            if (tables.size() > 0) {
                primary = (MappingTableElement)tables.get(0);
                beanMapping.setTableName(primary.getName());
            }
            beanMapping.setEjbName(ejbName);
            if (null != primary) {
                ArrayList refKeys = primary.getReferencingKeys();
                for (int i = 0; refKeys != null && i < refKeys.size(); ++i) {
                    SecondaryTable sT = new SecondaryTable();
                    MappingReferenceKeyElement mrke = (MappingReferenceKeyElement)refKeys.get(i);
                    MappingTableElement mte = mrke.getTable();
                    if (null != mte) {
                        sT.setTableName(mte.getName());
                        ArrayList cpnames = mrke.getColumnPairNames();
                        boolean hasPairs = false;
                        for (int j = 0; cpnames != null && j < cpnames.size(); ++j) {
                            StringTokenizer toker = new StringTokenizer((String)cpnames.get(j), ";");
                            ColumnPair cp = new ColumnPair();
                            while (toker.hasMoreTokens()) {
                                String columnName = toker.nextToken();
                                cp.addColumnName(columnName);
                            }
                            sT.addColumnPair(cp);
                            hasPairs = true;
                        }
                        if (hasPairs) {
                            beanMapping.addSecondaryTable(sT);
                            continue;
                        }
                        MappingFile.writeMessage(messageStream, "WARN_ILLEGAL_PAIR", new Object[]{ejbName, mte.getName(), cpnames});
                        continue;
                    }
                    MappingFile.writeMessage(messageStream, "WARN_MISSING_TABLE", new Object[]{ejbName, primary.getName()});
                }
            } else {
                MappingFile.writeMessage(messageStream, "WARN_NO_PRIMARY", new Object[]{ejbName});
            }
            ArrayList fields = mce.getFields();
            PersistenceClassElement pce = null;
            PersistenceFieldElement[] pfields = null;
            if (mce instanceof MappingClassElementImpl) {
                MappingClassElementImpl mcei = (MappingClassElementImpl)mce;
                pce = mcei.getPersistenceElement();
                pfields = pce.getFields();
            }
            int len = 0;
            if (null != pfields) {
                len = pfields.length;
            }
            for (int i = 0; i < len; ++i) {
                PersistenceFieldElement pfield = pfields[i];
                if (pfield instanceof RelationshipElement) {
                    ColumnPair cp;
                    int slen;
                    String cpstring;
                    int j;
                    MappingRelationshipElement mre;
                    MappingRelationshipElement mfe = mre = (MappingRelationshipElement)mce.getField(pfield.getName());
                    CmrFieldMapping cfm = new CmrFieldMapping();
                    cfm.setCmrFieldName(pfield.getName());
                    ArrayList cols = null;
                    if (null != mfe) {
                        cols = mfe.getColumns();
                        int fgVal = mfe.getFetchGroup();
                        this.setFetchedWith(cfm, fgVal);
                    }
                    for (j = 0; null != cols && j < cols.size(); ++j) {
                        cpstring = (String)cols.get(j);
                        slen = cpstring.indexOf(59);
                        cp = new ColumnPair();
                        cp.addColumnName(cpstring.substring(0, slen));
                        cp.addColumnName(cpstring.substring(slen + 1));
                        cfm.addColumnPair(cp);
                    }
                    if (null != mre) {
                        cols = mre.getAssociatedColumns();
                    }
                    for (j = 0; null != cols && j < cols.size(); ++j) {
                        cpstring = (String)cols.get(j);
                        slen = cpstring.indexOf(59);
                        cp = new ColumnPair();
                        cp.addColumnName(cpstring.substring(0, slen));
                        cp.addColumnName(cpstring.substring(slen + 1));
                        cfm.addColumnPair(cp);
                    }
                    beanMapping.addCmrFieldMapping(cfm);
                    continue;
                }
                MappingFieldElement mfe = mce.getField(pfield.getName());
                CmpFieldMapping cfm = new CmpFieldMapping();
                cfm.setFieldName(pfield.getName());
                if (null != pce) {
                    // empty if block
                }
                ArrayList cols = null;
                if (null != mfe) {
                    cols = mfe.getColumns();
                    for (int j = 0; null != cols && j < cols.size(); ++j) {
                        cfm.addColumnName((String)cols.get(j));
                    }
                    int fgVal = mfe.getFetchGroup();
                    this.setFetchedWith(cfm, fgVal);
                }
                beanMapping.addCmpFieldMapping(cfm);
            }
            aMapping.addEntityMapping(beanMapping);
        }
        SunCmpMappings retVal = null;
        try {
            retVal = new SunCmpMappings();
            Iterator mapOfMappingIter = mapOfMapping.values().iterator();
            while (mapOfMappingIter.hasNext()) {
                SunCmpMapping aVal = (SunCmpMapping)((Object)mapOfMappingIter.next());
                retVal.addSunCmpMapping(aVal);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
        return retVal;
    }

    private void setFetchedWith(HasFetchedWith cfm, int fgVal) {
        FetchedWith fw;
        if (fgVal < 0) {
            String key = "IndependentFetchGroup" + fgVal;
            FetchedWith fw2 = new FetchedWith();
            fw2.setNamedGroup(key);
            cfm.setFetchedWith(fw2);
        }
        if (fgVal > 1) {
            fw = new FetchedWith();
            fw.setLevel(fgVal - 1);
            cfm.setFetchedWith(fw);
        }
        if (fgVal == 0) {
            fw = new FetchedWith();
            fw.setNone(true);
            cfm.setFetchedWith(fw);
        }
    }

    public String lastError() {
        String retVal = "";
        if (null != this.errorMessageFormat) {
            retVal = MessageFormat.format(this.errorMessageFormat, this.errorMessageArgs);
        }
        return retVal;
    }

    public static void main(String[] args) {
        MappingFile mf = null;
        try {
            FileInputStream iasMapping = new FileInputStream(args[0]);
            FileInputStream ejbJar = new FileInputStream(args[1]);
            String rootDir = args[2];
            FileOutputStream reflection = new FileOutputStream(args[0] + ".relection");
            EjbJarConversionHelper ddHelper = new EjbJarConversionHelper(ejbJar, args.length > 3);
            mf = new MappingFile();
            Object beansAndSchemas = null;
            Map allMappings = null;
            allMappings = mf.intoMappingClasses(iasMapping, (ConversionHelper)ddHelper, System.out);
            Iterator iter = allMappings.values().iterator();
            while (iter.hasNext()) {
                MappingClassElementImpl anMCE = (MappingClassElementImpl)iter.next();
                String className = anMCE.getName();
                PrintStream myOut = System.out;
                if (null != rootDir) {
                    String pathName = className.replace('.', File.separatorChar);
                    int len = pathName.lastIndexOf(File.separatorChar);
                    if (len > 0) {
                        File necessaryDir = new File(rootDir + File.separator + pathName.substring(0, len));
                        necessaryDir.mkdirs();
                    }
                    myOut = new PrintStream(new FileOutputStream(rootDir + File.separator + pathName + ".mapping"));
                }
                XMLOutputStream xmlOutput = new XMLOutputStream(myOut);
                xmlOutput.writeObject(anMCE);
                xmlOutput.close();
            }
            mf.fromMappingClasses(reflection, allMappings, System.out);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        System.out.println("Error message was: " + mf.lastError());
    }

    private MappingClassElement mapFieldsOfBean(EntityMapping mapping, String schemaArg, ConversionHelper helper, PrintStream out) {
        String beanName = mapping.getEjbName();
        this.errorMessageArgs[MappingFile.CURRENT_BEAN] = beanName;
        MappingFile.writeMessage(out, "MESSAGE_START_BEAN", this.errorMessageArgs);
        MappingClassElementImpl mcei = null;
        MappingClassElementImpl mce = null;
        try {
            MappingFieldElementImpl mfei;
            block56: {
                this.errorMessageFormat = bundle.getString("ERR_J2EE_IAS_MISMATCH");
                String jdoClassName = helper.getMappedClassName(beanName);
                MappingFile.writeMessage(out, "Bean: " + beanName + "  is " + jdoClassName, null);
                if (null == jdoClassName) {
                    return null;
                }
                mcei = new MappingClassElementImpl(jdoClassName);
                PersistenceClassElementImpl persistElImpl = new PersistenceClassElementImpl(jdoClassName);
                persistElImpl.setKeyClass(jdoClassName + ".Oid");
                mcei.setPersistenceElement(new PersistenceClassElement(persistElImpl));
                this.errorMessageFormat = bundle.getString("ERR_CANNOT_FIND_SCHEMA");
                this.errorMessageArgs[MappingFile.CURRENT_SCHEMA] = schemaArg;
                this.errorMessageArgs[MappingFile.CURRENT_CLASSPATH] = this.classLoader;
                SchemaElement schema = null;
                if (schemaArg != null && !schemaArg.trim().equals("")) {
                    schema = this.setDatabaseRoot(mcei, schemaArg, helper.ensureCompleteRoles());
                }
                CmpFieldMapping[] mapOfFields = mapping.getCmpFieldMapping();
                String primaryTableName = mapping.getTableName();
                HashMap<String, TableElement> knownTables = new HashMap<String, TableElement>();
                ColumnElement candidatePK = null;
                if (null != primaryTableName && !primaryTableName.trim().equals("")) {
                    ColumnElement[] cols;
                    DBIdentifier tableDbId = DBIdentifier.create(primaryTableName);
                    this.errorMessageFormat = bundle.getString("ERR_INVALID_TABLE");
                    this.errorMessageArgs[MappingFile.CURRENT_TABLE] = primaryTableName;
                    TableElement primTabEl = MappingFile.getTableElement(schema, tableDbId, helper);
                    mcei.addTable(primTabEl);
                    UniqueKeyElement uke = primTabEl.getPrimaryKey();
                    DBIdentifier candiName = null;
                    if (null != uke && null != (cols = uke.getColumns()) && 1 == cols.length) {
                        candidatePK = cols[0];
                        candiName = candidatePK.getName();
                        MappingFile.writeMessage(out, "Candidate PK has column name: " + candiName, null);
                        Integer len = candidatePK.getLength();
                        Integer pre = candidatePK.getPrecision();
                        Integer sca = candidatePK.getScale();
                        if (null != candidatePK && !candidatePK.isNumericType()) {
                            candidatePK = null;
                        }
                        if (null != candidatePK && pre < MINIMUM_PRECISION) {
                            candidatePK = null;
                        }
                    }
                    knownTables.put(primaryTableName, primTabEl);
                    MappingFile.loadSecondaryTables(mapping.getSecondaryTable(), knownTables, mcei, schema, out, helper);
                }
                mce = mcei;
                Consistency c = mapping.getConsistency();
                if (null == c) {
                    mce.setConsistencyLevel(0);
                } else if (c.isCheckModifiedAtCommit()) {
                    mce.setConsistencyLevel(1);
                } else if (c.isLockWhenLoaded()) {
                    mce.setConsistencyLevel(8);
                } else if (c.isCheckAllAtCommit()) {
                    mce.setConsistencyLevel(2);
                } else if (c.isLockWhenModified()) {
                    mce.setConsistencyLevel(4);
                } else if (c.isLockWhenModified() && c.isCheckAllAtCommit()) {
                    mce.setConsistencyLevel(6);
                } else if (c.isNone()) {
                    mce.setConsistencyLevel(0);
                } else {
                    this.errorMessageFormat = bundle.getString("ERR_INVALID_CONSISTENCY_VALUE");
                    throw new RuntimeException();
                }
                for (int i = 0; i < mapOfFields.length; ++i) {
                    CmpFieldMapping mapForOneField = mapOfFields[i];
                    String fieldName = mapForOneField.getFieldName();
                    if (!this.validateField(mcei, beanName, fieldName, helper.ensureCompleteRoles())) continue;
                    String[] columnNames = mapForOneField.getColumnName();
                    mfei = this.createUnmappedField(mcei, beanName, fieldName);
                    boolean fieldMappedToABlob = false;
                    this.errorMessageFormat = bundle.getString("ERR_INVALID_COLUMN");
                    for (int j = 0; j < columnNames.length; ++j) {
                        String sourceTableName = MappingFile.getTableName(columnNames[j], primaryTableName);
                        this.errorMessageArgs[MappingFile.CURRENT_TABLE] = sourceTableName;
                        if (null == sourceTableName) {
                            this.errorMessageFormat = bundle.getString("ERR_UNDEFINED_TABLE");
                            throw new RuntimeException();
                        }
                        String sourceColumnName = MappingFile.getColumnName(columnNames[j]);
                        this.errorMessageArgs[MappingFile.CURRENT_COLUMN] = sourceColumnName;
                        TableElement sourceTableEl = (TableElement)knownTables.get(sourceTableName);
                        ColumnElement aCol = MappingFile.getColumnElement(sourceTableEl, DBIdentifier.create(sourceColumnName), helper);
                        MappingFile.writeMessage(out, "Adding column " + aCol + " to mapping for field " + fieldName, null);
                        if (candidatePK != null && candidatePK.equals(aCol)) {
                            candidatePK = null;
                            MappingFile.writeMessage(out, "invalidate candidatePK", null);
                        }
                        fieldMappedToABlob |= aCol.isBlobType();
                        mfei.addColumn(aCol);
                    }
                    FetchedWith fw = mapForOneField.getFetchedWith();
                    if (null != fw) {
                        String ig;
                        boolean tryLevel = false;
                        int level = 0;
                        try {
                            level = fw.getLevel();
                            tryLevel = true;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (tryLevel) {
                            if (level < 1) {
                                this.errorMessageArgs[MappingFile.CURRENT_FETCH_WITH_LEVEL] = "" + level;
                                this.errorMessageFormat = bundle.getString("ERR_INVALID_FG_LEVEL");
                                throw new RuntimeException();
                            }
                            mfei.setFetchGroup(level + 1);
                        }
                        if (null != (ig = fw.getNamedGroup())) {
                            Integer fgval = (Integer)this.namedGroups.get(ig);
                            if (null == fgval) {
                                fgval = new Integer(this.groupCount--);
                                this.namedGroups.put(ig, fgval);
                            }
                            mfei.setFetchGroup(fgval);
                        }
                        if (fw.isNone()) {
                            mfei.setFetchGroup(0);
                        }
                    } else if (fieldMappedToABlob) {
                        mfei.setFetchGroup(0);
                    } else {
                        mfei.setFetchGroup(1);
                    }
                    mcei.addField(mfei);
                }
                if (null != candidatePK) {
                    if (helper.applyDefaultUnknownPKClassStratgey(beanName)) {
                        Date uniquer = new Date();
                        String fieldName = "generatedPKField" + uniquer.getTime();
                        PersistenceFieldElementImpl pfei = new PersistenceFieldElementImpl(fieldName);
                        PersistenceFieldElement pfe = new PersistenceFieldElement(pfei, mcei.getPersistenceElement());
                        pfe.setKey(true);
                        mcei.getPersistenceElement().addField(pfe);
                        mfei = new MappingFieldElementImpl(fieldName, mcei);
                        mfei.addColumn(candidatePK);
                        mcei.addField(mfei);
                    }
                } else if (helper.applyDefaultUnknownPKClassStratgey(beanName)) {
                    // empty if block
                }
                if (helper.ensureCompleteRoles()) {
                    this.mapRelationships(mcei, mapping, beanName, primaryTableName, knownTables, out, schema);
                } else {
                    try {
                        this.mapRelationships(mcei, mapping, beanName, primaryTableName, knownTables, out, schema);
                    }
                    catch (Throwable t) {
                        if (null == out) break block56;
                        t.printStackTrace(out);
                    }
                }
            }
            mce = mcei;
            this.errorMessageFormat = bundle.getString("MISSING_FIELD_MAPPING");
            Object[] fields = helper.getFields(beanName);
            for (int z = 0; z < fields.length; ++z) {
                String afn = (String)fields[z];
                this.errorMessageArgs[MappingFile.CURRENT_FIELD] = afn;
                MappingFieldElement mfe = mce.getField(afn);
                if (null != mfe) continue;
                if (helper.ensureCompleteRoles()) {
                    throw new RuntimeException();
                }
                mfei = this.createUnmappedField(mcei, beanName, afn);
                mcei.addField(mfei);
            }
        }
        catch (FileNotFoundException fnfe) {
            if (null != out) {
                fnfe.printStackTrace(out);
            }
            throw new RuntimeException(fnfe);
        }
        catch (IOException ioe) {
            if (null != out) {
                ioe.printStackTrace(out);
            }
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            if (null != out) {
                cnfe.printStackTrace(out);
            }
            throw new RuntimeException(cnfe);
        }
        catch (DBException dbe) {
            if (null != out) {
                dbe.printStackTrace(out);
            }
            throw new RuntimeException(dbe);
        }
        catch (ModelException t) {
            if (null != out) {
                t.printStackTrace(out);
            }
            throw new RuntimeException(t);
        }
        this.errorMessageFormat = null;
        return mce;
    }

    private void mapRelationships(MappingClassElementImpl mce, EntityMapping mapping, String beanName, String primaryTableName, Map knownTables, PrintStream out, SchemaElement schema) throws ModelException, DBException {
        CmrFieldMapping[] mapOfRelations = mapping.getCmrFieldMapping();
        PersistenceClassElement pce = mce.getPersistenceElement();
        for (int i = 0; mapOfRelations != null && i < mapOfRelations.length; ++i) {
            CmrFieldMapping aRelation = mapOfRelations[i];
            String fieldName = aRelation.getCmrFieldName();
            if (!this.validateField(mce, beanName, fieldName, this.helper.ensureCompleteRoles())) {
                MappingFile.writeMessage(out, "WARN_INVALID_CMRFIELD", new Object[]{beanName, fieldName});
                continue;
            }
            RelationshipElement rel = new RelationshipElement(new RelationshipElementImpl(fieldName), pce);
            MappingRelationshipElementImpl mre = new MappingRelationshipElementImpl(fieldName, mce);
            this.registerInverseRelationshipElement(rel, beanName, fieldName);
            ColumnPair[] pairs = aRelation.getColumnPair();
            String relationId = mapping.getEjbName() + "_Relationship_" + i;
            Collection primaryTableColumns = this.convertToColumnPairElements(pairs, primaryTableName, schema, knownTables, relationId, mre);
            this.setUpperBound(rel, beanName, fieldName, out);
            this.setCascadeDeleteAction(rel, beanName, fieldName, out);
            this.setLowerBound(rel, primaryTableColumns, primaryTableName, schema, knownTables, beanName, fieldName, out);
            this.setFetchGroup(aRelation.getFetchedWith(), mre, false);
            pce.addField(rel);
            mce.addField(mre);
        }
    }

    private Collection convertToColumnPairElements(ColumnPair[] pairs, String primaryTableName, SchemaElement schema, Map knownTables, String relationId, MappingRelationshipElement mre) throws DBException, ModelException {
        ArrayList<ColumnElement> primaryTableColumns = new ArrayList<ColumnElement>();
        boolean isJoin = false;
        for (int i = 0; null != pairs && i < pairs.length; ++i) {
            ColumnPair pair = pairs[i];
            ColumnPairElement cpe = new ColumnPairElement();
            boolean localSet = false;
            cpe.setName(DBIdentifier.create(relationId + "_ColumnPair_" + i));
            for (int j = 0; j < 2; ++j) {
                String columnName = pair.getColumnName(j);
                String sourceTableName = MappingFile.getTableName(columnName, primaryTableName);
                this.errorMessageArgs[MappingFile.CURRENT_TABLE] = sourceTableName;
                String sourceColumnName = MappingFile.getColumnName(columnName);
                this.errorMessageArgs[MappingFile.CURRENT_COLUMN] = sourceColumnName;
                TableElement sourceTableEl = this.getTableElement(sourceTableName, knownTables, schema);
                this.errorMessageFormat = bundle.getString("ERR_INVALID_COLUMN");
                ColumnElement ce = MappingFile.getColumnElement(sourceTableEl, DBIdentifier.create(sourceColumnName), this.helper);
                ce.toString();
                if (j == 0) {
                    if (sourceTableName.equals(primaryTableName)) {
                        localSet = true;
                        primaryTableColumns.add(ce);
                    } else {
                        isJoin = true;
                        localSet = false;
                    }
                }
                if (cpe.getLocalColumn() == null) {
                    cpe.setLocalColumn(ce);
                    continue;
                }
                cpe.setReferencedColumn(ce);
            }
            if (localSet) {
                if (!isJoin) {
                    mre.addColumn(cpe);
                    continue;
                }
                mre.addLocalColumn(cpe);
                continue;
            }
            if (!isJoin) continue;
            mre.addAssociatedColumn(cpe);
        }
        return primaryTableColumns;
    }

    private void setLowerBound(RelationshipElement rel, Collection primaryTableColumns, String primaryTableName, SchemaElement schema, Map knownTables, String beanName, String fieldName, PrintStream out) throws ModelException, DBException {
        rel.setLowerBound(0);
        MappingFile.writeMessage(out, "MESSAGE_LWB_NULL", new Object[]{beanName, fieldName});
        if (1 == rel.getUpperBound()) {
            boolean isPartOfPrimaryKey = false;
            TableElement primaryTable = this.getTableElement(primaryTableName, knownTables, schema);
            UniqueKeyElement pk = primaryTable.getPrimaryKey();
            ForeignKeyElement[] fks = primaryTable.getForeignKeys();
            Iterator iter = primaryTableColumns.iterator();
            while (iter.hasNext() && 0 == rel.getLowerBound()) {
                ColumnElement ce = (ColumnElement)iter.next();
                if (ce.isNullable()) continue;
                if (!(isPartOfPrimaryKey |= MappingFile.isPartOfPrimaryKey(ce, pk))) {
                    rel.setLowerBound(1);
                    MappingFile.writeMessage(out, "MESSAGE_LWB_NOPK", new Object[]{beanName, fieldName});
                    continue;
                }
                if (!MappingFile.isPartOfForeignKey(ce, fks)) continue;
                rel.setLowerBound(1);
                MappingFile.writeMessage(out, "MESSAGE_LWB_FK", new Object[]{beanName, fieldName});
            }
            if (0 == rel.getLowerBound() && isPartOfPrimaryKey) {
                if (primaryTableColumns.size() < pk.getColumns().length) {
                    rel.setLowerBound(1);
                    MappingFile.writeMessage(out, "MESSAGE_LWB_PKSUBSET", new Object[]{beanName, fieldName});
                } else if (this.isCascadeDelete(beanName, fieldName)) {
                    rel.setLowerBound(1);
                    MappingFile.writeMessage(out, "MESSAGE_LWB_CASCADE", new Object[]{beanName, fieldName});
                } else {
                    MappingFile.writeMessage(out, "MESSAGE_LWB_NODEPENDENT", new Object[]{beanName, fieldName});
                }
            }
        }
    }

    private TableElement getTableElement(String tableName, Map knownTables, SchemaElement schema) throws DBException {
        TableElement te = (TableElement)knownTables.get(tableName);
        if (null == te) {
            te = MappingFile.getTableElement(schema, DBIdentifier.create(tableName), this.helper);
            this.errorMessageFormat = bundle.getString("ERR_INVALID_TABLE");
            te.toString();
            knownTables.put(tableName, te);
        }
        return te;
    }

    private static boolean isPartOfPrimaryKey(ColumnElement ce, UniqueKeyElement pk) {
        return null != pk && ce.equals(pk.getColumn(ce.getName()));
    }

    private static boolean isPartOfForeignKey(ColumnElement ce, ForeignKeyElement[] fks) {
        if (fks != null) {
            for (int index = 0; index < fks.length; ++index) {
                if (!ce.equals(fks[index].getColumn(ce.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCascadeDelete(String beanName, String fieldName) {
        String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
        String inverseField = this.helper.getInverseFieldName(beanName, fieldName);
        return null != beanInField && null != inverseField ? this.helper.relatedObjectsAreDeleted(beanInField, inverseField) : false;
    }

    private RelationshipElement registerInverseRelationshipElement(RelationshipElement rel, String beanName, String fieldName) throws ModelException {
        String key = beanName + "." + fieldName;
        RelationshipElement inverse = (RelationshipElement)this.inverseRelationships.get(key);
        if (null == inverse) {
            String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
            String inverseField = this.helper.getInverseFieldName(beanName, fieldName);
            if (null != beanInField && null != inverseField) {
                key = beanInField + "." + inverseField;
                this.inverseRelationships.put(key, rel);
            }
        } else {
            rel.changeInverseRelationship(inverse);
            inverse.changeInverseRelationship(rel);
        }
        return inverse;
    }

    private void setUpperBound(RelationshipElement rel, String beanName, String fieldName, PrintStream out) throws ModelException {
        String beanInField = this.helper.getRelationshipFieldContent(beanName, fieldName);
        String classInJdoField = this.helper.getMappedClassName(beanInField);
        String multiplicity = this.helper.getMultiplicity(beanName, fieldName);
        if (multiplicity.equals("Many")) {
            rel.setUpperBound(Integer.MAX_VALUE);
            rel.setElementClass(classInJdoField);
            String collectionClass = this.helper.getRelationshipFieldType(beanName, fieldName);
            this.errorMessageArgs[MappingFile.CURRENT_RELATION_FIELD_TYPE] = collectionClass;
            this.errorMessageFormat = bundle.getString("ERR_BAD_FIELD_TYPE");
            if (types.contains(collectionClass)) {
                rel.setCollectionClass(collectionClass);
            } else {
                rel.setCollectionClass(null);
                MappingFile.writeMessage(out, "WARN_INVALID_RELATIONSHIP_FIELDTYPE", new Object[]{beanName, fieldName, collectionClass});
            }
        } else if (multiplicity.equals("One")) {
            rel.setUpperBound(1);
            rel.setElementClass(classInJdoField);
        } else {
            this.errorMessageArgs[MappingFile.CURRENT_RELATION_FIELD_TYPE] = multiplicity;
            this.errorMessageFormat = bundle.getString("ERR_BAD_MULTIPLICTY");
            throw new RuntimeException();
        }
    }

    private void setCascadeDeleteAction(RelationshipElement rel, String beanName, String fieldName, PrintStream out) throws ModelException {
        if (this.helper.relatedObjectsAreDeleted(beanName, fieldName)) {
            MappingFile.writeMessage(out, "relatedObjectsAreDeleted(" + beanName + "," + fieldName + ") is TRUE", null);
            rel.setDeleteAction(3);
        }
    }

    public SchemaElement setDatabaseRoot(MappingClassElement foo2, String schemaElementValue) throws ModelException, FileNotFoundException, ClassNotFoundException, IOException {
        return this.setDatabaseRoot(foo2, schemaElementValue, true);
    }

    private SchemaElement setDatabaseRoot(MappingClassElement foo2, String schemaElementValue, boolean strict) throws ModelException, FileNotFoundException, ClassNotFoundException, IOException {
        SchemaElement bar = null;
        if (null != this.classLoader) {
            if (this.loadedSchema.get(schemaElementValue) == null) {
                SchemaElement.removeFromCache(schemaElementValue);
                this.loadedSchema.put(schemaElementValue, schemaElementValue);
            }
            bar = SchemaElement.forName(schemaElementValue, this.classLoader);
        } else {
            bar = SchemaElement.forName(schemaElementValue);
        }
        if (strict) {
            bar.toString();
        } else if (null == bar) {
            try {
                bar = new SchemaElement();
                bar.setName(DBIdentifier.create(schemaElementValue));
            }
            catch (DBException dbx) {
                bar.getName().toString();
            }
        }
        foo2.setDatabaseRoot(bar);
        return bar;
    }

    public static String getTableName(String columnName, String defaultName) {
        String retVal = defaultName;
        int len = columnName.lastIndexOf(46);
        if (len > 0) {
            retVal = columnName.substring(0, len);
        }
        return retVal;
    }

    public static String getColumnName(String columnName) {
        String retVal = columnName;
        int len = columnName.lastIndexOf(46);
        if (len > 0) {
            retVal = columnName.substring(len + 1);
        }
        return retVal;
    }

    private static void loadSecondaryTables(SecondaryTable[] tableList, Map knownValues, MappingClassElement mce, SchemaElement schema, PrintStream out, ConversionHelper helper) throws ModelException, DBException {
        ArrayList tl = mce.getTables();
        if (null == tl || tl.size() < 1) {
            MappingFile.writeMessage(out, "WARN_NOT_MAPPED_TO_PRIMARY", new Object[]{mce});
            return;
        }
        MappingTableElement primary = (MappingTableElement)tl.get(0);
        if (null != primary) {
            for (int i = 0; null != tableList && i < tableList.length; ++i) {
                String tn = tableList[i].getTableName();
                if (null == tn || tn.trim().length() == 0) continue;
                TableElement te = MappingFile.getTableElement(schema, DBIdentifier.create(tn.trim()), helper);
                ColumnPair[] pairs = tableList[i].getColumnPair();
                int len = 0;
                if (null != pairs) {
                    len = pairs.length;
                }
                if (0 == len) {
                    MappingFile.writeMessage(out, "WARN_NO_PAIRS", new Object[]{mce, tn});
                    continue;
                }
                MappingReferenceKeyElement mrke = mce.addSecondaryTable(primary, te);
                for (int j = 0; null != pairs && j < pairs.length; ++j) {
                    ColumnPairElement cpe = new ColumnPairElement();
                    DBIdentifier dbId = DBIdentifier.create("SecondaryTable" + j);
                    cpe.setName(dbId);
                    ColumnPair pair = pairs[j];
                    for (int k = 0; k < 2; ++k) {
                        String nameOne = pair.getColumnName(k);
                        String sourceTableName = MappingFile.getTableName(nameOne.trim(), primary.getName().toString());
                        String sourceColumnName = MappingFile.getColumnName(nameOne);
                        dbId = DBIdentifier.create(sourceTableName);
                        TableElement sourceTableEl = MappingFile.getTableElement(schema, dbId, helper);
                        dbId = DBIdentifier.create(sourceColumnName);
                        ColumnElement ce = MappingFile.getColumnElement(sourceTableEl, dbId, helper);
                        if (k == 0) {
                            cpe.setLocalColumn(ce);
                            continue;
                        }
                        cpe.setReferencedColumn(ce);
                    }
                    mrke.addColumnPair(cpe);
                }
                knownValues.put(tn, te);
            }
        } else {
            MappingFile.writeMessage(out, "WARN_NULL_PRIMARY", new Object[]{mce});
        }
    }

    private static void writeMessage(PrintStream out, String messageKey, Object[] params) {
        if (null != out) {
            try {
                String format = bundle.getString(messageKey);
                out.println(MessageFormat.format(format, params));
            }
            catch (Throwable t) {
                out.println(messageKey);
            }
        }
    }

    private boolean validateField(MappingClassElement mcei, String beanName, String fieldName, boolean throwEx) {
        MappingFieldElement mfe = mcei.getField(fieldName);
        this.errorMessageArgs[MappingFile.CURRENT_FIELD] = fieldName;
        if (null != mfe) {
            this.errorMessageFormat = bundle.getString("ERR_FIELD_MAPPED_TWICE");
            if (throwEx) {
                throw new RuntimeException();
            }
            return false;
        }
        if (!this.helper.hasField(beanName, fieldName)) {
            this.errorMessageFormat = bundle.getString("ERR_INVALID_FIELD");
            if (throwEx) {
                throw new RuntimeException();
            }
            return false;
        }
        return true;
    }

    private Map getBean2EntityMappingMap(SunCmpMapping beanSet) {
        HashMap<String, EntityMapping> retVal = new HashMap<String, EntityMapping>();
        EntityMapping[] entityMappingsInSet = beanSet.getEntityMapping();
        int len = 0;
        if (null != entityMappingsInSet) {
            len = entityMappingsInSet.length;
        }
        for (int k = 0; k < len; ++k) {
            EntityMapping anEntityMapping = entityMappingsInSet[k];
            String beanName = anEntityMapping.getEjbName();
            this.errorMessageFormat = bundle.getString("ERR_INVALID_MAPPING_MISSING_BEAN_NAME");
            beanName.trim().charAt(0);
            retVal.put(beanName, anEntityMapping);
        }
        return retVal;
    }

    private boolean completeCmrMappings(SunCmpMapping beanSet, ConversionHelper helper) {
        Map beanName2EntityMapping = this.getBean2EntityMappingMap(beanSet);
        Iterator emIter = beanName2EntityMapping.values().iterator();
        boolean retVal = false;
        while (emIter.hasNext()) {
            EntityMapping anEM = (EntityMapping)((Object)emIter.next());
            String beanName = anEM.getEjbName();
            this.errorMessageArgs[MappingFile.CURRENT_BEAN] = beanName;
            String pt = anEM.getTableName();
            CmrFieldMapping[] cmrsInEM = anEM.getCmrFieldMapping();
            int len = 0;
            if (null != cmrsInEM && null != beanName && beanName.trim().length() != 0) {
                len = cmrsInEM.length;
            }
            for (int i = 0; i < len; ++i) {
                String fieldName = cmrsInEM[i].getCmrFieldName();
                this.errorMessageFormat = bundle.getString("ERR_INVALID_MAPPING_MISSING_FIELD_NAME");
                fieldName.trim().charAt(0);
                this.errorMessageArgs[MappingFile.CURRENT_FIELD] = fieldName;
                this.errorMessageFormat = bundle.getString("ERR_INVALID_MAPPING_NAME_MISMATCH");
                String otherField = helper.getInverseFieldName(beanName, fieldName);
                this.errorMessageFormat = bundle.getString("ERR_BAD_CONVERSION_HELPER");
                String test2 = helper.getInverseFieldName(beanName, fieldName);
                if (!otherField.equals(test2)) {
                    throw new RuntimeException(this.errorMessageFormat);
                }
                String otherBean = helper.getRelationshipFieldContent(beanName, fieldName);
                if (!helper.isPseudoCMRField(otherBean, otherField)) continue;
                retVal = true;
                String otherBeanName = helper.getRelationshipFieldContent(beanName, fieldName);
                this.errorMessageFormat = bundle.getString("ERR_EJB_JAR_ERROR_FOR_RELATIONSHIP");
                otherBeanName.trim().charAt(0);
                EntityMapping otherEM = (EntityMapping)((Object)beanName2EntityMapping.get(otherBeanName));
                CmrFieldMapping inverseMapping = new CmrFieldMapping();
                inverseMapping.setCmrFieldName(otherField);
                inverseMapping.setColumnPair(this.reverseCPArray(cmrsInEM[i].getColumnPair(), pt));
                this.errorMessageArgs[MappingFile.CURRENT_BEAN] = otherBeanName;
                this.errorMessageFormat = bundle.getString("ERR_BEAN_UNMAPPED");
                otherEM.addCmrFieldMapping(inverseMapping);
                this.errorMessageArgs[MappingFile.CURRENT_BEAN] = beanName;
            }
        }
        return retVal;
    }

    private ColumnPair[] reverseCPArray(ColumnPair[] cpa, String primeTable) {
        this.errorMessageFormat = bundle.getString("ERR_COLUMN_PAIR_MISSING");
        int len = cpa.length;
        ColumnPair[] retVal = new ColumnPair[cpa.length];
        for (int index = 0; index < len; ++index) {
            retVal[index] = new ColumnPair();
            retVal[index].addColumnName(this.qualify(primeTable, cpa[index].getColumnName(1)));
            this.errorMessageFormat = bundle.getString("ERR_INCOMPLETE_COLUMN_PAIR");
            retVal[index].addColumnName(this.qualify(primeTable, cpa[index].getColumnName(0)));
        }
        return retVal;
    }

    private String qualify(String tn, String cn) {
        int tmp = cn.indexOf(46);
        String retVal = cn;
        if (-1 == tmp) {
            retVal = tn + "." + cn;
        }
        return retVal;
    }

    private static TableElement getTableElement(SchemaElement schema, DBIdentifier dbId, ConversionHelper helper) throws DBException {
        TableElement retVal = schema.getTable(dbId);
        if (null == retVal && !helper.ensureCompleteRoles()) {
            retVal = new TableElement();
            retVal.setName(dbId);
            retVal.setDeclaringSchema(schema);
            UniqueKeyElement tkey = new UniqueKeyElement();
            ColumnElement fakeKeyCol = new ColumnElement();
            fakeKeyCol.setName(DBIdentifier.create("fookeyng"));
            tkey.addColumn(fakeKeyCol);
            retVal.addKey(tkey);
        }
        return retVal;
    }

    private static ColumnElement getColumnElement(TableElement sourceTableEl, DBIdentifier sourceColumnName, ConversionHelper helper) throws DBException {
        ColumnElement aCol = sourceTableEl.getColumn(sourceColumnName);
        if (null == aCol && !helper.ensureCompleteRoles()) {
            aCol = new ColumnElement();
            aCol.setName(DBIdentifier.create(sourceTableEl.getName().toString() + "." + sourceColumnName.toString()));
            aCol.setDeclaringTable(sourceTableEl);
        }
        return aCol;
    }

    private MappingFieldElementImpl createUnmappedField(MappingClassElementImpl mcei, String beanName, String fieldName) throws ModelException {
        PersistenceFieldElementImpl pfei = new PersistenceFieldElementImpl(fieldName);
        PersistenceFieldElement pfe = new PersistenceFieldElement(pfei, mcei.getPersistenceElement());
        pfe.setKey(this.helper.isKey(beanName, fieldName, false));
        mcei.getPersistenceElement().addField(pfe);
        MappingFieldElementImpl mfei = new MappingFieldElementImpl(fieldName, mcei);
        return mfei;
    }

    private void setFetchGroup(FetchedWith fw, MappingFieldElement mfe, boolean fieldMappedToABlob) throws ModelException {
        if (null != fw) {
            String ig;
            boolean tryLevel = false;
            int level = 0;
            try {
                level = fw.getLevel();
                tryLevel = true;
            }
            catch (RuntimeException t) {
                // empty catch block
            }
            if (tryLevel) {
                if (level < 1) {
                    this.errorMessageArgs[MappingFile.CURRENT_FETCH_WITH_LEVEL] = "" + level;
                    this.errorMessageFormat = bundle.getString("ERR_INVALID_FG_LEVEL");
                    throw new RuntimeException();
                }
                mfe.setFetchGroup(level + 1);
            }
            if (null != (ig = fw.getNamedGroup())) {
                Integer fgval = (Integer)this.namedGroups.get(ig);
                if (null == fgval) {
                    fgval = new Integer(this.groupCount--);
                    this.namedGroups.put(ig, fgval);
                }
                mfe.setFetchGroup(fgval);
            }
            if (fw.isNone()) {
                mfe.setFetchGroup(0);
            }
        } else if (mfe instanceof MappingRelationshipElement) {
            mfe.setFetchGroup(0);
        } else if (fieldMappedToABlob) {
            mfe.setFetchGroup(0);
        } else {
            mfe.setFetchGroup(1);
        }
    }

    static {
        types.add(JAVA_TYPE_SET);
        types.add(JAVA_TYPE_COLLECTION);
        bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.ejb.cmp.transform.Bundle");
        DEFAULT_LOCATION_IN_EJB_JAR = bundle.getString("CONST_IAS_MAPPING_FILE_LOC");
        CURRENT_BEAN = 0;
        CURRENT_SCHEMA = 1;
        CURRENT_CLASSPATH = 2;
        CURRENT_TABLE = 3;
        CURRENT_COLUMN = 4;
        CURRENT_FIELD = 5;
        CURRENT_RELATION_FIELD_TYPE = 6;
        CURRENT_FETCH_WITH_LEVEL = 7;
        CURRENT_MAPPING_FILE = 8;
        LAST_INDEX = 9;
        MINIMUM_PRECISION = 19;
    }
}

