/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.cmp.transform;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.TpCmpShadowFileManager;
import com.iplanet.ias.tools.forte.ejb.cmp.transform.ConversionHelper;
import com.iplanet.ias.tools.forte.ejb.util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.j2ee.deployment.api.StandardDDBean;
import org.netbeans.modules.j2ee.server.datamodel.DeploymentStandardData;
import org.netbeans.modules.j2ee.server.datamodel.EjbModuleStandardData;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;

public class EjbModuleStandardDataHelper
implements ConversionHelper {
    private HashMap myRole = new HashMap();
    private HashMap otherRole = new HashMap();
    private static ResourceBundle bundle = null;
    private static String CONTAINER = null;
    private static String DOT = ".";
    private static String EJB_RELATION_XPATH = null;
    private static String EJB_RELATIONSHIP_ROLE_XPATH = null;
    private static String RELATIONSHIP_ROLE_SOURCE_XPATH = null;
    private static String CMR_FIELD_NAME_XPATH = null;
    private static String CMR_FIELD_TYPE_XPATH = null;
    private static String MULTIPLICITY_XPATH = null;
    private static String CASCADE_DELETE_XPATH = null;
    private Map j2eeRelations = new HashMap();
    private Map j2eeBeans = new HashMap();
    private Map fieldsMap = new HashMap();
    private EjbModuleStandardData.Module standardMod;

    public EjbModuleStandardDataHelper(EjbModuleStandardData.Module m) {
        int j;
        DeploymentStandardData tmp = m.getRelationships();
        EjbStandardData.Ejb[] ejbs = m.getBaseEjbs();
        this.standardMod = m;
        int i = 0;
        for (i = 0; null != ejbs && i < ejbs.length; ++i) {
            EjbStandardData.EntityEjb entEjb;
            EjbStandardData.Ejb ejb = ejbs[i];
            if (!(ejb instanceof EjbStandardData.EntityEjb) || !(entEjb = (EjbStandardData.EntityEjb)ejb).getPersistenceType().equals(CONTAINER)) continue;
            this.j2eeBeans.put(entEjb.getEjbName(), entEjb);
            HashMap<String, EjbStandardData.CmpField> fieldsOnBean = new HashMap<String, EjbStandardData.CmpField>();
            this.fieldsMap.put(entEjb.getEjbName(), fieldsOnBean);
            EjbStandardData.CmpField[] fields = entEjb.getCmpFieldCategory().getCmpFields();
            for (j = 0; null != fields && j < fields.length; ++j) {
                fieldsOnBean.put(fields[j].getFieldName(), fields[j]);
            }
        }
        if (null != tmp && null != tmp.getStandardDDBean()) {
            StandardDDBean[] relations = tmp.getStandardDDBean().getChildBean(EJB_RELATION_XPATH);
            int len = 0;
            if (null != relations) {
                len = relations.length;
            } else {
                Reporter.warn("no ejb-relation elements");
            }
            for (i = 0; i < len; ++i) {
                StandardDDBean aRelation = relations[i];
                StandardDDBean[] roles = aRelation.getChildBean(EJB_RELATIONSHIP_ROLE_XPATH);
                Reporter.warn("Relation[" + i + "] has " + roles.length + " roles");
                for (j = 0; j < 2; ++j) {
                    String[] source = roles[j].getText(RELATIONSHIP_ROLE_SOURCE_XPATH);
                    Reporter.warn("Role[" + j + "] has the source: " + source[0]);
                    String[] fname = roles[j].getText(CMR_FIELD_NAME_XPATH);
                    if (null != fname && 0 != fname.length) {
                        Reporter.warn("Role[" + j + "] has the fieldname: " + fname[0]);
                        String fullName = this.mK(source[0], fname[0]);
                        this.myRole.put(fullName, roles[j]);
                        Map fieldsOnBean = (Map)this.fieldsMap.get(source[0]);
                        if (null != fieldsOnBean) {
                            fieldsOnBean.put(fname[0], fname[0]);
                        } else {
                            Reporter.critical("fieldsOnBean is null: relation field mappinsg may be lost for " + source[0]);
                        }
                        int otherDex = j - 1;
                        if (otherDex < 0) {
                            otherDex = -otherDex;
                        }
                        this.otherRole.put(fullName, roles[otherDex]);
                        continue;
                    }
                    Reporter.warn("Role[" + j + "] has no field name");
                }
            }
        } else {
            Reporter.warn("no relationships");
        }
    }

    private String mK(String ejbName, String fieldName) {
        return ejbName + DOT + fieldName;
    }

    public String getMultiplicity(String ejbName, String fieldName) {
        StandardDDBean role = (StandardDDBean)this.otherRole.get(this.mK(ejbName, fieldName));
        String[] plicity = role.getText(MULTIPLICITY_XPATH);
        return plicity[0];
    }

    public boolean relatedObjectsAreDeleted(String ejbName, String fieldName) {
        StandardDDBean role = (StandardDDBean)this.otherRole.get(this.mK(ejbName, fieldName));
        String[] cd = role.getText(CASCADE_DELETE_XPATH);
        boolean retVal = false;
        if (null == cd) {
            return retVal;
        }
        if (null == cd[0]) {
            return retVal;
        }
        retVal = Boolean.valueOf(cd[0]);
        return retVal;
    }

    public boolean ensureCompleteRoles() {
        return false;
    }

    public String getRelationshipFieldContent(String ejbName, String fieldName) {
        String retVal = null;
        StandardDDBean role = null;
        String[] content = null;
        try {
            role = (StandardDDBean)this.otherRole.get(this.mK(ejbName, fieldName));
            content = role.getText(RELATIONSHIP_ROLE_SOURCE_XPATH);
            retVal = content[0];
        }
        catch (Throwable t) {
            Reporter.critical(this.mK(ejbName, fieldName));
            if (null == role) {
                Set keys = this.otherRole.keySet();
                Iterator iter = keys.iterator();
                while (iter.hasNext()) {
                    Reporter.critical("RoleKey: " + iter.next());
                }
            } else {
                Reporter.critical(role);
            }
            Reporter.critical(content);
        }
        return retVal;
    }

    public boolean isKey(String beanName, String fieldName, boolean candidate) {
        boolean retVal = candidate;
        EjbStandardData.EntityEjb j2ee = (EjbStandardData.EntityEjb)this.j2eeBeans.get(beanName);
        if (null != j2ee) {
            return util.isKeyField(fieldName, j2ee);
        }
        return false;
    }

    public String getInverseFieldName(String ejbName, String fieldName) {
        StandardDDBean role = (StandardDDBean)this.otherRole.get(this.mK(ejbName, fieldName));
        if (null == role) {
            return null;
        }
        String[] otherField = role.getText(CMR_FIELD_NAME_XPATH);
        Object retVal = null;
        if (null == otherField) {
            return null;
        }
        if (otherField.length < 1) {
            return null;
        }
        if (null == otherField[0]) {
            return null;
        }
        if (0 == otherField[0].trim().length()) {
            return null;
        }
        return otherField[0].trim();
    }

    public String getMappedClassName(String beanName) {
        EjbStandardData.Ejb ejb = (EjbStandardData.Ejb)this.j2eeBeans.get(beanName);
        String retVal = null;
        if (null != ejb) {
            retVal = TpCmpShadowFileManager.getShadowPackageName(ejb, this.standardMod);
        }
        return retVal;
    }

    public String getRelationshipFieldType(String ejbName, String fieldName) {
        StandardDDBean role = (StandardDDBean)this.myRole.get(this.mK(ejbName, fieldName));
        String retVal = null;
        String[] ftype = role.getText(CMR_FIELD_TYPE_XPATH);
        if (null != ftype && null != ftype[0] && !ftype[0].trim().equals("")) {
            retVal = ftype[0];
        } else {
            Reporter.error(this.mK(ejbName, fieldName) + " has no field type?");
            Reporter.error(ftype);
            if (null != ftype) {
                Reporter.error("type returns " + ftype.length + " elements");
                if (ftype.length > 0) {
                    Reporter.error("zero element is " + ftype[0]);
                }
            }
            retVal = "java.util.Collection";
        }
        return retVal;
    }

    public boolean applyDefaultUnknownPKClassStratgey(String ejbName) {
        return false;
    }

    public boolean hasField(String beanName, String fieldName) {
        Map fieldsOnBean = (Map)this.fieldsMap.get(beanName);
        if (null == fieldsOnBean) {
            return false;
        }
        return null != fieldsOnBean.get(fieldName);
    }

    public Object[] getFields(String beanName) {
        Map fieldsOnBean = (Map)this.fieldsMap.get(beanName);
        if (null == fieldsOnBean) {
            return new Object[0];
        }
        return fieldsOnBean.keySet().toArray();
    }

    public boolean isPseudoCMRField(String ejbName, String fieldName) {
        return false;
    }

    static {
        bundle = ResourceBundle.getBundle("com.iplanet.ias.tools.forte.ejb.cmp.transform.Bundle");
        CONTAINER = bundle.getString("CONTAINER_CONST");
        EJB_RELATION_XPATH = bundle.getString("CONST_EJB_RELATION_XPATH");
        EJB_RELATIONSHIP_ROLE_XPATH = bundle.getString("CONST_EJB_RELATIONSHIP_ROLE_XPATH");
        RELATIONSHIP_ROLE_SOURCE_XPATH = bundle.getString("CONST_RELATIONSHIP_ROLE_SOURCE_XPATH");
        CMR_FIELD_NAME_XPATH = bundle.getString("CONST_CMR_FIELD_NAME_XPATH");
        CMR_FIELD_TYPE_XPATH = bundle.getString("CONST_CMR_FIELD_TYPE_XPATH");
        MULTIPLICITY_XPATH = bundle.getString("CONST_MULTIPLICITY_XPATH");
        CASCADE_DELETE_XPATH = bundle.getString("CONST_CASCADE_DELETE_XPATH");
    }
}

