/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.compile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;

public class WDContextDescriptor {
    private WebStandardData.WebModule baseFs;

    public WDContextDescriptor(WebStandardData.WebModule wm) {
        if (wm == null) {
            throw new IllegalArgumentException();
        }
        this.baseFs = wm;
    }

    public URL getResource(String path) throws MalformedURLException {
        WebStandardData.WebResource res = this.getWebResource(path);
        if (res == null) {
            return null;
        }
        return this.getResourceExternalURL(res);
    }

    public InputStream getResourceAsStream(String path) {
        WebStandardData.WebResource res = this.getWebResource(path);
        if (res == null) {
            return null;
        }
        try {
            File ff = this.getFileForWebResource(res);
            if (ff != null) {
                return new FileInputStream(ff);
            }
            return null;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    private File getFileForWebResource(WebStandardData.WebResource res) {
        File root = res.getWebModule().getDocumentBase();
        String ff = res.getResourceURI().replace('/', File.separatorChar);
        return new File(root, ff);
    }

    public WebStandardData.WebResource getWebResource(String path) {
        path = path.replace('\\', '/');
        return this.baseFs.findResource(path);
    }

    private URL getResourceExternalURL(WebStandardData.WebResource res) {
        File ff = this.getFileForWebResource(res);
        if (ff != null) {
            try {
                return ff.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public String getRealPath(String path) {
        String realPath = null;
        try {
            File ff;
            WebStandardData.WebResource res;
            URL url = this.getResource(path);
            if (url != null && url.getProtocol().equals("file") && (res = this.getWebResource(path)) != null && (ff = this.getFileForWebResource(res)) != null) {
                realPath = ff.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return realPath;
    }
}

