/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.common;

import com.iplanet.ias.tools.common.dd.EjbRef;
import com.iplanet.ias.tools.common.dd.ResourceEnvRef;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.tools.forte.common.editors.IASEJBRefPanel;
import com.iplanet.ias.tools.forte.common.editors.IASResourceEnvRefPanel;
import com.iplanet.ias.tools.forte.common.editors.IASResourceRefPanel;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.j2ee.deployment.api.ConfigBean;
import org.netbeans.modules.j2ee.deployment.api.StandardDDBean;
import org.netbeans.modules.j2ee.deployment.api.XpathEvent;
import org.netbeans.modules.j2ee.deployment.api.XpathListener;
import org.netbeans.modules.j2ee.server.CustomDialogPanel;
import org.netbeans.modules.schema2beans.BaseBean;

public abstract class IASRefBean
implements ConfigBean {
    protected BaseBean parent;
    protected StandardDDBean parentStandard;
    protected BaseBean ref;
    protected StandardDDBean standard;
    public static final String HERE_XPATH = ".";
    public static final String PARENT_XPATH = "..";

    IASRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
        this.parent = parent;
        this.parentStandard = parentStandard;
        this.standard = standard;
        String refName = this.getStandardRefName(standard);
        BaseBean[] refs = this.getRefsFromDD();
        if (refs != null && refName != null) {
            for (int i = 0; i < refs.length; ++i) {
                if (!refName.equals(this.getIASRefName(refs[i]))) continue;
                this.ref = refs[i];
                break;
            }
        }
        if (this.ref == null) {
            this.ref = this.createNewRef(refName);
        } else {
            this.listenForRemoval();
        }
        standard.addXpathListener(HERE_XPATH, (XpathListener)new RefRenameListener(this.ref, this));
    }

    public String getStandardRefName(StandardDDBean standardRef) {
        String[] names = standardRef.getText(this.getRefNamePath());
        if (names == null || names.length == 0) {
            return "";
        }
        return names[0];
    }

    public BaseBean getRef() {
        return this.ref;
    }

    public BaseBean getParent() {
        return this.parent;
    }

    public StandardDDBean getStandard() {
        return this.standard;
    }

    public void addRef() {
        this.addRefToDD(this.ref);
        this.listenForRemoval();
    }

    private void listenForRemoval() {
        this.parentStandard.addXpathListener(HERE_XPATH, (XpathListener)new RefRemoveListener());
    }

    abstract String getRefNamePath();

    abstract String getIASRefName(BaseBean var1);

    abstract void getIASRefName(BaseBean var1, String var2);

    abstract BaseBean createNewRef(String var1);

    abstract CustomDialogPanel getPanel(BaseBean var1);

    public abstract String getRefPath();

    public abstract BaseBean[] getRefsFromDD();

    public abstract void removeRefFromDD(BaseBean var1);

    public abstract void addRefToDD(BaseBean var1);

    public abstract String getTypeName();

    public StandardDDBean getStandardDDBean() {
        return this.standard;
    }

    public String[] getXpaths() {
        return null;
    }

    public ConfigBean getConfigBean(StandardDDBean bean) {
        return null;
    }

    public void removeConfigBean(ConfigBean bean) {
    }

    public void notifyStandardDDBeanChanged() {
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.ref.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.ref.removePropertyChangeListener(pcl);
    }

    public static abstract class ResourceRefBean
    extends IASRefBean {
        private static String NAME_IN_REF_PATH = "res-ref-name";

        public ResourceRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
            super(parent, parentStandard, standard);
        }

        public String getRefNamePath() {
            return NAME_IN_REF_PATH;
        }

        String getIASRefName(BaseBean ref) {
            return ((ResourceRef)ref).getResRefName();
        }

        void getIASRefName(BaseBean ref, String name) {
            ((ResourceRef)ref).setResRefName(name);
        }

        BaseBean createNewRef(String name) {
            ResourceRef newRef = new ResourceRef();
            newRef.setResRefName(name);
            return newRef;
        }

        CustomDialogPanel getPanel(BaseBean ref) {
            return new IASResourceRefPanel((ResourceRef)ref);
        }
    }

    public static abstract class ResourceEnvRefBean
    extends IASRefBean {
        private static String NAME_IN_REF_PATH = "resource-env-ref-name";

        public ResourceEnvRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
            super(parent, parentStandard, standard);
        }

        public String getRefNamePath() {
            return NAME_IN_REF_PATH;
        }

        String getIASRefName(BaseBean ref) {
            return ((ResourceEnvRef)ref).getResourceEnvRefName();
        }

        void getIASRefName(BaseBean ref, String name) {
            ((ResourceEnvRef)ref).setResourceEnvRefName(name);
        }

        BaseBean createNewRef(String name) {
            ResourceEnvRef newRef = new ResourceEnvRef();
            newRef.setResourceEnvRefName(name);
            return newRef;
        }

        CustomDialogPanel getPanel(BaseBean ref) {
            return new IASResourceEnvRefPanel((ResourceEnvRef)ref);
        }
    }

    public static abstract class EjbRefBean
    extends IASRefBean {
        private static String NAME_IN_REF_PATH = "ejb-ref-name";

        public EjbRefBean(BaseBean parent, StandardDDBean parentStandard, StandardDDBean standard) {
            super(parent, parentStandard, standard);
        }

        public String getRefNamePath() {
            return NAME_IN_REF_PATH;
        }

        String getIASRefName(BaseBean ref) {
            return ((EjbRef)ref).getEjbRefName();
        }

        void getIASRefName(BaseBean ref, String name) {
            ((EjbRef)ref).setEjbRefName(name);
        }

        BaseBean createNewRef(String name) {
            EjbRef newRef = new EjbRef();
            newRef.setEjbRefName(name);
            return newRef;
        }

        CustomDialogPanel getPanel(BaseBean ref) {
            return new IASEJBRefPanel((EjbRef)ref);
        }
    }

    protected class RefRemoveListener
    implements XpathListener {
        public void fireXpathEvent(XpathEvent xpe) {
            if (xpe.isRemoveEvent() && xpe.getBean() == IASRefBean.this.standard) {
                IASRefBean.this.removeRefFromDD(IASRefBean.this.ref);
                IASRefBean.this.parentStandard.removeXpathListener(IASRefBean.HERE_XPATH, (XpathListener)this);
            }
        }
    }

    public static class RefRenameListener
    implements XpathListener {
        private IASRefBean refBean;
        private BaseBean refToRename;

        public RefRenameListener(BaseBean refToRename, IASRefBean refBean) {
            this.refToRename = refToRename;
            this.refBean = refBean;
        }

        public void fireXpathEvent(XpathEvent xpe) {
            if (xpe.isRemoveEvent()) {
                return;
            }
            StandardDDBean eventBean = xpe.getBean();
            StandardDDBean[] parentBean = eventBean.getChildBean(IASRefBean.PARENT_XPATH);
            if (parentBean != null && parentBean.length != 0 && parentBean[0] == this.refBean.getStandard() && eventBean.getXpath().endsWith(this.refBean.getRefNamePath())) {
                String newName = null;
                if (xpe.isChangeEvent()) {
                    newName = (String)xpe.getChangeEvent().getNewValue();
                } else {
                    String[] names = eventBean.getText(IASRefBean.HERE_XPATH);
                    if (names != null && names.length != 0) {
                        newName = names[0];
                    }
                }
                this.refBean.getIASRefName(this.refToRename, newName);
            }
        }
    }
}

