/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.appclient;

import com.iplanet.ias.tools.common.dd.EjbRef;
import com.iplanet.ias.tools.common.dd.ResourceEnvRef;
import com.iplanet.ias.tools.common.dd.ResourceRef;
import com.iplanet.ias.tools.common.dd.appclient.SunApplicationClient;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.Utils;
import com.iplanet.ias.tools.forte.appclient.IASACConfigBean;
import com.iplanet.ias.tools.forte.util.UTF8ArchiveEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import org.netbeans.modules.j2ee.deployment.api.ConfigBean;
import org.netbeans.modules.j2ee.deployment.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.api.StandardDDBean;
import org.netbeans.modules.j2ee.server.appasm.AppAssemblyCustomData;
import org.netbeans.modules.j2ee.server.appclient.AppClientConfigSupport;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.jarpackager.api.ArchiveEntry;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class IASAppClientSupport
implements AppClientConfigSupport {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$appclient$IASAppClientSupport == null ? (class$com$iplanet$ias$tools$forte$appclient$IASAppClientSupport = IASAppClientSupport.class$("com.iplanet.ias.tools.forte.appclient.IASAppClientSupport")) : class$com$iplanet$ias$tools$forte$appclient$IASAppClientSupport));
    public static final String IAS_APPCLIENT_DD_FILENAME = "META-INF/sun-application-client.xml";
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$appclient$IASAppClientSupport;

    public ConfigBean getClientConfigBean(StandardDDBean standard) {
        return new IASACConfigBean(standard);
    }

    public void saveClientConfigBean(ConfigBean bean, OutputStream out) throws IOException {
        ((IASACConfigBean)bean).save(out);
    }

    public ConfigBean restoreClientConfigBean(StandardDDBean standard, InputStream in) throws ConfigurationException {
        return new IASACConfigBean(standard, in);
    }

    public void exportClient(FileArchiveResource genericJar, InputStream config, AppAssemblyCustomData.ClientSupport data, File outFile) {
        Reporter.verbose("exportClient");
        try {
            SunApplicationClient info = SunApplicationClient.createGraph(config);
            if (info == null) {
                throw new ConfigurationException(bundle.getString("MSG_BadClientDD"));
            }
            IASAppClientSupport.createIASClientJar(genericJar, info, outFile);
        }
        catch (Exception e) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(bundle.getString("MSG_ErrorCreatingIASClientJar") + e), 0));
            e.printStackTrace();
            Reporter.critical(new StackTrace(e));
            return;
        }
    }

    public static void createIASClientJar(FileArchiveResource genericJar, SunApplicationClient info, File outFile) throws ConfigurationException, IOException {
        int i;
        Reporter.verbose("createIASClientJar");
        SunApplicationClient newInfo = new SunApplicationClient();
        int size = info.sizeResourceRef();
        Reporter.verbose("ResourceRef size :" + size);
        if (size > 0) {
            ResourceRef[] resourceRefArray = new ResourceRef[size];
            newInfo.setResourceRef(resourceRefArray);
            ResourceRef resourceRef = null;
            for (i = 0; i < size; ++i) {
                resourceRef = (ResourceRef)((Object)info.getResourceRef(i).clone());
                Reporter.verbose("ResourceRef(" + i + "): " + (Object)((Object)resourceRef));
                newInfo.setResourceRef(i, resourceRef);
            }
        }
        size = info.sizeEjbRef();
        Reporter.verbose("EjbRef size :" + size);
        EjbRef ejbRef = null;
        if (size > 0) {
            EjbRef[] ejbRefArray = new EjbRef[size];
            newInfo.setEjbRef(ejbRefArray);
            for (i = 0; i < size; ++i) {
                ejbRef = (EjbRef)((Object)info.getEjbRef(i).clone());
                Reporter.verbose("EjbRef(" + i + "): " + (Object)((Object)ejbRef));
                newInfo.setEjbRef(i, ejbRef);
            }
        }
        size = info.sizeResourceEnvRef();
        Reporter.verbose("ResourceEnvRef size :" + size);
        if (size > 0) {
            ResourceEnvRef[] resourceEnvRefArray = new ResourceEnvRef[size];
            newInfo.setResourceEnvRef(resourceEnvRefArray);
            ResourceEnvRef resourceEnvRef = null;
            for (int i2 = 0; i2 < size; ++i2) {
                resourceEnvRef = (ResourceEnvRef)((Object)info.getResourceEnvRef(i2).clone());
                Reporter.verbose("ResourceEnvRef(" + i2 + "): " + (Object)((Object)resourceEnvRef));
                newInfo.setResourceEnvRef(i2, resourceEnvRef);
            }
        }
        SunApplicationClient sunApplicationClient = new SunApplicationClient();
        Utils.purgeSunApplicationClient(newInfo, sunApplicationClient);
        Utils.setDocType(sunApplicationClient);
        newInfo = sunApplicationClient;
        String j2eeXml = Utils.getXmlAsString(newInfo);
        UTF8ArchiveEntry entry = new UTF8ArchiveEntry(IAS_APPCLIENT_DD_FILENAME, j2eeXml);
        Utils.addFilesToJar(genericJar.getFile(), outFile, new ArchiveEntry[]{entry});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

