/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.actions;

import com.iplanet.ias.tools.common.util.ViewLogInterval;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.actions.ViewThreadException;
import com.iplanet.ias.tools.forte.server.ServerInstanceBean;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.core.output.OutputTabTerm;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;

public class ViewThread
extends Thread
implements TopComponentListener {
    BufferedReader ins;
    String tabName;
    InputOutput inout;
    OutputWriter ow;
    boolean shouldStop = false;
    ServerInstanceBean server;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$actions$ViewThread;

    public ViewThread(File fileName, String nm, ServerInstanceBean s) throws ViewThreadException {
        Reporter.verbose("new ViewThread: " + fileName + "; " + nm);
        try {
            this.ins = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            this.inout = TopManager.getDefault().getIO(nm, false);
            if (this.inout instanceof OutputTabTerm) {
                ((OutputTabTerm)this.inout).setCloseOperation(0);
            }
            ((WindowManagerImpl)TopManager.getDefault().getWindowManager()).addTopComponentListener((TopComponentListener)this);
            this.ow = this.inout.getOut();
            this.tabName = nm;
            this.server = s;
        }
        catch (Exception ex) {
            throw new ViewThreadException(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$actions$ViewThread == null ? (class$com$iplanet$ias$tools$forte$actions$ViewThread = ViewThread.class$("com.iplanet.ias.tools.forte.actions.ViewThread")) : class$com$iplanet$ias$tools$forte$actions$ViewThread), (String)"EX_FILE"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.shouldStop) {
            try {
                String line;
                while ((line = this.ins.readLine()) != null) {
                    OutputWriter outputWriter = this.ow;
                    synchronized (outputWriter) {
                        this.ow.println(line);
                    }
                }
            }
            catch (IOException e) {
                NotifyUtil.showError(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$actions$ViewThread == null ? ViewThread.class$("com.iplanet.ias.tools.forte.actions.ViewThread") : class$com$iplanet$ias$tools$forte$actions$ViewThread), (String)"Err_Read"));
                TopManager.getDefault().getErrorManager().notify(65536, (Throwable)e);
            }
            try {
                do {
                    ViewThread.sleep(ViewLogInterval.getLogInterval());
                } while (this.inout.isClosed() && !this.shouldStop);
            }
            catch (Exception e) {
                TopManager.getDefault().getErrorManager().notify(65536, (Throwable)e);
            }
        }
        try {
            this.server.clearThread(this);
            this.ins.close();
            return;
        }
        catch (IOException io) {
            NotifyUtil.showError(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$actions$ViewThread == null ? (class$com$iplanet$ias$tools$forte$actions$ViewThread = ViewThread.class$("com.iplanet.ias.tools.forte.actions.ViewThread")) : class$com$iplanet$ias$tools$forte$actions$ViewThread), (String)"Err_Close"));
            Reporter.error(io);
        }
    }

    public String getTabName() {
        return this.tabName;
    }

    public InputOutput getIO() {
        return this.inout;
    }

    public void select() {
        this.inout.select();
    }

    public void topComponentClosed(TopComponentChangedEvent ev) {
        if (ev.topComponent == (TopComponent)this.inout) {
            this.shouldStop = true;
        }
    }

    public void topComponentOpened(TopComponentChangedEvent ev) {
    }

    public void topComponentActivated(TopComponentChangedEvent ev) {
    }

    public void selectedNodesChanged(SelectedNodesChangedEvent ev) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

