/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.util.diagnostics;

import com.iplanet.ias.tools.common.util.StringUtils;
import com.iplanet.ias.tools.common.util.diagnostics.IReporterEnum;
import com.iplanet.ias.tools.common.util.diagnostics.ReporterFrame;
import java.io.PrintStream;

public class ReporterWriter
implements IReporterEnum {
    private PrintStream out;
    private ReporterFrame frame = null;
    private int longestSeverityLength;
    private String title;

    protected ReporterWriter(String title) {
        this.title = title;
        this.out = System.out;
    }

    protected void println(int severity, String s) {
        String type = IReporterEnum.severityNames[severity];
        String msg = StringUtils.padRight(IReporterEnum.severityNames[severity], this.longestSeverityLength) + s;
        this.out.println(msg);
        this.getFrame().pr(msg);
    }

    private ReporterFrame getFrame() {
        if (this.frame == null) {
            this.frame = new ReporterFrame(this.title);
            this.frame.show();
            this.calcLongestString();
        }
        return this.frame;
    }

    private void calcLongestString() {
        int maxLen = 0;
        for (int i = 0; i < IReporterEnum.severityNames.length; ++i) {
            int len = IReporterEnum.severityNames[i].length();
            if (len <= maxLen) continue;
            maxLen = len;
        }
        this.longestSeverityLength = maxLen + 2;
    }
}

