/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.AssertError;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import com.iplanet.ias.admin.util.Validator;
import com.iplanet.ias.admin.util.ValidatorResult;

final class AssertImpl {
    private int mExceptionType = 0;
    private boolean mWantStackTrace = true;
    private String mPreamble = null;
    private static final String sDefaultPreamble = "Assertion Failure: ";
    static final int sAssertError = 0;
    static final int sIllegalArgument = 1;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(class$com$iplanet$ias$admin$util$AssertImpl == null ? (class$com$iplanet$ias$admin$util$AssertImpl = AssertImpl.class$("com.iplanet.ias.admin.util.AssertImpl")) : class$com$iplanet$ias$admin$util$AssertImpl);
    static /* synthetic */ Class class$com$iplanet$ias$admin$util$AssertImpl;

    AssertImpl(int exceptionType) {
        this("", exceptionType);
    }

    AssertImpl(String msg, int exceptionType) {
        this.mPreamble = msg;
        this.mExceptionType = exceptionType;
        if (this.mPreamble == null) {
            this.mPreamble = sDefaultPreamble;
        }
        if (this.mPreamble.length() > 0 && !this.mPreamble.endsWith(": ")) {
            this.mPreamble = this.mPreamble + ": ";
        }
        if (this.mExceptionType < 0 || this.mExceptionType > 1) {
            this.lowLevelAssert("Invalid exception type id.  Must be 0 or 1");
            this.mExceptionType = 0;
        }
    }

    void setWantStackTrace(boolean what) {
        this.mWantStackTrace = what;
    }

    void assertIt(boolean b, Object userMsg) {
        if (b) {
            return;
        }
        String msg = null;
        msg = userMsg != null ? userMsg.toString() : "boolean test was false";
        this.toss(msg);
    }

    void assertRange(long value, long min, long max, Object userMsg) {
        if (value < min || value > max) {
            String rangeString = "[" + min + ", " + max + "]";
            String msg = "illegal integer value = " + value + " must be in range " + rangeString;
            if (userMsg != null) {
                msg = msg + " ( " + userMsg.toString() + " )";
            }
            this.toss(msg);
        }
    }

    void assertValid(Object object, String name, Validator validator) {
        ValidatorResult result = validator.validate(object);
        if (!result.isValid()) {
            String msg = "Validation failed for " + name + ": " + result.getString();
            this.toss(msg);
        }
    }

    private void toss(String msg) throws IllegalArgumentException, AssertError {
        String s = this.mPreamble + msg;
        Object t = null;
        if (this.mExceptionType == 1) {
            IllegalArgumentException iae = new IllegalArgumentException(s);
            if (this.mWantStackTrace) {
                Debug.printStackTrace(iae);
            }
            throw iae;
        }
        if (this.mExceptionType == 0) {
            AssertError ae = new AssertError(s);
            if (this.mWantStackTrace) {
                Debug.printStackTrace(ae);
            }
            throw ae;
        }
        this.lowLevelAssert("Impossible condition -- bad mExceptionType -- " + this.mExceptionType);
    }

    private void pr(String s) {
        Debug.println(s);
    }

    private void lowLevelAssert(String s) {
        String msg = localizedStrMgr.getString("admin.util.fatal_error_in_setupexceptionconstructor", s);
        throw new AssertError(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

