/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ConfigurationController;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ServerComponentController
implements ConfigurationController {
    private static final String GET_DEFAULT_ATTRIBUTE_VALUE = "getDefaultAttributeValue";
    private ServerComponent serverComponent;

    public ServerComponentController(ServerComponent component) {
        this.serverComponent = component;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        Object value = null;
        String objId = this.serverComponent.getIdentifier();
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(objId);
        }
        catch (MalformedObjectNameException mone) {
            // empty catch block
        }
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        value = dispatcher.getAttribute(mbeanName, attribute);
        return value;
    }

    public void setAttribute(String attributeName, Object value) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        String objId = this.serverComponent.getIdentifier();
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(objId);
        }
        catch (MalformedObjectNameException mone) {
            // empty catch block
        }
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        dispatcher.setAttribute(mbeanName, attributeName, value);
    }

    public AttributeList getAttributes(String[] attributes) throws AFException {
        String objId = this.serverComponent.getIdentifier();
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(objId);
        }
        catch (MalformedObjectNameException mone) {
            // empty catch block
        }
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        AttributeList values = dispatcher.getAttributes(mbeanName, attributes);
        return values;
    }

    public AttributeList setAttributes(AttributeList al) throws AFException {
        String objId = this.serverComponent.getIdentifier();
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(objId);
        }
        catch (MalformedObjectNameException mone) {
            // empty catch block
        }
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        AttributeList values = dispatcher.setAttributes(mbeanName, al);
        return values;
    }

    public boolean applyChanges() throws AFException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean reconfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void backupConfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void restoreConfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public Object getDefaultAttributeValue(String attributeName) throws AFException {
        String objId = this.serverComponent.getIdentifier();
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName(objId);
        }
        catch (MalformedObjectNameException mone) {
            Debug.printStackTrace(mone);
        }
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{attributeName};
        Object value = dispatcher.invoke(mbeanName, GET_DEFAULT_ATTRIBUTE_VALUE, params, signature);
        return value;
    }
}

