/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.AuthRealm;
import com.iplanet.ias.admin.servermodel.beans.SecurityServiceComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class SecurityServiceComponentController
implements Controller {
    private static final String CREATE_AUTH_REALM = "createAuthRealm";
    private static final String DELETE_AUTH_REALM = "deleteAuthRealm";
    private static final String LIST_AUTH_REALMS = "listAuthRealms";
    private SecurityServiceComponentBean component;

    public SecurityServiceComponentController(SecurityServiceComponentBean component) {
        this.component = component;
    }

    public void createAuthRealm(String name, String className) throws AFException {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        ArgChecker.checkValid(className, "className", StringValidator.getInstance());
        this.invoke(CREATE_AUTH_REALM, new Object[]{name, className}, new String[]{"java.lang.String", "java.lang.String"});
    }

    public void deleteAuthRealm(String name) throws AFException {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        this.invoke(DELETE_AUTH_REALM, new Object[]{name}, new String[]{"java.lang.String"});
    }

    public ServerModelIterator getAuthRealms() throws AFException {
        Vector<AuthRealm> authRealms = new Vector<AuthRealm>();
        String[] authRealmNames = (String[])this.invoke(LIST_AUTH_REALMS, null, null);
        if (authRealmNames != null) {
            String instanceName = this.component.getInstanceName();
            for (int i = 0; i < authRealmNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getAuthRealmObjectName(instanceName, authRealmNames[i]);
                Assert.assertit(mbeanName != null, "null value returned");
                AuthRealm authRealm = new AuthRealm(mbeanName.toString(), authRealmNames[i]);
                authRealm.setContextHolder(this.component.getContextHolder());
                authRealms.add(authRealm);
            }
        }
        return new ServerModelIterator(authRealms);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.component.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

