/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.IiopListener;
import com.iplanet.ias.admin.servermodel.beans.ORBComponentBean;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class ORBComponentController
implements Controller {
    private static final String CREATE_IIOP_LISTENER = "createORBListener";
    private static final String DELETE_IIOP_LISTENER = "deleteORBListener";
    private static final String LIST_IIOP_LISTENERS = "listORBListeners";
    private static final String IS_SSL_CREATED = "isSslCreated";
    private static final String CREATE_SSL = "createSsl";
    private static final String DELETE_SSL = "deleteSsl";
    private ORBComponentBean orb;

    public ORBComponentController(ORBComponentBean orb) {
        this.orb = orb;
    }

    public void addIiopListener(String id, String address) throws AFException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
        Object[] params = new Object[]{id, address, null, null};
        this.invoke(CREATE_IIOP_LISTENER, params, signature);
    }

    public void removeIiopListener(String id) throws AFException {
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{id};
        this.invoke(DELETE_IIOP_LISTENER, params, signature);
    }

    public ServerModelIterator getIiopListeners() throws AFException {
        Vector<IiopListener> list = new Vector<IiopListener>();
        String[] listeners = (String[])this.invoke(LIST_IIOP_LISTENERS, null, null);
        if (listeners != null && listeners.length > 0) {
            String instanceName = null;
            try {
                ObjectName orbMBeanName = new ObjectName(this.orb.getIdentifier());
                instanceName = orbMBeanName.getKeyProperty("instance-name");
            }
            catch (Exception e) {
                throw new AFException(e.getLocalizedMessage());
            }
            for (int i = 0; i < listeners.length; ++i) {
                ObjectName listenerMBeanName = ObjectNames.getIiopListenerObjectName(instanceName, listeners[i]);
                Assert.assertit(listenerMBeanName != null, "null value returned");
                IiopListener iiopListener = new IiopListener(listenerMBeanName.toString(), listeners[i]);
                list.add(iiopListener);
            }
        }
        return new ServerModelIterator(list);
    }

    public boolean isSSLCreated() throws AFException {
        Object value = this.invoke(IS_SSL_CREATED, null, null);
        Assert.assertit(value != null, "null value returned");
        return (Boolean)value;
    }

    public void createSSL(String certNickName) throws AFException {
        ArgChecker.checkValid(certNickName, "certNickName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean"};
        Object[] params = new Object[]{certNickName, null, null, null, null, null, null, null};
        this.invoke(CREATE_SSL, params, signature);
    }

    public void deleteSSL() throws AFException {
        this.invoke(DELETE_SSL, null, null);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.orb.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.orb.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

