/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFOtherException;
import com.iplanet.ias.admin.servermodel.beans.LifeCycleModule;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class LifeCycleModuleController
implements Controller {
    private static final String ENABLE_MODULE = "enable";
    private static final String DISABLE_MODULE = "disable";
    private LifeCycleModule lfcModule;

    public LifeCycleModuleController(LifeCycleModule lModule) {
        this.lfcModule = lModule;
    }

    public boolean enable() {
        boolean isEnabled = false;
        try {
            this.invoke(ENABLE_MODULE, null, null);
            isEnabled = true;
        }
        catch (Exception e) {
            isEnabled = false;
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isEnabled;
    }

    public boolean disable() {
        boolean isDisbled = false;
        try {
            this.invoke(DISABLE_MODULE, null, null);
            isDisbled = true;
        }
        catch (Exception e) {
            isDisbled = false;
            Debug.println("Warning : Suppressing the exception");
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isDisbled;
    }

    private Object invoke(String operationName, Object[] params, String[] signature) throws AFException {
        ObjectName mbeanName = null;
        Object retValue = null;
        try {
            mbeanName = new ObjectName(this.lfcModule.getIdentifier());
            ContextHolder ctxHolder = this.lfcModule.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        }
        catch (MalformedObjectNameException mone) {
            throw new AFOtherException(mone);
        }
        return retValue;
    }
}

