/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.ACL;
import com.iplanet.ias.admin.servermodel.beans.HttpListener;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.Mime;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.StringValidator;
import java.util.Vector;
import javax.management.ObjectName;

public class HttpServiceComponentController
implements Controller {
    private static final String CREATE_HTTP_LISTENER = "createHTTPListener";
    private static final String DELETE_HTTP_LISTENER = "deleteHTTPListener";
    private static final String LIST_HTTP_LISTENERS = "listHTTPListeners";
    private static final String CREATE_HTTP_QOS = "createHttpQos";
    private static final String DELETE_HTTP_QOS = "deleteHttpQos";
    private static final String IS_HTTP_QOS_CREATED = "isHttpQosCreated";
    private static final String CREATE_MIME = "createMime";
    private static final String DELETE_MIME = "deleteMime";
    private static final String LIST_MIMES = "listMimes";
    private static final String CREATE_ACL = "createAcl";
    private static final String DELETE_ACL = "deleteAcl";
    private static final String LIST_ACLS = "listAcls";
    private HttpServiceComponentBean component;

    public HttpServiceComponentController(HttpServiceComponentBean component) {
        this.component = component;
    }

    public void createHttpListener(String id, String address, int port, String defaultVirtualServer, String serverName) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(address, "address", StringValidator.getInstance());
        ArgChecker.checkValid(defaultVirtualServer, "defaultVirtualServer", StringValidator.getInstance());
        ArgChecker.checkValid(serverName, "serverName", StringValidator.getInstance());
        Object[] params = new Object[]{id, address, new Integer(port), null, null, null, null, null, defaultVirtualServer, serverName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean", "java.lang.String", "java.lang.Integer", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
        this.invoke(CREATE_HTTP_LISTENER, params, signature);
    }

    public void deleteHttpListener(String id) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        Object[] params = new Object[]{id};
        String[] signature = new String[]{"java.lang.String"};
        this.invoke(DELETE_HTTP_LISTENER, params, signature);
    }

    public ServerModelIterator getHttpListeners() throws AFException {
        Vector<HttpListener> listeners = new Vector<HttpListener>();
        String[] listenerIds = (String[])this.invoke(LIST_HTTP_LISTENERS, null, null);
        if (listenerIds != null && listenerIds.length > 0) {
            String instanceName = this.component.getInstanceName();
            Assert.assertit(instanceName != null, "null value returned");
            for (int i = 0; i < listenerIds.length; ++i) {
                ObjectName mbeanName = ObjectNames.getHttpListenerObjectName(instanceName, listenerIds[i]);
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("HttpServiceComponentController.getHttpListeners : Http listener objectname = " + mbeanName);
                HttpListener listener = new HttpListener(mbeanName.toString(), listenerIds[i]);
                listener.setContextHolder(this.component.getContextHolder());
                listeners.add(listener);
            }
        }
        return new ServerModelIterator(listeners);
    }

    public boolean isHttpQosCreated() throws AFException {
        Boolean value = (Boolean)this.invoke(IS_HTTP_QOS_CREATED, null, null);
        Assert.assertit(value != null, "null value returned");
        return value;
    }

    public void createHttpQos() throws AFException {
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
        Object[] params = new Object[]{null, null, null, null};
        this.invoke(CREATE_HTTP_QOS, params, signature);
    }

    public void removeHttpQos() throws AFException {
        this.invoke(DELETE_HTTP_QOS, null, null);
    }

    public void createMime(String id, String file) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(file, "file", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{id, file};
        this.invoke(CREATE_MIME, params, signature);
    }

    public void removeMime(String id) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{id};
        this.invoke(DELETE_MIME, params, signature);
    }

    public ServerModelIterator getMimes() throws AFException {
        String[] mimes = (String[])this.invoke(LIST_MIMES, null, null);
        Vector<Mime> list = new Vector<Mime>();
        if (mimes != null && mimes.length > 0) {
            for (int i = 0; i < mimes.length; ++i) {
                String instanceName = this.component.getInstanceName();
                ObjectName mbeanName = ObjectNames.getMimeObjectName(instanceName, mimes[i]);
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("HttpServiceComponentController.getMimes: mbean = " + mbeanName);
                Mime mime = new Mime(mbeanName.toString(), mimes[i]);
                mime.setContextHolder(this.component.getContextHolder());
                list.add(mime);
            }
        }
        return new ServerModelIterator(list);
    }

    public void createAcl(String id, String file) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(file, "file", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{id, file};
        this.invoke(CREATE_ACL, params, signature);
    }

    public void removeAcl(String id) throws AFException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{id};
        this.invoke(DELETE_ACL, params, signature);
    }

    public ServerModelIterator getAcls() throws AFException {
        String[] acls = (String[])this.invoke(LIST_ACLS, null, null);
        Vector<ACL> list = new Vector<ACL>();
        if (acls != null && acls.length > 0) {
            for (int i = 0; i < acls.length; ++i) {
                String instanceName = this.component.getInstanceName();
                ObjectName mbeanName = ObjectNames.getAclObjectName(instanceName, acls[i]);
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("HttpServiceComponentController.getAcls: mbean = " + mbeanName);
                ACL acl = new ACL(mbeanName.toString(), acls[i]);
                acl.setContextHolder(this.component.getContextHolder());
                list.add(acl);
            }
        }
        return new ServerModelIterator(list);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        try {
            ContextHolder ctxHolder = this.component.getContextHolder();
            ObjectName mbeanName = new ObjectName(this.component.getIdentifier());
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            return dispatcher.invoke(mbeanName, operation, params, signature);
        }
        catch (Exception e) {
            if (e instanceof AFException) {
                throw (AFException)e;
            }
            throw new AFException(e.getLocalizedMessage());
        }
    }
}

