/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ByteChunk;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ParamInfo;
import com.iplanet.ias.admin.common.ServerInstanceStatus;
import com.iplanet.ias.admin.common.Status;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFResourceException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyRunningException;
import com.iplanet.ias.admin.common.exception.InstanceNotRunningException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.beans.CustomResource;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedConnectorComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.IiopEndpoint;
import com.iplanet.ias.admin.servermodel.beans.IiopServerInstance;
import com.iplanet.ias.admin.servermodel.beans.JDBCConnectionPool;
import com.iplanet.ias.admin.servermodel.beans.JDBCResource;
import com.iplanet.ias.admin.servermodel.beans.JMSResource;
import com.iplanet.ias.admin.servermodel.beans.JNDIResource;
import com.iplanet.ias.admin.servermodel.beans.JavaMailResource;
import com.iplanet.ias.admin.servermodel.beans.LifeCycleModule;
import com.iplanet.ias.admin.servermodel.beans.PersistenceManagerFactoryResource;
import com.iplanet.ias.admin.servermodel.beans.ServiceComponentBean;
import com.iplanet.ias.admin.servermodel.context.AdminContext;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ConfigurationController;
import com.iplanet.ias.admin.servermodel.controllers.DeploymentController;
import com.iplanet.ias.admin.servermodel.controllers.J2EEResourceController;
import com.iplanet.ias.admin.servermodel.controllers.LifeCycleController;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AppServerInstanceController
implements LifeCycleController,
DeploymentController,
ConfigurationController,
J2EEResourceController {
    private static final String START_INSTANCE = "start";
    private static final String START_INSTANCE_DEBUG = "startInDebugMode";
    private static final String GET_SECURITY_PASSWORD_TOKENS = "getSecurityPasswordTokens";
    private static final String STOP_INSTANCE = "stop";
    private static final String RESTART_INSTANCE = "restart";
    private static final String GET_STATUS = "getStatus";
    private static final String UPLOAD_OPERATION = "uploadToServer";
    private static final String GET_STUB_FILE_LOCATION = "getClientStubJarLocation";
    private static final String PREPARE_DOWNLOAD = "prepareDownload";
    private static final String DOWNLOAD_FILE = "downloadFile";
    private static final String DEPLOY_APPLICATION = "deployJ2EEApplication";
    private static final String DEPLOY_APPLICATION_DIR = "deployJ2EEApplicationDirectory";
    private static final String UNDEPLOY_APPLICATION = "undeployJ2EEApplication";
    private static final String GET_DEPLOYED_APPS = "getDeployedJ2EEApplications";
    private static final String DEPLOY_EJB_MODULE = "deployEJBJarModule";
    private static final String DEPLOY_EJB_MODULE_DIR = "deployEJBJarModuleDirectory";
    private static final String DEPLOY_WAR_MODULE = "deployWarModule";
    private static final String DEPLOY_WAR_MODULE_DIR = "deployWarModuleDirectory";
    private static final String DEPLOY_RAR_MODULE = "deployConnectorModule";
    private static final String DEPLOY_RAR_MODULE_DIR = "deployConnectorModuleDirectory";
    private static final String UNDEPLOY_MODULE = "undeployModule";
    private static final String LIST_EJB_MODULES = "getDeployedEJBModules";
    private static final String LIST_WEB_MODULES = "getDeployedWebModules";
    private static final String LIST_CONNECTORS = "getDeployedConnectors";
    private static final String CREATE_RESOURCE = "createResource";
    private static final String CREATE_JDBC_RESOURCE = "createJDBCResource";
    private static final String DELETE_JDBC_RESOURCE = "deleteJDBCResource";
    private static final String LIST_JDBC_RESOURCES = "listJDBCResources";
    private static final String CREATE_MAIL_RESOURCE = "createJavaMailResource";
    private static final String DELETE_MAIL_RESOURCE = "deleteJavaMailResource";
    private static final String LIST_MAIL_RESOURCES = "listJavaMailResources";
    private static final String CREATE_JMS_RESOURCE = "createJMSResource";
    private static final String DELETE_JMS_RESOURCE = "deleteJMSResource";
    private static final String LIST_JMS_RESOURCES = "listJMSResources";
    private static final String CREATE_JNDI_RESOURCE = "createJNDIResource";
    private static final String DELETE_JNDI_RESOURCE = "deleteJNDIResource";
    private static final String LIST_JNDI_RESOURCES = "listJNDIResources";
    private static final String CREATE_CUSTOM_RESOURCE = "createCustomResource";
    private static final String DELETE_CUSTOM_RESOURCE = "deleteCustomResource";
    private static final String LIST_CUSTOM_RESOURCES = "listCustomResources";
    private static final String CREATE_PM_FACTORY_RESOURCE = "createPersistenceManagerFactoryResource";
    private static final String DELETE_PM_FACTORY_RESOURCE = "deletePersistenceManagerFactoryResource";
    private static final String LIST_PM_FACTORY_RESOURCES = "listPersistenceManagerFactoryResources";
    private static final String CREATE_JDBC_CONNECTION_POOL = "createJDBCConnectionPool";
    private static final String DELETE_JDBC_CONNECTION_POOL = "deleteJDBCConnectionPool";
    private static final String LIST_JDBC_CONNECTION_POOLS = "listJDBCConnectionPools";
    private static final String APPLY_XML_CHANGES = "applyConfigChanges";
    private static final String OVERWRITE_XML_CHANGES = "overwriteConfigChanges";
    private static final String USE_MANUAL_XML_CHANGES = "useManualConfigChanges";
    private static final String IS_APPLY_NEEDED = "isApplyNeeded";
    private static final String IS_RESTART_NEEDED = "isRestartNeeded";
    private static final String CREATE_LIFE_CYCLE_MODULE = "createLifeCycleModule";
    private static final String DELETE_LIFE_CYCLE_MODULE = "deleteLifeCycleModule";
    private static final String LIST_LIFE_CYCLE_MODULES = "listLifeCycleModules";
    private static final String GET_DEFAULT_ATTRIBUTE_VALUE = "getDefaultAttributeValue";
    private static final String LIST_CERT_NICKNAMES = "getCertNicknames";
    private static final String GET_INSTANCE_ROOT = "getInstanceRoot";
    private static final String GET_USERNAMES = "getUserNames";
    private static final String GET_GROUPNAMES = "getGroupNames";
    private static final String GET_USERGROUPNAMES = "getUserGroupNames";
    private static final String ADD_USER = "addUser";
    private static final String REMOVE_USER = "removeUser";
    private static final String UPDATE_USER = "updateUser";
    private static final String CREATE_IIOP_ENDPOINT = "createIIOPEndpoint";
    private static final String DELETE_IIOP_ENDPOINT = "deleteIIOPEndpoint";
    private static final String DELETE_IIOP_CLUSTER = "deleteIIOPCluster";
    private static final String LIST_IIOP_CLUSTER_CONFIG = "getIIOPClusterConfig";
    private static final String DELETE_IIOP_CLUSTER_INSTANCE = "deleteIIOPClusterInstance";
    private static final String LIST_IIOP_CLUSTER_INSTANCES = "getIIOPClusterInstances";
    private static final String LIST_IIOP_INSTANCE_ENDPOINTS = "getIiopInstanceEndPoints";
    private AppServerInstance serverInstance;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController == null ? (class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController = AppServerInstanceController.class$("com.iplanet.ias.admin.servermodel.controllers.AppServerInstanceController")) : class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController);
    static /* synthetic */ Class class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController;

    public AppServerInstanceController(AppServerInstance si) {
        this.serverInstance = si;
    }

    public boolean start(Map startParams, int timeOutSeconds) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean start() throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        try {
            this.invoke(START_INSTANCE, null, null);
        }
        catch (AFException e) {
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            throw new ControlException(e.toString());
        }
        return true;
    }

    public String[] getSecurityPasswordTokens() throws AFException {
        return (String[])this.invoke(GET_SECURITY_PASSWORD_TOKENS, null, null);
    }

    public boolean startSecure(String[] passwords) throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        String[] signature = new String[]{"[Ljava.lang.String;"};
        Object[] params = new Object[]{passwords};
        try {
            this.invoke(START_INSTANCE, params, signature);
        }
        catch (AFException e) {
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            throw new ControlException(e.toString());
        }
        return true;
    }

    public int startSecureInDebugMode(String[] passwords) throws AFTargetNotFoundException, ControlException {
        String[] signature = new String[]{"[Ljava.lang.String;"};
        Object[] params = new Object[]{passwords};
        int port = 0;
        try {
            Object value = this.invoke(START_INSTANCE_DEBUG, params, signature);
            port = (Integer)value;
        }
        catch (AFException e) {
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            throw new ControlException(e.toString());
        }
        return port;
    }

    public boolean startInDebugMode(Map startParams, int timeOutSeconds) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public int startInDebugMode() throws AFTargetNotFoundException, ControlException {
        int port = 0;
        try {
            Object value = this.invoke(START_INSTANCE_DEBUG, null, null);
            port = (Integer)value;
        }
        catch (AFException e) {
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            throw new ControlException(e.toString());
        }
        return port;
    }

    public boolean restart(Map newParams, int timeOutSeconds) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean restart() throws AFTargetNotFoundException, ControlException {
        try {
            ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            ContextHolder ctxHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            dispatcher.invoke(mbeanName, RESTART_INSTANCE, null, null);
        }
        catch (AFException e) {
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            throw new ControlException(e.toString());
        }
        return true;
    }

    public boolean stop(Map stopParams, int timeOutSeconds) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean stop() throws AFTargetNotFoundException, InstanceNotRunningException, ControlException {
        try {
            ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            String[] signature = new String[]{"int"};
            Object[] params = new Object[]{new Integer(Integer.MAX_VALUE)};
            ContextHolder ctxHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            dispatcher.invoke(mbeanName, STOP_INSTANCE, params, signature);
        }
        catch (AFException e) {
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return true;
    }

    public boolean isRunning() throws AFException {
        boolean isRunning = false;
        Status status = this.getServerStatus();
        if (status.getStatusCode() == 0) {
            isRunning = true;
        }
        return isRunning;
    }

    public String getStatus() throws AFException {
        String str = null;
        Status status = this.getServerStatus();
        if (status != null) {
            str = status.getStatusString();
        }
        return str;
    }

    public String getDefaultModuleGroup() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public String getDefaultApplicationRoot() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getDeployedApplications() throws AFException {
        Vector<DeployedApplicationComponentBean> deployedApps = new Vector<DeployedApplicationComponentBean>();
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] apps = (String[])dispatcher.invoke(mbeanName, GET_DEPLOYED_APPS, null, null);
        if (apps != null && apps.length > 0) {
            for (int i = 0; i < apps.length; ++i) {
                ObjectName appId = ObjectNames.getApplicationObjectName(this.serverInstance.getName(), apps[i]);
                DeployedApplicationComponentBean dcb = new DeployedApplicationComponentBean(appId.toString(), apps[i]);
                dcb.setContextHolder(ctxHolder);
                deployedApps.add(dcb);
            }
        }
        return new ServerModelIterator(deployedApps);
    }

    public ServerModelIterator getEnabledApplications() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getEnabledModules() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getDeployedModules() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getDeployedEJBModules() throws AFException {
        Vector<DeployedEJBModuleComponentBean> deployedModules = new Vector<DeployedEJBModuleComponentBean>();
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] modules = (String[])dispatcher.invoke(mbeanName, LIST_EJB_MODULES, null, null);
        if (modules != null && modules.length > 0) {
            for (int i = 0; i < modules.length; ++i) {
                ObjectName moduleId = ObjectNames.getEjbModuleObjectName(this.serverInstance.getName(), modules[i]);
                DeployedEJBModuleComponentBean deployedComponent = new DeployedEJBModuleComponentBean(moduleId.toString(), modules[i], true);
                deployedComponent.setContextHolder(ctxHolder);
                deployedModules.add(deployedComponent);
            }
        }
        return new ServerModelIterator(deployedModules);
    }

    public ServerModelIterator getDeployedWebModules() throws AFException {
        Vector<DeployedWebModuleComponentBean> deployedModules = new Vector<DeployedWebModuleComponentBean>();
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] modules = (String[])dispatcher.invoke(mbeanName, LIST_WEB_MODULES, null, null);
        if (modules != null && modules.length > 0) {
            for (int i = 0; i < modules.length; ++i) {
                ObjectName moduleId = ObjectNames.getWebModuleObjectName(this.serverInstance.getName(), modules[i]);
                DeployedWebModuleComponentBean deployedComponent = new DeployedWebModuleComponentBean(moduleId.toString(), modules[i], true);
                deployedComponent.setContextHolder(ctxHolder);
                deployedModules.add(deployedComponent);
            }
        }
        return new ServerModelIterator(deployedModules);
    }

    public ServerModelIterator getDeployedConnectors() throws AFException {
        Vector<DeployedConnectorComponentBean> deployedConnectors = new Vector<DeployedConnectorComponentBean>();
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] modules = (String[])dispatcher.invoke(mbeanName, LIST_CONNECTORS, null, null);
        if (modules != null && modules.length > 0) {
            for (int i = 0; i < modules.length; ++i) {
                ObjectName moduleId = ObjectNames.getConnectorModuleObjectName(this.serverInstance.getName(), modules[i]);
                Assert.assertit(moduleId != null, "null value returned");
                DeployedConnectorComponentBean deployedComponent = new DeployedConnectorComponentBean(moduleId.toString(), modules[i], true);
                deployedComponent.setContextHolder(ctxHolder);
                deployedConnectors.add(deployedComponent);
            }
        }
        return new ServerModelIterator(deployedConnectors);
    }

    public boolean deployModule(String path) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModule(String path, String moduleGroup) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployEJBJarModule(String filePath, String moduleName) throws DeploymentException {
        boolean doUpload = true;
        return this.deployEJBJarModule(filePath, moduleName, true, false, doUpload);
    }

    public boolean redeployEJBJarModule(String filePath, String moduleName) throws DeploymentException {
        ArgChecker.checkValid(filePath, "filePath", StringValidator.getInstance());
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        boolean doUpload = true;
        return this.deployEJBJarModule(filePath, moduleName, true, false, doUpload);
    }

    public boolean deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, boolean bUpload) throws DeploymentException {
        ArgChecker.checkValid(filePath, "filePath", StringValidator.getInstance());
        try {
            String serverFilePath = bUpload ? this.doUpload(filePath, moduleName) : filePath;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] params = new Object[]{serverFilePath, moduleName, new Boolean(forceDeploy), new Boolean(bVerify)};
            return this.doDeploy(DEPLOY_EJB_MODULE, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployEJBJarModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, boolean bUpload, String availabilityEnabled) throws DeploymentException {
        ArgChecker.checkValid(filePath, "filePath", StringValidator.getInstance());
        try {
            String serverFilePath = bUpload ? this.doUpload(filePath, moduleName) : filePath;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean", "java.lang.String"};
            Object[] params = new Object[]{serverFilePath, moduleName, new Boolean(forceDeploy), new Boolean(bVerify), availabilityEnabled};
            return this.doDeploy(DEPLOY_EJB_MODULE, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployEJBJarModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy, boolean bVerify) throws DeploymentException {
        ArgChecker.checkValid(moduleDir, "moduleDir", StringValidator.getInstance());
        try {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] params = new Object[]{moduleDir, moduleName, new Boolean(forceDeploy), new Boolean(bVerify)};
            return this.doDeploy(DEPLOY_EJB_MODULE_DIR, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployEJBJarModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy, boolean bVerify, String availabilityEnabled) throws DeploymentException {
        ArgChecker.checkValid(moduleDir, "moduleDir", StringValidator.getInstance());
        try {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean", "java.lang.String"};
            Object[] params = new Object[]{moduleDir, moduleName, new Boolean(forceDeploy), new Boolean(bVerify), availabilityEnabled};
            return this.doDeploy(DEPLOY_EJB_MODULE_DIR, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployWarModuleDirectory(String moduleDir, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP) throws DeploymentException {
        ArgChecker.checkValid(moduleDir, "moduleDir", StringValidator.getInstance());
        ArgChecker.checkValid(contextRoot, "contextRoot");
        try {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
            Object[] params = new Object[]{moduleDir, webAppName, contextRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP)};
            return this.doDeploy(DEPLOY_WAR_MODULE_DIR, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployWarModuleDirectory(String moduleDir, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, String availabilityEnabled) throws DeploymentException {
        ArgChecker.checkValid(moduleDir, "moduleDir", StringValidator.getInstance());
        ArgChecker.checkValid(contextRoot, "contextRoot");
        try {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean", "java.lang.String"};
            Object[] params = new Object[]{moduleDir, webAppName, contextRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP), availabilityEnabled};
            return this.doDeploy(DEPLOY_WAR_MODULE_DIR, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean redeployWarModule(String filePath, String webAppName, String contextRoot) throws DeploymentException {
        ArgChecker.checkValid(webAppName, "webAppName", StringValidator.getInstance());
        boolean doUpload = true;
        return this.deployWarModule(filePath, webAppName, contextRoot, true, null, true, false, false, doUpload);
    }

    public boolean deployWarModule(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, boolean bUpload) throws DeploymentException {
        ArgChecker.checkValid(filePath, "filePath", StringValidator.getInstance());
        ArgChecker.checkValid(contextRoot, "contextRoot");
        try {
            String serverFilePath = bUpload ? this.doUpload(filePath, webAppName) : filePath;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
            Object[] params = new Object[]{serverFilePath, webAppName, contextRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP)};
            return this.doDeploy(DEPLOY_WAR_MODULE, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployWarModule(String filePath, String webAppName, String contextRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, boolean bUpload, String availabilityEnabled) throws DeploymentException {
        ArgChecker.checkValid(filePath, "filePath", StringValidator.getInstance());
        ArgChecker.checkValid(contextRoot, "contextRoot");
        try {
            String serverFilePath = bUpload ? this.doUpload(filePath, webAppName) : filePath;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean", "java.lang.String"};
            Object[] params = new Object[]{serverFilePath, webAppName, contextRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP), availabilityEnabled};
            return this.doDeploy(DEPLOY_WAR_MODULE, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployConnectorModule(String filePath, String moduleName) throws DeploymentException {
        boolean doUpload = true;
        return this.deployConnectorModule(filePath, moduleName, true, false, doUpload);
    }

    public boolean redeployConnectorModule(String filePath, String moduleName) throws DeploymentException {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        boolean doUpload = true;
        return this.deployConnectorModule(filePath, moduleName, true, false, doUpload);
    }

    public boolean deployConnectorModule(String filePath, String moduleName, boolean forceDeploy, boolean bVerify, boolean bUpload) throws DeploymentException {
        ArgChecker.checkValid(filePath, "filePath", StringValidator.getInstance());
        try {
            String serverFilePath = bUpload ? this.doUpload(filePath, moduleName) : filePath;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] params = new Object[]{serverFilePath, moduleName, new Boolean(forceDeploy), new Boolean(bVerify)};
            return this.doDeploy(DEPLOY_RAR_MODULE, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployConnectorModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy, boolean bVerify) throws DeploymentException {
        ArgChecker.checkValid(moduleDir, "moduleDir", StringValidator.getInstance());
        try {
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] params = new Object[]{moduleDir, moduleName, new Boolean(forceDeploy), new Boolean(bVerify)};
            return this.doDeploy(DEPLOY_RAR_MODULE_DIR, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployModuleInApplication(File application, String moduleName) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModuleInApplication(File application, String moduleName, String moduleGroup) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModuleDirectory(String moduleDir, boolean forceDeploy) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModuleDirectory(String moduleDir, String moduleName, boolean forceDeploy) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployApplication(String path, String applicationRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, boolean bUpload) throws DeploymentException {
        ArgChecker.checkValid(path, "path", StringValidator.getInstance());
        try {
            String serverFilePath = bUpload ? this.doUpload(path, applicationRoot) : path;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
            Object[] params = new Object[]{serverFilePath, applicationRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP)};
            return this.doDeploy(DEPLOY_APPLICATION, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployApplication(String path, String applicationRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, boolean bUpload, String availabilityEnabled) throws DeploymentException {
        ArgChecker.checkValid(path, "path", StringValidator.getInstance());
        try {
            String serverFilePath = bUpload ? this.doUpload(path, applicationRoot) : path;
            Assert.assertit(serverFilePath != null, "null value returned");
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean", "java.lang.String"};
            Object[] params = new Object[]{serverFilePath, applicationRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP), availabilityEnabled};
            return this.doDeploy(DEPLOY_APPLICATION, signature, params);
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean deployApplicationDirectory(String applicationDir, String applicationRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP) throws DeploymentException {
        ArgChecker.checkValid(applicationDir, "applicationDir", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
        Object[] params = new Object[]{applicationDir, applicationRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP)};
        return this.doDeploy(DEPLOY_APPLICATION_DIR, signature, params);
    }

    public boolean deployApplicationDirectory(String applicationDir, String applicationRoot, boolean bEnabled, String virtualServers, boolean forceDeploy, boolean bVerify, boolean bPrecompileJSP, String availabilityEnabled) throws DeploymentException {
        ArgChecker.checkValid(applicationDir, "applicationDir", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean", "java.lang.String"};
        Object[] params = new Object[]{applicationDir, applicationRoot, new Boolean(bEnabled), virtualServers, new Boolean(forceDeploy), new Boolean(bVerify), new Boolean(bPrecompileJSP), availabilityEnabled};
        return this.doDeploy(DEPLOY_APPLICATION_DIR, signature, params);
    }

    public boolean undeployModule(String moduleName, int moduleType) throws DeploymentException {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        if (moduleType != 1003 && moduleType != 1002 && moduleType != 1004) {
            throw new DeploymentException("Invalid module type");
        }
        try {
            String[] signature = new String[]{"java.lang.String", "int"};
            Object[] params = new Object[]{moduleName, new Integer(moduleType)};
            boolean status = this.doDeploy(UNDEPLOY_MODULE, signature, params);
            Debug.println("undeployModule : undeployment successful");
            return status;
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean undeployModule(String moduleName, String moduleGroup) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean undeployModuleInApplication(String applicationName, String moduleName) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean undeployApplication(String applicationName) throws DeploymentException {
        try {
            ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            ContextHolder ctxHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{applicationName};
            Object result = dispatcher.invoke(mbeanName, UNDEPLOY_APPLICATION, params, signature);
            Assert.assertit(result != null, "null value returned");
            Debug.println("undeployApplication : undeployment successful");
            return (Boolean)result;
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
    }

    public boolean undeployApplication(String applicationName, String applicationRoot) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean redeployApplication(String path, String applicationName) throws DeploymentException {
        ArgChecker.checkValid(applicationName, "applicationName", StringValidator.getInstance());
        boolean doUpload = true;
        return this.deployApplication(path, applicationName, true, null, true, false, false, doUpload);
    }

    public int getModuleType(String moduleName) {
        int moduleType = -1;
        try {
            ObjectName objectName = ObjectNames.getModuleObjectName(this.serverInstance.getName(), moduleName);
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(this.serverInstance.getContextHolder());
            ParamInfo paramInfo = new ParamInfo("getModuleType", moduleName);
            Object ret = dispatcher.invoke(objectName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
            moduleType = (Integer)ret;
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return moduleType;
    }

    public boolean reconfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        Object value = null;
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        value = dispatcher.getAttribute(mbeanName, attributeName);
        return value;
    }

    public AttributeList getAttributes(String[] attributes) throws AFException {
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        AttributeList values = dispatcher.getAttributes(mbeanName, attributes);
        return values;
    }

    public void setAttribute(String attributeName, Object value) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        dispatcher.setAttribute(mbeanName, attributeName, value);
    }

    public AttributeList setAttributes(AttributeList al) throws AFException {
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        AttributeList values = dispatcher.setAttributes(mbeanName, al);
        return values;
    }

    public Object getDefaultAttributeValue(String attributeName) throws AFException {
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(mbeanName != null, "null value returned");
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{attributeName};
        Object value = dispatcher.invoke(mbeanName, GET_DEFAULT_ATTRIBUTE_VALUE, params, signature);
        return value;
    }

    public void retrieveApplication(String applicationName, File localDir) throws IOException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void retrieveModule(String moduleName, File localDir) throws IOException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean isApplyNeeded() throws AFException {
        return this.isApplyNeeded(true);
    }

    public boolean isApplyNeeded(boolean checkAllFiles) throws AFException {
        boolean shouldApply = false;
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        String[] signature = new String[]{"boolean"};
        Object[] params = new Object[]{new Boolean(checkAllFiles)};
        Object result = dispatcher.invoke(mbeanName, IS_APPLY_NEEDED, params, signature);
        shouldApply = (Boolean)result;
        return shouldApply;
    }

    public boolean isRestartNeeded() throws AFException {
        boolean restart = false;
        Object result = this.invoke(IS_RESTART_NEEDED, null, null);
        Assert.assertit(result != null, "null value returned");
        restart = (Boolean)result;
        return restart;
    }

    public boolean applyChanges() throws AFException {
        boolean requiresRestart = false;
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        Object result = dispatcher.invoke(mbeanName, APPLY_XML_CHANGES, null, null);
        requiresRestart = (Boolean)result;
        Debug.println("AppServerInstanceController.applyChanges : requires restart = " + requiresRestart);
        return requiresRestart;
    }

    public boolean overwriteChanges() throws AFException {
        boolean requiresRestart = false;
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        Object result = dispatcher.invoke(mbeanName, OVERWRITE_XML_CHANGES, null, null);
        requiresRestart = (Boolean)result;
        Debug.println("AppServerInstanceController.useManualchanges : requires restart = " + requiresRestart);
        return requiresRestart;
    }

    public boolean useManualChanges() throws AFException {
        boolean requiresRestart = false;
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        Object result = dispatcher.invoke(mbeanName, USE_MANUAL_XML_CHANGES, null, null);
        requiresRestart = (Boolean)result;
        Debug.println("AppServerInstanceController.useManualchanges : requires restart = " + requiresRestart);
        return requiresRestart;
    }

    public void restoreConfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void backupConfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServiceComponentBean getWebContainer() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void createResource(String xmlFile) throws AFResourceException {
        ArgChecker.checkValid(xmlFile, "xmlFile", StringValidator.getInstance());
        String serverFilePath = null;
        try {
            serverFilePath = this.doUpload(xmlFile, null);
        }
        catch (AFException e) {
            throw new AFResourceException(e.getLocalizedMessage());
        }
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{serverFilePath};
        this.invokeResourceOperation(CREATE_RESOURCE, params, signature);
    }

    public void createJDBCConnectionPool(String id, String datasourceClassName) throws AFResourceException {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        ArgChecker.checkValid(datasourceClassName, "datasourceClassName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{id, datasourceClassName};
        this.invokeResourceOperation(CREATE_JDBC_CONNECTION_POOL, params, signature);
    }

    public void deleteJDBCConnectionPool(String poolName) throws AFResourceException {
        ArgChecker.checkValid(poolName, "poolName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{poolName};
        this.invokeResourceOperation(DELETE_JDBC_CONNECTION_POOL, params, signature);
    }

    public JDBCConnectionPool getJDBCConnectionPool(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJDBCConnectionPools() throws AFException {
        Vector<JDBCConnectionPool> v = new Vector<JDBCConnectionPool>();
        String[] poolNames = (String[])this.invokeResourceOperation(LIST_JDBC_CONNECTION_POOLS, null, null);
        if (poolNames != null && poolNames.length > 0) {
            for (int i = 0; i < poolNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getJDBCConnectionPoolObjectName(this.serverInstance.getName(), poolNames[i]);
                JDBCConnectionPool pool = new JDBCConnectionPool(mbeanName.toString(), poolNames[i]);
                pool.setContextHolder(this.serverInstance.getContextHolder());
                v.add(pool);
            }
        }
        return new ServerModelIterator(v);
    }

    public void createJDBCResource(String jndiName, String poolName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(poolName, "poolName", StringValidator.getInstance());
        Debug.println("AppServerInstanceController.createJDBCResource: jndiName = " + jndiName + "poolName = " + poolName);
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{jndiName, poolName};
        this.invokeResourceOperation(CREATE_JDBC_RESOURCE, params, signature);
    }

    public void deleteJDBCResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        Debug.println("AppServerInstanceController.deleteJDBCResource: jndiName = " + jndiName);
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(DELETE_JDBC_RESOURCE, params, signature);
    }

    public JDBCResource getJDBCResource(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJDBCResources() throws AFException {
        Debug.println("AppServerInstanceController.listJDBCResources");
        Vector<JDBCResource> v = new Vector<JDBCResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_JDBC_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getJDBCResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                JDBCResource resource = new JDBCResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public void createJMSResource(String jndiName, String resourceType) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(resourceType, "resourceType", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{jndiName, resourceType};
        this.invokeResourceOperation(CREATE_JMS_RESOURCE, params, signature);
    }

    public void deleteJMSResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(DELETE_JMS_RESOURCE, params, signature);
    }

    public JMSResource getJMSResource(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJMSResources() throws AFException {
        Vector<JMSResource> v = new Vector<JMSResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_JMS_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getJMSResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                JMSResource resource = new JMSResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public ServerModelIterator getJMSDestResources() throws AFException {
        Vector<JMSResource> v = new Vector<JMSResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_JMS_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getJMSResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                JMSResource resource = new JMSResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                String resType = (String)resource.getAttribute("resType");
                if (!resType.equals("javax.jms.Topic") && !resType.equals("javax.jms.Queue")) continue;
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public ServerModelIterator getJMSConnResources() throws AFException {
        Vector<JMSResource> v = new Vector<JMSResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_JMS_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getJMSResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                JMSResource resource = new JMSResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                String resType = (String)resource.getAttribute("resType");
                if (!resType.equals("javax.jms.TopicConnectionFactory") && !resType.equals("javax.jms.QueueConnectionFactory")) continue;
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public void createJNDIResource(String jndiName, String jndiLookupName, String resourceType, String factoryClass) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(jndiLookupName, "jndiLookupName", StringValidator.getInstance());
        ArgChecker.checkValid(resourceType, "resourceType", StringValidator.getInstance());
        ArgChecker.checkValid(factoryClass, "factoryClass", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{jndiName, jndiLookupName, resourceType, factoryClass};
        this.invokeResourceOperation(CREATE_JNDI_RESOURCE, params, signature);
    }

    public void deleteJNDIResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(DELETE_JNDI_RESOURCE, params, signature);
    }

    public JNDIResource getJNDIResource(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJNDIResources() throws AFException {
        Vector<JNDIResource> v = new Vector<JNDIResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_JNDI_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getJNDIResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                JNDIResource resource = new JNDIResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public void createJavaMailResource(String jndiName, String host, String user, String fromAddress) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(host, "host", StringValidator.getInstance());
        ArgChecker.checkValid(user, "user", StringValidator.getInstance());
        ArgChecker.checkValid(fromAddress, "fromAddress", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{jndiName, host, user, fromAddress};
        this.invokeResourceOperation(CREATE_MAIL_RESOURCE, params, signature);
    }

    public void deleteJavaMailResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(DELETE_MAIL_RESOURCE, params, signature);
    }

    public JavaMailResource getJavaMailResource(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJavaMailResources() throws AFException {
        Vector<JavaMailResource> v = new Vector<JavaMailResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_MAIL_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getMailResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                JavaMailResource resource = new JavaMailResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public void createPersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(CREATE_PM_FACTORY_RESOURCE, params, signature);
    }

    public void deletePersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(DELETE_PM_FACTORY_RESOURCE, params, signature);
    }

    public PersistenceManagerFactoryResource getPersistenceManagerFactoryResource(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getPersistenceManagerFactoryResources() throws AFException {
        Vector<PersistenceManagerFactoryResource> v = new Vector<PersistenceManagerFactoryResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_PM_FACTORY_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getPersistenceManagerFactoryResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                PersistenceManagerFactoryResource resource = new PersistenceManagerFactoryResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    public void createCustomResource(String jndiName, String resourceType, String factoryClass) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(resourceType, "resourceType", StringValidator.getInstance());
        ArgChecker.checkValid(factoryClass, "factoryClass", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{jndiName, resourceType, factoryClass};
        this.invokeResourceOperation(CREATE_CUSTOM_RESOURCE, params, signature);
    }

    public void deleteCustomResource(String jndiName) throws AFResourceException {
        ArgChecker.checkValid(jndiName, "jndiName", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{jndiName};
        this.invokeResourceOperation(DELETE_CUSTOM_RESOURCE, params, signature);
    }

    public CustomResource getCustomResource(String jndiName) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getCustomResources() throws AFException {
        Vector<CustomResource> v = new Vector<CustomResource>();
        String[] jndiNames = (String[])this.invokeResourceOperation(LIST_CUSTOM_RESOURCES, null, null);
        if (jndiNames != null && jndiNames.length > 0) {
            for (int i = 0; i < jndiNames.length; ++i) {
                ObjectName mbeanName = ObjectNames.getCustomResourceObjectName(this.serverInstance.getName(), jndiNames[i]);
                CustomResource resource = new CustomResource(mbeanName.toString(), jndiNames[i]);
                resource.setContextHolder(this.serverInstance.getContextHolder());
                v.add(resource);
            }
        }
        return new ServerModelIterator(v);
    }

    private String doUpload(String filePath, String name) throws AFException {
        String serverFilePath = null;
        serverFilePath = this.isUploadRequired() ? this.uploadFile(filePath, name) : filePath;
        return serverFilePath;
    }

    private String uploadFile(String filePath, String name) throws AFException {
        String remotePath = null;
        try {
            ObjectName mbeanName = ObjectNames.getControllerObjectName();
            ContextHolder ctxHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            File f = new File(filePath);
            RandomAccessFile file = new RandomAccessFile(f, "r");
            String fileName = null;
            if (name != null && name.length() > 0) {
                int lastDot = filePath.lastIndexOf(".");
                if (lastDot != -1) {
                    String ext = filePath.substring(lastDot);
                    fileName = name + ext;
                }
            } else {
                fileName = f.getName();
            }
            Debug.println("UploadFile : fileName = " + fileName);
            byte[] bytes = new byte[65536];
            int bytesRead = 0;
            long totalBytesRead = 0L;
            boolean isFirstChunk = true;
            boolean isLastChunk = false;
            long fileSize = file.length();
            int index = 0;
            long begin = System.currentTimeMillis();
            while ((bytesRead = file.read(bytes)) != -1) {
                totalBytesRead += (long)bytesRead;
                if (bytesRead < bytes.length) {
                    byte[] realBytes = new byte[bytesRead];
                    for (int i = 0; i < bytesRead; ++i) {
                        realBytes[i] = bytes[i];
                    }
                    bytes = realBytes;
                }
                if (totalBytesRead == fileSize) {
                    isLastChunk = true;
                }
                ByteChunk aChunk = new ByteChunk(bytes, fileName, isFirstChunk, isLastChunk);
                aChunk.setTargetDir(this.serverInstance.getName());
                ParamInfo paramInfo = new ParamInfo(UPLOAD_OPERATION, aChunk);
                Object result = dispatcher.invoke(mbeanName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
                remotePath = (String)result;
                Debug.println("DEBUG : Chunk[" + index + "] sent");
                ++index;
                isFirstChunk = false;
            }
            long end = System.currentTimeMillis();
            Debug.println("Time to transfer : " + (end - begin) + " ms");
            Debug.println("File transferred to " + remotePath);
        }
        catch (IOException e) {
            throw new AFException(e.getLocalizedMessage());
        }
        return remotePath;
    }

    private boolean doDeploy(String operation, String[] signature, Object[] params) throws DeploymentException {
        boolean dynamicDeploySuccess = true;
        try {
            ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            Debug.println("doDeploy : instance object name = " + mbeanName.toString());
            ContextHolder ctxHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            Object result = dispatcher.invoke(mbeanName, operation, params, signature);
            Assert.assertit(result != null, "null value returned");
            Debug.println("doDeploy : deployment operation successful");
            dynamicDeploySuccess = (Boolean)result;
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(e.getLocalizedMessage());
        }
        return dynamicDeploySuccess;
    }

    public Status getServerStatus() throws AFException {
        ObjectName mbeanName = null;
        ServerInstanceStatus status = null;
        mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        Object value = dispatcher.invoke(mbeanName, GET_STATUS, null, null);
        status = (ServerInstanceStatus)value;
        Assert.assertit(status != null, "null value returned");
        return status;
    }

    private boolean isUploadRequired() {
        AdminContext ctx = this.serverInstance.getContextHolder().getAdminContext();
        return !ctx.isLocal();
    }

    private Object invokeResourceOperation(String operation, Object[] params, String[] signature) throws AFResourceException {
        Object retValue = null;
        ObjectName serverMBeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(serverMBeanName != null, "null value returned");
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(this.serverInstance.getContextHolder());
        try {
            retValue = dispatcher.invoke(serverMBeanName, operation, params, signature);
        }
        catch (AFException e) {
            if (e instanceof AFResourceException) {
                throw (AFResourceException)e;
            }
            throw new AFResourceException(e.getLocalizedMessage());
        }
        return retValue;
    }

    public void createLifeCycleModule(String name, String className) throws AFException {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        ArgChecker.checkValid(className, "className", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{name, className};
        this.invoke(CREATE_LIFE_CYCLE_MODULE, params, signature);
    }

    public void removeLifeCycleModule(String name) throws AFException {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{name};
        this.invoke(DELETE_LIFE_CYCLE_MODULE, params, signature);
    }

    public ServerModelIterator getLifeCycleModules() throws AFException {
        String[] modules = (String[])this.invoke(LIST_LIFE_CYCLE_MODULES, null, null);
        Vector<LifeCycleModule> list = new Vector<LifeCycleModule>();
        if (modules != null && modules.length > 0) {
            String instanceName = this.serverInstance.getName();
            for (int i = 0; i < modules.length; ++i) {
                ObjectName mbeanName = ObjectNames.getLifeCycleModuleObjectName(instanceName, modules[i]);
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("AppServerInstanceController.getLifeCycleModules: mbeanName = " + mbeanName);
                LifeCycleModule module = new LifeCycleModule(mbeanName.toString(), modules[i]);
                module.setContextHolder(this.serverInstance.getContextHolder());
                list.add(module);
            }
        }
        return new ServerModelIterator(list);
    }

    public String exportClientStubs(String appName, int appType, String destDir) throws AFException {
        ArgChecker.checkValid(appName, "appName", StringValidator.getInstance());
        if (appType != 1001 && appType != 1003) {
            String msg = localizedStrMgr.getString("admin.servermodel.controller.invalid_app_type");
            throw new AFException(msg);
        }
        File f = new File(destDir);
        if (!f.exists()) {
            String msg = localizedStrMgr.getString("admin.servermodel.controller.desstdir_does_not_exist", destDir);
            throw new AFException(msg);
        }
        if (!f.isDirectory()) {
            String msg = localizedStrMgr.getString("admin.servermodel.controller.desstdir_is_not_directory", destDir);
            throw new AFException(msg);
        }
        if (!f.canWrite()) {
            String msg = localizedStrMgr.getString("admin.servermodel.controller.cannot_write_to_destdir", destDir);
            throw new AFException(msg);
        }
        Object[] params = new Object[]{appName, new Integer(appType)};
        String[] signature = new String[]{"java.lang.String", "int"};
        String filePath = (String)this.invoke(GET_STUB_FILE_LOCATION, params, signature);
        String fileName = appName + "Client.jar";
        this.downloadFile(filePath, destDir, fileName);
        String exportedFileLocation = new File(destDir, fileName).getAbsolutePath();
        return exportedFileLocation;
    }

    public String[] getCertNickNames() throws AFException {
        String[] certNickNames = (String[])this.invoke(LIST_CERT_NICKNAMES, null, null);
        return certNickNames;
    }

    public String getInstanceRoot() throws AFException {
        return (String)this.invoke(GET_INSTANCE_ROOT, null, null);
    }

    public String[] getUserNames() throws AFException {
        return (String[])this.invoke(GET_USERNAMES, null, null);
    }

    public String[] getGroupNames() throws AFException {
        return (String[])this.invoke(GET_GROUPNAMES, null, null);
    }

    public String[] getUserGroupNames(String userName) throws AFException {
        Object[] params = new Object[]{userName};
        String[] signature = new String[]{"java.lang.String"};
        return (String[])this.invoke(GET_USERGROUPNAMES, params, signature);
    }

    public void addUser(String userName, String password, String[] groupList) throws AFException {
        Object[] params = new Object[]{userName, password, groupList};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.String;"};
        this.invoke(ADD_USER, params, signature);
    }

    public void removeUser(String userName) throws AFException {
        Object[] params = new Object[]{userName};
        String[] signature = new String[]{"java.lang.String"};
        this.invoke(REMOVE_USER, params, signature);
    }

    public void updateUser(String userName, String password, String[] groupList) throws AFException {
        Object[] params = new Object[]{userName, password, groupList};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.String;"};
        this.invoke(UPDATE_USER, params, signature);
    }

    private Object invoke(String operation, Object[] params, String[] signature) throws AFException {
        ContextHolder ctxHolder = this.serverInstance.getContextHolder();
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        return dispatcher.invoke(mbeanName, operation, params, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadFile(String filePath, String destinationDirPath, String appName) throws AFException {
        File destDir = new File(destinationDirPath);
        if (!destDir.exists()) {
            String msg = localizedStrMgr.getString("admin.servermodel.controller.destinationdirpath_does_not_exist", destinationDirPath);
            throw new AFException(msg);
        }
        FileOutputStream fos = null;
        try {
            try {
                ObjectName controllerObjectName = ObjectNames.getControllerObjectName();
                SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(this.serverInstance.getContextHolder());
                dispatcher.invoke(controllerObjectName, PREPARE_DOWNLOAD, new Object[]{filePath}, new String[]{"java.lang.String"});
                fos = new FileOutputStream(new File(destinationDirPath, appName));
                boolean lastChunk = false;
                int chunkIndex = 0;
                while (!lastChunk) {
                    Object[] params = new Object[]{new Integer(chunkIndex)};
                    String[] signature = new String[]{"int"};
                    ByteChunk chunk = (ByteChunk)dispatcher.invoke(controllerObjectName, DOWNLOAD_FILE, params, signature);
                    ++chunkIndex;
                    lastChunk = chunk.isLast();
                    byte[] bytes = chunk.getBytes();
                    fos.write(bytes, 0, bytes.length);
                }
                Object var15_16 = null;
                if (fos == null) return;
            }
            catch (IOException e) {
                throw new AFException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        fos.close();
        return;
    }

    public void createIIOPEndpoint(String instanceName, String id, String host, String port) throws AFException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{instanceName, id, host, port};
        this.invoke(CREATE_IIOP_ENDPOINT, params, signature);
    }

    public void deleteIIOPEndpoint(String instanceName, String endpointId) throws AFException {
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        Object[] params = new Object[]{instanceName, endpointId};
        this.invoke(DELETE_IIOP_ENDPOINT, params, signature);
    }

    public void deleteIIOPCluster() throws AFException {
        this.invoke(DELETE_IIOP_CLUSTER, null, null);
    }

    public String getIIOPClusterConfig() throws AFException {
        return (String)this.invoke(LIST_IIOP_CLUSTER_CONFIG, null, null);
    }

    public boolean getConfigurationFile(String destPath) throws AFException {
        boolean status = false;
        String instanceRoot = this.getInstanceRoot();
        String confFilePath = instanceRoot + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "server.xml";
        try {
            File destD = new File(destPath);
            this.downloadFile(confFilePath, destD.getParent(), destD.getName());
            status = true;
        }
        catch (Exception e) {
            System.out.println("downloading the server conf file failed .");
            e.printStackTrace();
        }
        return status;
    }

    public void deleteIIOPClusterInstance(String name) throws AFException {
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{name};
        this.invoke(DELETE_IIOP_CLUSTER_INSTANCE, params, signature);
    }

    public ServerModelIterator getIIOPClusterInstances() throws AFException {
        Vector<IiopServerInstance> v = new Vector<IiopServerInstance>();
        String[] names = (String[])this.invoke(LIST_IIOP_CLUSTER_INSTANCES, null, null);
        if (names != null && names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                ObjectName mbeanName = ObjectNames.getIIOPClusterInstanceObjectName(this.serverInstance.getName(), names[i]);
                IiopServerInstance instance = new IiopServerInstance(mbeanName.toString(), names[i]);
                instance.setContextHolder(this.serverInstance.getContextHolder());
                v.add(instance);
            }
        }
        return new ServerModelIterator(v);
    }

    public ServerModelIterator getIiopEndpoints(String instanceName) throws AFException {
        Vector<IiopEndpoint> v = new Vector<IiopEndpoint>();
        Object[] params = new Object[]{instanceName};
        String[] signature = new String[]{"java.lang.String"};
        String[] names = (String[])this.invoke(LIST_IIOP_INSTANCE_ENDPOINTS, params, signature);
        if (names != null && names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                ObjectName mbeanName = ObjectNames.getIIOPEndpointObjectName(this.serverInstance.getName(), instanceName, names[i]);
                IiopEndpoint instance = new IiopEndpoint(mbeanName.toString(), names[i]);
                instance.setContextHolder(this.serverInstance.getContextHolder());
                v.add(instance);
            }
        }
        return new ServerModelIterator(v);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

