/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.JVMComponentController;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class JVMComponentBean
extends ServerComponent
implements Serializable {
    private static final String JVM = "Java Virtual Machine";
    private transient JVMComponentController controller = new JVMComponentController(this);

    public JVMComponentBean(String identifier) {
        super(identifier, JVM);
    }

    public Controller getController() {
        return this.controller;
    }

    public String[] getJvmOptions() throws AFException {
        return this.controller.getJvmOptions();
    }

    public void setJvmOptions(String[] options) throws AFException {
        this.controller.setJvmOptions(options);
    }

    public void createProfiler(String name) throws AFException {
        this.controller.createProfiler(name);
    }

    public boolean isProfilerExists() throws AFException {
        return this.controller.isProfilerExists();
    }

    public Profiler getProfiler() throws AFException {
        return this.controller.getProfiler();
    }

    public Profiler getProfiler(String name) {
        ArgChecker.checkValid(name, "name", StringValidator.getInstance());
        ObjectName mbeanName = ObjectNames.getProfilerObjectName(this.getInstanceName());
        Assert.assertit(mbeanName != null, "null value returned");
        Profiler profiler = new Profiler(mbeanName.toString(), name);
        profiler.setContextHolder(this.getContextHolder());
        return profiler;
    }

    public void deleteProfiler() throws AFException {
        this.controller.deleteProfiler();
    }

    public String getInstanceName() {
        String instanceName = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            instanceName = mbeanName.getKeyProperty("instance-name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return instanceName;
    }
}

