/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.DeployedComponent;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.DeployedApplicationComponentController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class DeployedApplicationComponentBean
extends DeployedComponent
implements Serializable {
    private transient DeployedApplicationComponentController controller = new DeployedApplicationComponentController(this);

    public DeployedApplicationComponentBean(String identifier, String displayName) {
        super(identifier, displayName);
    }

    public Controller getController() {
        return this.controller;
    }

    public ServerModelIterator getEJBModules() throws AFException {
        return this.controller.getEJBModules();
    }

    public DeployedEJBModuleComponentBean getEJBModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        String appName = this.getAppName();
        ObjectName identifier = ObjectNames.getEjbModuleObjectName(instanceName, moduleName, appName);
        Assert.assertit(identifier != null, "null value returned");
        Debug.println("DeployedApplicationComponentBean.getEJBModule: mbeanName = " + identifier);
        DeployedEJBModuleComponentBean module = new DeployedEJBModuleComponentBean(identifier.toString(), moduleName, false);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    public ServerModelIterator getWebModules() throws AFException {
        return this.controller.getWebModules();
    }

    public DeployedWebModuleComponentBean getWebModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        String appName = this.getAppName();
        ObjectName identifier = ObjectNames.getWebModuleObjectName(instanceName, moduleName, appName);
        Assert.assertit(identifier != null, "null value returned");
        Debug.println("DeployedApplicationComponentBean.getWebModule: mbeanName = " + identifier);
        DeployedWebModuleComponentBean module = new DeployedWebModuleComponentBean(identifier.toString(), moduleName, false);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    public String[] getAllModules() throws AFException {
        return this.controller.getAllModules();
    }

    public boolean isEnabled() throws AFException {
        return this.controller.isEnabled();
    }

    public boolean enable() throws AFException {
        return this.controller.enable();
    }

    public boolean disable() throws AFException {
        return this.controller.disable();
    }

    public String getStatus() throws AFException {
        return this.controller.getStatus();
    }

    public Serializable getJ2EEDescriptor() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public Serializable getIASDescriptor() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o instanceof DeployedApplicationComponentBean) {
            DeployedApplicationComponentBean that = (DeployedApplicationComponentBean)o;
            isEqual = this.identifier.equals(that.identifier);
        }
        return isEqual;
    }

    public String getInstanceName() {
        String instanceName = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            instanceName = mbeanName.getKeyProperty("instance-name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return instanceName;
    }

    public String getAppName() {
        return this.getDisplayName();
    }
}

